set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9228176';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-6-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      '0442133',
      NULL,
      NULL,
      4,
      NULL,
      '2443',
      0,
      1,
      NULL,
      NULL,
      ' 1-22-1997',
      70.394159,
      NULL,
      NULL,
      2.772911,
      1,
      ' 4-19-1982',
      50,
      4,
      NULL,
      NULL,
      1.977426,
      ' 2- 3-2002',
      ' 0- 4-1994',
      '10-12-1977',
      3.544156,
      NULL,
      3,
      0.857408,
      1,
      1,
      NULL,
      0,
      1.161786,
      8.412666,
      11.887801,
      11.875691,
      4.198658,
      12,
      18.388748,
      NULL,
      15.033869,
      4,
      1,
      4,
      0,
      2,
      1.620930,
      0.870791,
      0,
      NULL,
      0.121146,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.513931,
      0.964292,
      NULL,
      0,
      0.616550,
      1.428591,
      2,
      NULL,
      1.964150,
      NULL,
      2.734190,
      1,
      10,
      0.393058,
      NULL,
      1.378687,
      0,
      1.414639,
      NULL,
      NULL,
      1.050129,
      NULL,
      NULL,
      1.010368,
      0.234699,
      0.954701,
      1.719472,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.514840,
      3.049074,
      1,
      2,
      3.086578,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.856241,
      2.157579,
      1.599928,
      1,
      NULL,
      5.930827,
      0,
      0,
      1,
      0.507967,
      0.674070,
      NULL,
      1.217975,
      1,
      NULL,
      NULL,
      0.906096,
      0.213300,
      0.636002,
      NULL,
      NULL,
      7,
      0,
      1.785614,
      NULL,
      1.659560,
      3,
      0,
      7,
      NULL,
      3,
      4,
      0.120724,
      2,
      1.048285,
      NULL,
      0,
      0,
      NULL,
      5.402641,
      0,
      NULL,
      4,
      5.009809,
      5,
      0.130140,
      4,
      3,
      '11- 3-1981',
      328,
      ' 6-11-1978',
      100.352323,
      3.004658,
      1,
      0,
      5.796830,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.800458,
      NULL,
      2.500200,
      1,
      NULL,
      1.198214,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0.564433,
      NULL,
      NULL,
      NULL,
      4.359010,
      0.286773,
      NULL,
      1,
      2.629463,
      4,
      1.573983,
      1.272795,
      3.645833,
      1.648343,
      1.727051,
      0.128666,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.146987,
      0.071169,
      1.583416,
      0,
      NULL,
      1.310104,
      NULL,
      27.868795,
      1,
      1.238708,
      NULL,
      NULL,
      NULL,
      1.905639,
      1.955611,
      3.376320,
      2.692431,
      NULL,
      2.309530,
      0,
      3.213455,
      0,
      NULL,
      0,
      0.163256,
      NULL,
      2.917782,
      2.461385,
      3,
      NULL,
      1.724623,
      0.155880,
      4,
      NULL,
      NULL,
      1.795023,
      1,
      1.613090,
      0,
      0.719692,
      1,
      1,
      1,
      NULL,
      1,
      5.328396,
      1.051577,
      NULL,
      NULL,
      9,
      3.133012,
      4,
      0,
      7.627556,
      0,
      1,
      2.293160,
      18,
      NULL,
      1.644467,
      NULL,
      43.914119,
      60.631345,
      11,
      0.400445,
      NULL,
      5,
      '31001',
      NULL,
      '',
      0.637898,
      '',
      '',
      '',
      0.785583,
      '',
      '',
      NULL,
      2,
      31,
      18,
      12.517453,
      2.415727,
      57,
      NULL,
      2.108114,
      0,
      0.765024,
      NULL,
      2,
      0.506267,
      NULL,
      NULL,
      2,
      1.810133,
      3.947566,
      NULL,
      NULL,
      NULL,
      0.369949,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.788597,
      3,
      3.948855,
      0.374813,
      NULL,
      NULL,
      1.862765,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      10.568820,
      NULL,
      1.419266,
      0.559537,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.768398,
      0,
      NULL,
      2,
      NULL,
      0,
      1.988992,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0.139471,
      NULL,
      NULL,
      NULL,
      NULL,
      0.654883,
      1.470398,
      1.092716,
      0,
      0,
      1,
      0.888933,
      2,
      0.534466,
      2.717147,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.431043,
      0,
      1,
      0,
      1,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      1,
      0.746387,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.949524,
      0,
      NULL,
      0,
      NULL,
      NULL,
      2,
      2.537284,
      0,
      2,
      NULL,
      0.201098,
      0,
      NULL,
      NULL,
      2,
      1,
      NULL,
      0.931211,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.814391,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.210935,
      2,
      0.519101,
      3.108914,
      1,
      3.756996,
      NULL,
      NULL,
      NULL,
      NULL,
      0.794609,
      NULL,
      2.947195,
      2,
      2,
      2.005189,
      0,
      7,
      0,
      3.938368,
      0,
      1.712052,
      2,
      NULL,
      0.275139,
      2.692291,
      0.320175,
      0,
      1,
      2,
      0,
      1,
      NULL,
      5.783952,
      NULL,
      4.745832,
      NULL,
      1.196205,
      1.411405,
      4.940195,
      0,
      0,
      NULL,
      0,
      0.802837,
      1.985887,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      3,
      1.176770,
      1,
      3,
      1.939341,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.577816,
      NULL,
      NULL,
      NULL,
      3,
      0.045536,
      NULL,
      NULL,
      1,
      0.936621,
      NULL,
      NULL,
      1.685328,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.942812,
      3,
      NULL,
      NULL,
      1,
      1.558931,
      NULL,
      NULL,
      1.272012,
      0,
      NULL,
      NULL,
      1,
      1.408863,
      NULL,
      NULL,
      1,
      1.349503,
      NULL,
      NULL,
      0.979593,
      1.821494,
      NULL,
      NULL,
      NULL,
      0.657669,
      NULL,
      NULL,
      0.824346,
      3.807186,
      NULL,
      NULL,
      0.336473,
      0,
      NULL,
      NULL,
      2,
      2.620919,
      NULL,
      NULL,
      0.879569,
      2.170331,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      10,
      10.268592,
      NULL,
      NULL,
      NULL,
      3.862701,
      1.815717,
      2.138001,
      1.276877,
      0,
      14.971517,
      NULL,
      NULL,
      1.582168,
      0.090167,
      1,
      NULL,
      NULL,
      1,
      1.189258,
      NULL,
      1.497844,
      NULL,
      NULL,
      0.097139,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      0,
      1.913269,
      0,
      1.219078,
      0.885570,
      1.320176,
      3,
      1,
      1,
      0.766396,
      1.767052,
      NULL,
      1.980989,
      0.831705,
      0,
      NULL,
      0,
      1.747882,
      NULL,
      NULL,
      0,
      NULL,
      1.149643,
      NULL,
      1.167041,
      NULL,
      3.990477,
      NULL,
      89,
      NULL,
      1,
      NULL,
      21.486234,
      NULL,
      3.627761,
      NULL,
      NULL,
      NULL,
      NULL,
      0.305206,
      NULL,
      NULL,
      NULL,
      1.459007,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.488664,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.238292,
      NULL,
      0,
      NULL,
      0.060767,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.209849,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      5,
      NULL,
      1,
      NULL,
      1.265452,
      NULL,
      0,
      NULL,
      1.892380,
      1,
      3.712057,
      NULL,
      NULL,
      NULL,
      0.681944,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.329847,
      0.332177,
      NULL,
      NULL,
      2,
      NULL,
      1.376815,
      NULL,
      15,
      NULL,
      7.549822,
      NULL,
      0,
      NULL,
      0.020926,
      NULL,
      NULL,
      0.788231,
      0.819894,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.423524,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.441138,
      0,
      NULL,
      NULL,
      NULL,
      3.644712,
      NULL,
      21,
      NULL,
      1.194411,
      0,
      3,
      NULL,
      0,
      NULL,
      2.060936,
      NULL,
      12,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.116923,
      1,
      0,
      28.961409,
      62,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.796469,
      10.736351,
      1.207258,
      3.590545,
      0.054775,
      1,
      1,
      2.646813,
      3.161920,
      0,
      0.890838,
      0.330251,
      NULL,
      0,
      0,
      NULL,
      NULL,
      2.898939,
      NULL,
      NULL,
      1,
      NULL,
      3,
      0.185423,
      NULL,
      0,
      0.516890,
      NULL,
      1.817539,
      0,
      NULL,
      0,
      1,
      NULL,
      0,
      0,
      NULL,
      1.421380,
      1.847038,
      NULL,
      0,
      0.077045,
      NULL,
      3,
      0.949931,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.897967,
      NULL,
      NULL,
      NULL,
      0.266745,
      1.903773,
      7,
      1.804793,
      NULL,
      NULL,
      14,
      73.588779,
      0,
      1,
      6,
      '33243',
      NULL,
      NULL,
      1,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '');
commit;
end;
/


