set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9128147';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-10-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      NULL,
      '2222210',
      3.141527,
      NULL,
      2,
      1,
      '4323',
      1.245063,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3.976434,
      0.400597,
      '10-29-1996',
      NULL,
      NULL,
      359.606287,
      NULL,
      NULL,
      ' 2-28-1998',
      '10- 6-1991',
      ' 1-27-1998',
      3,
      3,
      1.966405,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      5.821719,
      5.946216,
      6,
      NULL,
      16.584082,
      0,
      15,
      NULL,
      5.931955,
      NULL,
      0.487836,
      1,
      1.642576,
      0,
      1,
      1,
      1.869046,
      NULL,
      0.393787,
      0,
      0,
      0.315747,
      0.442373,
      0,
      0,
      NULL,
      1,
      NULL,
      0,
      0.953337,
      1,
      3.521650,
      NULL,
      3,
      4,
      9.388339,
      5.215826,
      NULL,
      1,
      NULL,
      4,
      NULL,
      1.275426,
      NULL,
      NULL,
      0.955341,
      NULL,
      NULL,
      11.866920,
      1.125517,
      6,
      0.335902,
      0.697413,
      1,
      1.311259,
      1,
      1,
      NULL,
      3,
      1,
      1,
      0.291826,
      0.568284,
      2,
      NULL,
      2.622989,
      NULL,
      2,
      NULL,
      NULL,
      1.528687,
      1.799126,
      5.197701,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      0,
      5.742295,
      0,
      NULL,
      NULL,
      0,
      1,
      1.553027,
      4,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      1.972154,
      4,
      0,
      4,
      1.398792,
      NULL,
      5,
      2.029144,
      3.910372,
      0.859398,
      1.777041,
      2.762118,
      0,
      1,
      1.730369,
      1,
      NULL,
      NULL,
      6.852730,
      3,
      1.700407,
      7,
      0,
      1.277448,
      5.782985,
      7.707972,
      NULL,
      ' 7-23-1995',
      NULL,
      '10-24-1999',
      36,
      2,
      0.900894,
      1.949619,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.549001,
      0,
      0.944609,
      1,
      0,
      NULL,
      1.204310,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.492046,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      1.923758,
      1.317095,
      0,
      1,
      NULL,
      5.515340,
      2.593076,
      0,
      1,
      1.799297,
      NULL,
      NULL,
      NULL,
      0.567437,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.346713,
      1.233296,
      0,
      NULL,
      0.523472,
      NULL,
      1.408200,
      63,
      3,
      1,
      NULL,
      NULL,
      NULL,
      3.339316,
      0.560866,
      3,
      NULL,
      1,
      3.635603,
      1,
      0,
      1,
      0.389183,
      3.240895,
      0.785383,
      1,
      2.123853,
      NULL,
      3,
      1,
      1.531616,
      1.432823,
      2.758088,
      0.530082,
      NULL,
      1.564674,
      NULL,
      1.952109,
      1.938580,
      1,
      0.986033,
      0.904157,
      1,
      0,
      0,
      5,
      2.083825,
      3.045259,
      1.556173,
      4,
      3,
      5.233713,
      NULL,
      NULL,
      1.310049,
      NULL,
      NULL,
      39,
      3,
      2.167937,
      NULL,
      5.976830,
      20,
      NULL,
      5.862100,
      NULL,
      2,
      '41140',
      '00244',
      NULL,
      0.997216,
      '',
      NULL,
      '',
      0,
      '',
      '',
      NULL,
      2.996784,
      6.183651,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      15,
      NULL,
      0.166052,
      1.954067,
      1.493042,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.886142,
      1.338245,
      NULL,
      NULL,
      NULL,
      NULL,
      3.338709,
      2.542155,
      2,
      NULL,
      0.100218,
      3,
      NULL,
      NULL,
      1,
      1,
      3,
      3,
      NULL,
      NULL,
      3,
      0,
      1,
      NULL,
      3.206333,
      0.923544,
      3.526887,
      9.298853,
      NULL,
      2.933868,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.284997,
      3,
      0.784452,
      NULL,
      2.189401,
      0.828389,
      2,
      NULL,
      1.493617,
      NULL,
      1,
      NULL,
      0.819042,
      NULL,
      0,
      3,
      3,
      0,
      NULL,
      2.200511,
      1,
      1.516669,
      3.091288,
      3,
      NULL,
      0,
      NULL,
      NULL,
      1.779945,
      NULL,
      NULL,
      NULL,
      3,
      1.868154,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.159935,
      NULL,
      NULL,
      0.693904,
      NULL,
      NULL,
      0.146123,
      NULL,
      0.650173,
      1,
      NULL,
      NULL,
      3.562969,
      NULL,
      1,
      0.662115,
      NULL,
      NULL,
      0.069962,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.377122,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.837731,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      3,
      1,
      2.696898,
      0.977057,
      5,
      2,
      4.575193,
      3.401222,
      NULL,
      4,
      1.528209,
      NULL,
      NULL,
      0.321787,
      1,
      1.295328,
      3,
      0,
      1.140245,
      1.384268,
      0.803895,
      2.448334,
      NULL,
      8,
      7,
      2,
      NULL,
      3,
      1,
      NULL,
      NULL,
      1.560472,
      NULL,
      NULL,
      NULL,
      3,
      3,
      NULL,
      4.422076,
      5.219532,
      3,
      NULL,
      NULL,
      3,
      2.636548,
      7.131647,
      1.322629,
      NULL,
      0.061335,
      1,
      1.948499,
      NULL,
      NULL,
      NULL,
      0.540755,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.731978,
      NULL,
      NULL,
      0.717228,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.215885,
      NULL,
      NULL,
      0.723641,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.695007,
      1,
      1.859580,
      1.547645,
      NULL,
      0,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.174747,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.935722,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.142337,
      NULL,
      NULL,
      NULL,
      0.022351,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.371654,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.856415,
      NULL,
      NULL,
      NULL,
      6.509844,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.688887,
      36,
      6.198304,
      NULL,
      NULL,
      NULL,
      1.626408,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.177609,
      2.243252,
      1.325333,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      0.377415,
      2,
      0.935100,
      0,
      0,
      NULL,
      0.624698,
      NULL,
      0,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      3.942937,
      NULL,
      1.010598,
      NULL,
      149.005658,
      NULL,
      NULL,
      23,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      3.362323,
      NULL,
      1,
      NULL,
      0.113914,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.076636,
      NULL,
      1.025338,
      NULL,
      0.473455,
      NULL,
      1.710696,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.362788,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.229927,
      NULL,
      0.659946,
      NULL,
      1.646763,
      NULL,
      NULL,
      NULL,
      0.937231,
      NULL,
      0.760448,
      NULL,
      0.984061,
      NULL,
      0.807347,
      3,
      3.860969,
      0.312945,
      2,
      0,
      0.316053,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.071161,
      0.862478,
      1.210440,
      0.238754,
      NULL,
      0.402671,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.745416,
      NULL,
      0,
      NULL,
      0.249389,
      NULL,
      7.347711,
      NULL,
      5,
      3,
      3.532838,
      NULL,
      3.694293,
      1.637502,
      2.343150,
      NULL,
      192,
      1,
      2,
      NULL,
      1,
      0.318058,
      0,
      0,
      0,
      3,
      21,
      0,
      NULL,
      NULL,
      NULL,
      1.728819,
      0,
      1,
      3,
      0,
      3.367203,
      1,
      3,
      NULL,
      2.752678,
      NULL,
      0.501200,
      0,
      0,
      NULL,
      0,
      0.636423,
      NULL,
      1.775925,
      1,
      NULL,
      1.554184,
      0,
      NULL,
      0.797747,
      1.173685,
      NULL,
      1.410651,
      0.239552,
      NULL,
      0,
      1.960625,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.147290,
      3,
      NULL,
      1.468078,
      1.351206,
      NULL,
      1,
      0,
      1.909407,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.144607,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.225098,
      NULL,
      1.856498,
      NULL,
      0.341720,
      NULL,
      9.615931,
      NULL,
      NULL,
      NULL,
      NULL,
      102.176046,
      NULL,
      0,
      NULL,
      '44012',
      '41022',
      NULL,
      0,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      NULL);
commit;
end;
/


