set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9206190';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-4-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '0',
      NULL,
      NULL,
      '3443122',
      1.465064,
      0,
      6,
      0,
      '2201',
      3,
      1.515806,
      NULL,
      NULL,
      ' 4-27-2003',
      10.699515,
      NULL,
      1.249219,
      0.680674,
      NULL,
      NULL,
      NULL,
      2,
      275,
      NULL,
      1.163387,
      ' 7- 9-1980',
      NULL,
      '11-29-1996',
      1,
      3,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.757255,
      1.813277,
      22,
      10.452834,
      4.772198,
      6.586962,
      5.665471,
      NULL,
      3,
      0,
      2.784809,
      3,
      0,
      0.823867,
      1,
      0.386127,
      0,
      0.901281,
      NULL,
      1.962029,
      NULL,
      0,
      1.520833,
      1.166574,
      2,
      4,
      0.285116,
      0.786068,
      0.339452,
      1,
      NULL,
      5.707272,
      0,
      NULL,
      8,
      6,
      NULL,
      1.296176,
      NULL,
      NULL,
      6.905708,
      0,
      2,
      3,
      3,
      1.795349,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1.033805,
      3.670892,
      NULL,
      1.730770,
      2.866400,
      0,
      1.599485,
      NULL,
      0,
      3,
      NULL,
      1,
      1.432413,
      0,
      1,
      NULL,
      NULL,
      6.177503,
      NULL,
      2.549892,
      NULL,
      1,
      NULL,
      NULL,
      1.319660,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      5,
      0,
      1,
      NULL,
      1,
      1.895031,
      0.275326,
      5.834687,
      0.332775,
      NULL,
      1.015772,
      1,
      1.791214,
      1,
      0,
      NULL,
      0.376679,
      0.736490,
      3.954505,
      0,
      9.418920,
      2.957481,
      4.388409,
      4,
      8.238447,
      NULL,
      4.363582,
      0,
      NULL,
      4.327307,
      1.421765,
      6.520518,
      9.938618,
      8,
      0.241050,
      4,
      7,
      2.194352,
      4,
      0,
      4.798704,
      0.033108,
      NULL,
      40,
      ' 7-21-1981',
      17,
      3,
      2,
      0.125712,
      0.519405,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.864111,
      1.365914,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      2.030031,
      NULL,
      NULL,
      0,
      3,
      1,
      1.028083,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.864068,
      5,
      8,
      NULL,
      4.644566,
      3.074583,
      1.137289,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.360661,
      3,
      0.328681,
      1.859472,
      0.997594,
      1.371359,
      0.581151,
      NULL,
      1.072689,
      2.124810,
      1.496920,
      NULL,
      NULL,
      NULL,
      1.388478,
      1.039979,
      3,
      1,
      NULL,
      1.161208,
      2.283727,
      NULL,
      1.153243,
      0,
      0.479396,
      1,
      0.727570,
      3,
      5,
      5,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.652665,
      1,
      1.734489,
      0.099696,
      0.397588,
      NULL,
      NULL,
      18,
      NULL,
      1,
      8.757228,
      1,
      7.223984,
      NULL,
      7.361665,
      5.089990,
      1.734315,
      2.952617,
      6,
      3,
      3.000886,
      1,
      57.944750,
      NULL,
      0,
      NULL,
      18.366648,
      25.065108,
      33.218369,
      3.603009,
      0.026285,
      0.535194,
      '11110',
      '',
      '',
      1.323027,
      '',
      '',
      '',
      1,
      '3211',
      '',
      '',
      0,
      NULL,
      8,
      14,
      1.456172,
      41.059616,
      0.406380,
      5,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      3,
      3,
      NULL,
      NULL,
      3,
      2,
      3,
      2.303410,
      3.877492,
      1.907847,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.355468,
      NULL,
      NULL,
      4,
      3.059872,
      0.523514,
      1.540633,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.858082,
      3.433108,
      3,
      1,
      NULL,
      NULL,
      1.567356,
      NULL,
      NULL,
      1.421993,
      1.932397,
      0,
      0,
      0,
      NULL,
      NULL,
      3.141343,
      0.635223,
      0.135575,
      0.242861,
      1.318480,
      1,
      0,
      1,
      NULL,
      0.914142,
      NULL,
      NULL,
      1.445974,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.912130,
      NULL,
      0.698148,
      1,
      NULL,
      NULL,
      NULL,
      1.448647,
      NULL,
      NULL,
      NULL,
      3,
      2,
      0.256321,
      3.455912,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.875698,
      NULL,
      NULL,
      7.560794,
      NULL,
      1.059853,
      NULL,
      1.214494,
      0.631672,
      0,
      NULL,
      NULL,
      0,
      6,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.636692,
      NULL,
      NULL,
      1.657202,
      NULL,
      NULL,
      1.852403,
      NULL,
      NULL,
      NULL,
      0.720058,
      NULL,
      2.743392,
      NULL,
      NULL,
      5,
      2.697205,
      1,
      3,
      2.407396,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.581527,
      0,
      3,
      3,
      2,
      2.986979,
      1,
      0,
      1.845645,
      0,
      3.661535,
      3,
      NULL,
      3,
      NULL,
      0.920780,
      1.426820,
      2,
      1.906951,
      2,
      1.304614,
      2,
      NULL,
      0,
      8.337612,
      NULL,
      7.401548,
      7.282093,
      1,
      5,
      1.846978,
      1.879593,
      1.447251,
      NULL,
      1.281241,
      1,
      1.610138,
      NULL,
      NULL,
      1.484617,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.313160,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.521321,
      0.498895,
      1,
      0.691524,
      0.443300,
      0.169722,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.418385,
      NULL,
      NULL,
      NULL,
      1.401527,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      18.200483,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      17,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      0.470311,
      NULL,
      NULL,
      NULL,
      6.522489,
      NULL,
      NULL,
      NULL,
      0.655779,
      NULL,
      NULL,
      NULL,
      18.007651,
      NULL,
      NULL,
      NULL,
      2.055249,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      1.410631,
      NULL,
      2.419354,
      NULL,
      NULL,
      NULL,
      0.054759,
      1.516055,
      NULL,
      1.909398,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.912168,
      NULL,
      NULL,
      0,
      NULL,
      1,
      67,
      0.645686,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      1,
      0,
      0,
      1.544557,
      0.016583,
      1.799901,
      1.377417,
      NULL,
      0.366196,
      NULL,
      NULL,
      2,
      NULL,
      0.541869,
      NULL,
      0.626408,
      NULL,
      0.914156,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.884746,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.853314,
      3,
      2.669146,
      4,
      NULL,
      NULL,
      6,
      5,
      8,
      0.141263,
      1,
      0,
      0,
      0,
      NULL,
      1.492652,
      0.246698,
      NULL,
      0.423246,
      0.055340,
      NULL,
      1,
      1,
      NULL,
      3.562591,
      0,
      NULL,
      0,
      3,
      NULL,
      1.694288,
      2.706354,
      NULL,
      NULL,
      3.198345,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      2.572512,
      1.694118,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.968897,
      NULL,
      0,
      NULL,
      5,
      7,
      3,
      NULL,
      1,
      2,
      NULL,
      30.791269,
      1,
      NULL,
      2.572332,
      '41020',
      '',
      NULL,
      0,
      '',
      '',
      NULL,
      NULL,
      '4401',
      '',
      '');
commit;
end;
/


