set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9220323';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-7-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      NULL,
      '1444340',
      0,
      0,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      ' 4-25-2003',
      NULL,
      NULL,
      NULL,
      0.855964,
      0,
      ' 1-22-1976',
      11,
      NULL,
      NULL,
      91.533259,
      3.467991,
      NULL,
      '11-18-1985',
      ' 3-17-1988',
      NULL,
      1,
      1.048961,
      NULL,
      1,
      NULL,
      2.488186,
      0.260501,
      NULL,
      NULL,
      NULL,
      8,
      5.433592,
      22.693352,
      15.804624,
      3.671793,
      13.101019,
      6.047386,
      2,
      1,
      NULL,
      1.397405,
      0,
      0.298187,
      NULL,
      1.510079,
      1.111387,
      1.024748,
      1,
      0.933970,
      0,
      2.970649,
      0.347943,
      NULL,
      1.856052,
      1.209525,
      0,
      NULL,
      9,
      NULL,
      1,
      1.944849,
      NULL,
      1.354661,
      2.840133,
      2.248381,
      2,
      4,
      2.536529,
      2,
      0,
      0.026346,
      0.070506,
      NULL,
      NULL,
      0.184018,
      NULL,
      NULL,
      1,
      0.231559,
      1.044628,
      1.269765,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.313771,
      0,
      4,
      4.168960,
      2.949362,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      4.985672,
      1.453288,
      0,
      3.675545,
      1.602156,
      3.621944,
      1,
      3,
      2.473624,
      1,
      1.306405,
      1.585014,
      0,
      NULL,
      1,
      NULL,
      1,
      1.837722,
      NULL,
      NULL,
      NULL,
      2,
      3,
      5.271620,
      NULL,
      4.156396,
      3.104319,
      1.487432,
      1,
      0,
      NULL,
      1,
      3,
      6.818616,
      NULL,
      3.227229,
      2,
      5.322680,
      0.537375,
      0,
      1.251607,
      4.991749,
      6.615580,
      1,
      0.880811,
      0,
      NULL,
      NULL,
      NULL,
      ' 6-10-1989',
      5.682240,
      0.913696,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.978663,
      NULL,
      0,
      2,
      NULL,
      7.278803,
      1.308735,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      0.732964,
      0,
      6.769184,
      0.769494,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      5.717808,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.926770,
      NULL,
      1.862123,
      0,
      NULL,
      NULL,
      26,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.413601,
      NULL,
      0,
      2.932128,
      3.091337,
      2,
      3.152189,
      3,
      3,
      0.650485,
      NULL,
      2.461638,
      NULL,
      NULL,
      NULL,
      0,
      0.323386,
      0,
      0,
      1.548874,
      NULL,
      0.901355,
      0.918720,
      0,
      0.220227,
      0,
      0.282578,
      1.940984,
      NULL,
      9,
      8.737261,
      2,
      11.366000,
      11.975367,
      7,
      5,
      NULL,
      5.314918,
      0,
      2.115644,
      1,
      68,
      NULL,
      0,
      NULL,
      51,
      49,
      107,
      2,
      1,
      NULL,
      NULL,
      '43444',
      '10233',
      0.072473,
      '13012',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      2.335784,
      21,
      NULL,
      24,
      1.386730,
      NULL,
      NULL,
      NULL,
      NULL,
      1.764372,
      NULL,
      NULL,
      1.221317,
      NULL,
      NULL,
      0.787353,
      NULL,
      NULL,
      0.667256,
      NULL,
      NULL,
      1.309834,
      NULL,
      NULL,
      1.760916,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.719769,
      NULL,
      NULL,
      1.539575,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.242965,
      NULL,
      NULL,
      1.864287,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.975269,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.223443,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.106155,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.640050,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.003426,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.886054,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.829626,
      NULL,
      NULL,
      1.837507,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1,
      3.731077,
      5.356672,
      4,
      2,
      0.798820,
      NULL,
      NULL,
      NULL,
      4.072133,
      1.463790,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.695780,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      2.371322,
      3,
      NULL,
      1,
      NULL,
      NULL,
      2.493106,
      0.029577,
      0,
      2.768077,
      3,
      3.533408,
      4.128655,
      5.066103,
      3.689946,
      1.799663,
      2.772833,
      1.180186,
      NULL,
      NULL,
      1.994134,
      1,
      NULL,
      1.175501,
      0.725931,
      1.683012,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.893803,
      0.444530,
      NULL,
      NULL,
      0.115145,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.456043,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.673581,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1.914310,
      NULL,
      0.152536,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.228255,
      NULL,
      12.435259,
      1.278918,
      0,
      NULL,
      1,
      1.273960,
      1,
      1.739339,
      0.260878,
      0,
      1,
      NULL,
      1,
      0,
      1.433896,
      1,
      1.961983,
      0.847377,
      0,
      NULL,
      1.403320,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.380617,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.353724,
      1,
      0.296483,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.804009,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.718856,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.222551,
      1.334741,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.590410,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.857618,
      NULL,
      NULL,
      3,
      NULL,
      1,
      0.507242,
      3,
      0.505457,
      0,
      2,
      1.322414,
      3,
      NULL,
      3,
      NULL,
      289.897162,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.458676,
      0.209630,
      7,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.002024,
      1,
      2,
      0.717854,
      5.258315,
      6,
      NULL,
      0.823555,
      3.330616,
      0,
      NULL,
      2.447696,
      NULL,
      0.789619,
      3.155372,
      NULL,
      NULL,
      0.014763,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      2,
      0,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1.637786,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.286654,
      0.759431,
      NULL,
      1,
      0,
      1.295480,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.833423,
      NULL,
      0.907949,
      0,
      0,
      0.826204,
      NULL,
      NULL,
      84,
      127,
      1,
      0.517415,
      5,
      '33104',
      '00420',
      '42341',
      0.934626,
      '12141',
      '',
      '',
      NULL,
      NULL,
      '',
      '');
commit;
end;
/


