set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8612483';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-7-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '3',
      NULL,
      NULL,
      NULL,
      2.427403,
      0,
      2,
      1,
      NULL,
      3,
      3.760932,
      1,
      NULL,
      NULL,
      37,
      NULL,
      1.771441,
      3,
      0,
      ' 9- 6-1974',
      33.021221,
      1.212884,
      113.373724,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5- 4-1981',
      NULL,
      0.584069,
      NULL,
      0.187136,
      0,
      0.186178,
      3,
      2.677051,
      NULL,
      NULL,
      NULL,
      0.893492,
      3,
      NULL,
      14.906890,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      1,
      1.699326,
      NULL,
      0,
      1.652175,
      0.433448,
      0,
      0.493344,
      NULL,
      3.084425,
      0.150746,
      0.765502,
      0,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.016756,
      6.134239,
      0,
      1.967527,
      4.876919,
      0,
      0,
      3.175144,
      2,
      NULL,
      NULL,
      NULL,
      0.183316,
      NULL,
      NULL,
      0.387726,
      NULL,
      NULL,
      NULL,
      7.987472,
      0,
      1,
      0.405961,
      0.227838,
      3,
      NULL,
      1,
      0.091494,
      2.916118,
      2.674316,
      NULL,
      2,
      2.392984,
      NULL,
      3.610862,
      0.585339,
      0,
      1,
      0.573050,
      0,
      2,
      1,
      4,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.868465,
      0.247400,
      NULL,
      0,
      3,
      0.192887,
      0,
      0,
      0.850482,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      3,
      0,
      0.171406,
      NULL,
      1,
      0.382828,
      NULL,
      1,
      1.608662,
      4,
      0.230384,
      NULL,
      3,
      NULL,
      4.561419,
      5,
      3,
      NULL,
      3,
      3.209579,
      1.509567,
      5.954644,
      0.950365,
      NULL,
      1,
      3.865120,
      NULL,
      ' 9-19-1983',
      216.127449,
      ' 0-25-1996',
      149.059485,
      1.601333,
      1,
      3.336060,
      7.123979,
      1.709953,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      2,
      2.344921,
      1.815268,
      2.458259,
      0.227667,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.073643,
      NULL,
      NULL,
      NULL,
      NULL,
      3.869066,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.326758,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.105551,
      0.029902,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.899955,
      1,
      1.884292,
      0.192466,
      NULL,
      1.795995,
      NULL,
      NULL,
      1.937057,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      3,
      1,
      2.180164,
      0,
      3,
      1,
      0,
      1.155694,
      3.651954,
      2.276890,
      0.190210,
      1,
      1,
      0.028930,
      0,
      4,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      1,
      1.272045,
      0,
      NULL,
      4,
      NULL,
      NULL,
      6,
      7,
      4,
      NULL,
      3.566186,
      7,
      1,
      2.180046,
      0,
      NULL,
      3,
      NULL,
      17,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      '33420',
      '10423',
      '10003',
      0.213999,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      NULL,
      1.003624,
      30.232389,
      189.027492,
      24,
      2.468180,
      22,
      5,
      26,
      NULL,
      NULL,
      1.029755,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.906806,
      NULL,
      0.890580,
      0,
      3,
      1.808945,
      3,
      1.651060,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      1.100362,
      1.840558,
      2,
      3.054915,
      3.314222,
      0.017587,
      1,
      0.315914,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      0,
      1,
      2.094014,
      1.839425,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.734467,
      3,
      1,
      NULL,
      NULL,
      NULL,
      1.251924,
      0.058364,
      0,
      2.191045,
      NULL,
      1.660436,
      1,
      0.592258,
      NULL,
      1,
      NULL,
      NULL,
      2.922797,
      1.487154,
      1.060261,
      3.726319,
      NULL,
      0.707943,
      1.980135,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      5,
      7,
      0,
      0.235955,
      NULL,
      NULL,
      NULL,
      1.436276,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1.124602,
      3,
      3,
      1.717882,
      0,
      0,
      1.630680,
      NULL,
      1,
      0,
      4,
      9,
      7.875008,
      0,
      NULL,
      NULL,
      2.409227,
      1,
      1.281803,
      1.409355,
      1,
      0.002263,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      0.759858,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.118140,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      0,
      2.617232,
      3.665159,
      1,
      NULL,
      1,
      5,
      NULL,
      2.028335,
      3.700878,
      NULL,
      NULL,
      1.815939,
      3.465724,
      NULL,
      2,
      NULL,
      1.243437,
      2.709539,
      1.405438,
      0.636466,
      0.928454,
      NULL,
      0.702315,
      NULL,
      0.620368,
      0,
      0.175657,
      NULL,
      1,
      2,
      1.812136,
      3,
      2,
      1.745598,
      NULL,
      9,
      5.653016,
      NULL,
      1,
      8.028880,
      NULL,
      NULL,
      2,
      7.409793,
      0.156577,
      1.693815,
      0,
      0.608174,
      NULL,
      3,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3.170869,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.190806,
      NULL,
      NULL,
      0.929656,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.937088,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.296492,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.638313,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      14,
      NULL,
      NULL,
      1,
      NULL,
      0.570245,
      NULL,
      0,
      1,
      0.436105,
      NULL,
      NULL,
      4.868483,
      NULL,
      NULL,
      NULL,
      6.011871,
      NULL,
      NULL,
      NULL,
      0.436267,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.855913,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.924769,
      NULL,
      NULL,
      NULL,
      3.807145,
      NULL,
      NULL,
      NULL,
      0.928934,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.141661,
      4.201972,
      6,
      5,
      1,
      NULL,
      14.371580,
      NULL,
      33.458898,
      NULL,
      0.465605,
      NULL,
      NULL,
      1.136029,
      NULL,
      NULL,
      1.446199,
      2,
      2,
      1.811446,
      NULL,
      NULL,
      1,
      NULL,
      1.723647,
      11099.999897,
      NULL,
      1.817921,
      0,
      1,
      2,
      1,
      0.336320,
      0.930122,
      1,
      1.448801,
      2,
      1,
      1,
      NULL,
      0,
      NULL,
      1.152159,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.363670,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.525525,
      NULL,
      152.373217,
      NULL,
      NULL,
      NULL,
      NULL,
      0.177900,
      NULL,
      NULL,
      NULL,
      1.804963,
      NULL,
      0.184045,
      NULL,
      1.343684,
      NULL,
      3.475808,
      NULL,
      1.530750,
      NULL,
      1.151815,
      NULL,
      1,
      NULL,
      2.177577,
      NULL,
      NULL,
      NULL,
      0.012501,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.225895,
      2,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.076368,
      NULL,
      0.328396,
      NULL,
      0.326367,
      NULL,
      0,
      0.980411,
      1.344374,
      NULL,
      2,
      NULL,
      1,
      NULL,
      21.907685,
      NULL,
      2,
      NULL,
      3.274334,
      NULL,
      NULL,
      NULL,
      0,
      1.672855,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.044246,
      0.955212,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      2.077636,
      NULL,
      1.936818,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.174983,
      0.249720,
      31.378201,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      0.935987,
      NULL,
      0.599183,
      NULL,
      9.019723,
      2,
      3.653525,
      1.287469,
      1.490392,
      2,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2.148197,
      2.426045,
      NULL,
      1.426960,
      1,
      NULL,
      1,
      1.606180,
      NULL,
      0.641074,
      1.675215,
      NULL,
      0,
      0.546036,
      NULL,
      0.941137,
      NULL,
      NULL,
      3.963069,
      1.574570,
      0.866395,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.369864,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.644374,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      10.455961,
      7,
      1,
      1.967872,
      3,
      13,
      39.951379,
      NULL,
      1.141127,
      0,
      '23024',
      '11231',
      '24324',
      0,
      '',
      '',
      '',
      1.769899,
      '',
      '',
      '');
commit;
end;
/


