set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8900515';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-3-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      NULL,
      '1301303',
      3,
      1,
      NULL,
      1,
      NULL,
      2,
      0.156640,
      NULL,
      NULL,
      ' 8-10-1979',
      54,
      NULL,
      4,
      1.208688,
      1,
      ' 7-17-1999',
      40,
      NULL,
      NULL,
      40.154545,
      0,
      ' 1-20-1998',
      ' 8- 8-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      1.889203,
      0,
      NULL,
      3,
      1.283984,
      0,
      19,
      11.147249,
      8,
      4,
      145,
      71,
      4,
      13.427927,
      5.149541,
      3.895009,
      1.546295,
      0.200547,
      4,
      1.856735,
      1,
      NULL,
      0.311758,
      NULL,
      1.954571,
      1.675464,
      1.965028,
      1.735033,
      3.489169,
      7,
      2.345362,
      NULL,
      2.393199,
      0.390417,
      3,
      1.214477,
      0,
      0,
      1,
      1.932056,
      NULL,
      3.647831,
      0,
      NULL,
      NULL,
      1,
      1.174851,
      5.754846,
      NULL,
      1.914307,
      NULL,
      NULL,
      1.438306,
      NULL,
      NULL,
      4,
      NULL,
      0.529135,
      1,
      0,
      1,
      0.453536,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.297843,
      0.164228,
      0.524060,
      0.259139,
      1.479319,
      1.912529,
      1,
      1,
      0,
      1,
      2.458705,
      0.068849,
      0.923516,
      1.156523,
      1.774894,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      9.942873,
      NULL,
      1,
      NULL,
      1.934065,
      1.120634,
      1,
      1.629693,
      NULL,
      0,
      1.308597,
      NULL,
      2,
      1.016242,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      6,
      1.894160,
      0.762862,
      3,
      1,
      2,
      0.763692,
      1,
      0.161129,
      1.161173,
      1,
      5.478134,
      2,
      7.887670,
      3.171240,
      3,
      4.923539,
      9,
      NULL,
      6.102115,
      2,
      8,
      NULL,
      1.349551,
      0,
      0.582425,
      ' 1-18-1993',
      NULL,
      NULL,
      62,
      NULL,
      1.658844,
      0.355585,
      NULL,
      2,
      5.229788,
      NULL,
      NULL,
      0,
      0.189365,
      NULL,
      1,
      1.733888,
      9.662619,
      1,
      0.776379,
      1.371497,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.318210,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.691473,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      5.762765,
      1.907640,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.083959,
      1,
      2.762809,
      0,
      0,
      1.046888,
      NULL,
      2.978924,
      NULL,
      NULL,
      NULL,
      NULL,
      3.532652,
      0.722361,
      1.410787,
      2,
      NULL,
      1,
      3,
      0.865242,
      1,
      1,
      NULL,
      0,
      2,
      2.778169,
      16.981948,
      4.357199,
      0,
      0.596649,
      0,
      0.781392,
      0,
      1.221683,
      0,
      NULL,
      0.964440,
      0,
      1.004630,
      1.642969,
      1,
      1,
      NULL,
      1,
      3.390440,
      1,
      3.424862,
      6,
      7,
      0.630164,
      4,
      1,
      0,
      3,
      0,
      3.493835,
      27,
      3.927373,
      1.842528,
      NULL,
      11.065314,
      0,
      NULL,
      2,
      NULL,
      2,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      0,
      '3020',
      '',
      NULL,
      3.060130,
      NULL,
      79,
      26.180823,
      NULL,
      0.282292,
      6.254295,
      NULL,
      NULL,
      1,
      2.901608,
      0.168606,
      0,
      NULL,
      NULL,
      0.795823,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.101119,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.696562,
      1,
      1.096353,
      2,
      0.397275,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      5.636940,
      0.075326,
      0,
      1,
      1.502722,
      0,
      1,
      NULL,
      0,
      2.191412,
      NULL,
      NULL,
      3.675727,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.430062,
      1,
      0.736759,
      0,
      NULL,
      1.948081,
      0.191806,
      0,
      1,
      1,
      1.733179,
      1,
      0.164952,
      1.375669,
      1.768965,
      NULL,
      0,
      NULL,
      NULL,
      1.078637,
      NULL,
      NULL,
      NULL,
      0.598478,
      0.076252,
      NULL,
      NULL,
      NULL,
      0.545528,
      1.062467,
      1.949463,
      3.074027,
      3,
      3.128934,
      0,
      2.404393,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0.664731,
      1.296924,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      2.926181,
      0,
      1,
      NULL,
      NULL,
      7.778961,
      NULL,
      3,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.071005,
      NULL,
      NULL,
      0.665505,
      NULL,
      NULL,
      0.064411,
      NULL,
      NULL,
      3,
      1.029884,
      NULL,
      0.692523,
      0,
      0,
      NULL,
      0.696264,
      0.729292,
      6.699390,
      7,
      0,
      6,
      6.411539,
      2.064577,
      0.425060,
      NULL,
      1,
      2,
      2,
      NULL,
      3.648528,
      0.005762,
      NULL,
      3.448634,
      9.713365,
      8,
      2.242777,
      NULL,
      0.877733,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      3,
      NULL,
      NULL,
      0,
      2.709147,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      4.669480,
      4.426339,
      0.586027,
      1.156591,
      1.495381,
      0,
      3.767467,
      0.183537,
      NULL,
      1.655335,
      3.720841,
      NULL,
      7,
      NULL,
      NULL,
      3.831792,
      NULL,
      NULL,
      3.283606,
      NULL,
      NULL,
      1.723035,
      NULL,
      NULL,
      2.114312,
      NULL,
      NULL,
      2.246978,
      NULL,
      NULL,
      2,
      1,
      NULL,
      1,
      3.538723,
      NULL,
      2.342050,
      1,
      NULL,
      NULL,
      1,
      NULL,
      2,
      3,
      NULL,
      0.242701,
      1.681054,
      NULL,
      13,
      7,
      NULL,
      3.684382,
      2.087483,
      1.054743,
      3,
      0,
      3.430509,
      0,
      2.941634,
      NULL,
      3.063923,
      NULL,
      0.246137,
      NULL,
      NULL,
      2,
      58,
      NULL,
      3.500543,
      1.399884,
      2.571274,
      NULL,
      0.150322,
      0,
      0,
      NULL,
      1,
      NULL,
      0.338955,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      2.065416,
      NULL,
      2.664713,
      2,
      1.455403,
      NULL,
      0,
      3.047956,
      2,
      NULL,
      NULL,
      3.904237,
      2,
      NULL,
      2.266205,
      3,
      0.223438,
      NULL,
      0.067398,
      1,
      1.722122,
      NULL,
      0,
      1,
      1.512408,
      NULL,
      0,
      3.827555,
      1.244321,
      NULL,
      NULL,
      NULL,
      1.773367,
      NULL,
      0.550351,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      0,
      0,
      0.162033,
      NULL,
      1,
      9.647777,
      1.309985,
      NULL,
      2.410692,
      0.526092,
      NULL,
      NULL,
      NULL,
      2.281125,
      NULL,
      16.338365,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.386363,
      1.587671,
      NULL,
      0.378680,
      10.778610,
      7,
      1,
      10.644041,
      NULL,
      1,
      NULL,
      0.590902,
      NULL,
      13,
      1.713451,
      0,
      1.955073,
      1,
      0.371088,
      1.827445,
      0,
      0.215581,
      1,
      1,
      0.630743,
      0,
      0,
      1,
      NULL,
      0.525944,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.474516,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.110886,
      0,
      2,
      2,
      5.294415,
      4.206016,
      5.698418,
      2,
      13.639991,
      0,
      1.697399,
      2.722426,
      0,
      2,
      NULL,
      0,
      2,
      0.143874,
      0.839741,
      0.076081,
      1,
      0.873279,
      NULL,
      1,
      0,
      NULL,
      1.937214,
      0,
      1.255180,
      NULL,
      1.354815,
      2,
      1,
      1.252438,
      NULL,
      0.538449,
      1.933416,
      0,
      0.531959,
      1.356246,
      1,
      1,
      NULL,
      2,
      0,
      3,
      1,
      1.446160,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.077809,
      0.201863,
      2,
      NULL,
      0.438752,
      NULL,
      0.899340,
      NULL,
      0.035416,
      NULL,
      2.698088,
      NULL,
      3.592019,
      NULL,
      0.008446,
      NULL,
      3,
      NULL,
      3,
      NULL,
      0.364438,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.800438,
      NULL,
      2,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      11,
      NULL,
      3.163516,
      NULL,
      1,
      14.887883,
      71,
      NULL,
      0,
      1,
      '20200',
      '',
      '',
      1.339320,
      '',
      '',
      '',
      2,
      '2223',
      NULL,
      '');
commit;
end;
/


