set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7907117';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-7-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      5.339102,
      1.863582,
      NULL,
      0,
      3,
      1.777978,
      NULL,
      NULL,
      NULL,
      '31233141',
      6.386180,
      23,
      '3023043',
      3,
      1,
      3,
      NULL,
      '1124',
      5.821321,
      0.401222,
      NULL,
      NULL,
      ' 3-25-1980',
      43.007116,
      8.266223,
      NULL,
      3.494567,
      8,
      '10- 8-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-15-2001',
      NULL,
      ' 7- 1-1995',
      3,
      1,
      3,
      3,
      1,
      NULL,
      3.853356,
      0.108037,
      NULL,
      NULL,
      NULL,
      0.534469,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.047207,
      NULL,
      1.880165,
      0,
      NULL,
      NULL,
      0.199286,
      1,
      0,
      0.406451,
      1.725513,
      0.384753,
      1.034505,
      2,
      1.968590,
      2.096463,
      1,
      NULL,
      9,
      0,
      0.031371,
      0,
      1.974200,
      6.775749,
      1,
      1.462349,
      NULL,
      1,
      0.374893,
      10.033371,
      1.955108,
      NULL,
      0,
      1.272189,
      1.565188,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.340193,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.529995,
      NULL,
      2.646468,
      3.733263,
      0,
      2.166348,
      1.002141,
      0.944317,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.945327,
      0,
      6,
      0,
      4.739294,
      1.285313,
      0.841800,
      1.367646,
      1,
      1,
      1,
      NULL,
      1,
      1,
      0.835795,
      1.529430,
      1,
      0,
      NULL,
      NULL,
      1.566785,
      NULL,
      1.246040,
      1.001608,
      NULL,
      NULL,
      4,
      0.693255,
      1.124611,
      0.212402,
      NULL,
      1,
      1,
      1,
      1,
      0,
      5,
      2,
      1,
      6.593138,
      5,
      NULL,
      6.543807,
      1.569801,
      1,
      NULL,
      0.016562,
      NULL,
      ' 3-10-1998',
      NULL,
      ' 7-16-1979',
      NULL,
      0,
      0,
      0.618909,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.876918,
      NULL,
      0,
      1,
      1,
      0,
      1,
      0.857625,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.056399,
      0.555538,
      6.225301,
      1.054148,
      0,
      1,
      0.652616,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.164721,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      1,
      1.702050,
      1,
      NULL,
      3,
      NULL,
      1.609927,
      NULL,
      NULL,
      NULL,
      4.585761,
      NULL,
      0,
      4,
      3.783442,
      2.980666,
      1.457122,
      3.107960,
      NULL,
      NULL,
      3,
      6.164557,
      2,
      6,
      3.631966,
      NULL,
      2,
      1.605441,
      0.461004,
      2,
      1,
      0,
      0.303573,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.697230,
      NULL,
      1.622322,
      0,
      3.175056,
      7,
      5,
      5,
      5,
      7.545076,
      2,
      1,
      2,
      1,
      0.341928,
      2.257867,
      19.885859,
      3.816200,
      3.728363,
      23.598694,
      NULL,
      8,
      17.319983,
      3.607358,
      NULL,
      NULL,
      '03421',
      '41430',
      '',
      NULL,
      '',
      '',
      '',
      1,
      NULL,
      '',
      NULL,
      0,
      15,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.163390,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.909588,
      NULL,
      NULL,
      1.954870,
      NULL,
      NULL,
      0.538308,
      NULL,
      NULL,
      0,
      NULL,
      1,
      481,
      7.842752,
      1.747438,
      1,
      0,
      1.788075,
      1.671259,
      1,
      0.637551,
      1.654347,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      0,
      NULL,
      0,
      NULL,
      32.513900,
      NULL,
      NULL,
      NULL,
      0.791559,
      NULL,
      NULL,
      NULL,
      0,
      0.171333,
      1.152219,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      101.038306,
      NULL,
      0.536927,
      NULL,
      0.272344,
      NULL,
      1,
      NULL,
      1,
      0,
      1.911711,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.121417,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.895272,
      0.639759,
      NULL,
      2.946303,
      NULL,
      NULL,
      NULL,
      0.553008,
      NULL,
      0.037620,
      NULL,
      0.691561,
      NULL,
      0.150375,
      0,
      14.063548,
      NULL,
      1.230529,
      NULL,
      NULL,
      NULL,
      0.162896,
      1,
      0,
      1.598215,
      1,
      1.545462,
      3,
      2,
      1.139596,
      2.894416,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      1.213644,
      NULL,
      NULL,
      0.744552,
      1,
      NULL,
      0,
      0.380357,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      NULL,
      1,
      1.250849,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.610101,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.194188,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.809841,
      2,
      1,
      NULL,
      NULL,
      17,
      88,
      1,
      0.427137,
      0,
      '20433',
      '23010',
      '33311',
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


