set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8013144';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-7-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '3',
      NULL,
      NULL,
      '0141042',
      NULL,
      1.637307,
      2,
      3,
      '3231',
      2,
      0,
      NULL,
      NULL,
      ' 2- 8-1980',
      40,
      NULL,
      2,
      0,
      1.324892,
      ' 6-22-1990',
      55.597504,
      NULL,
      NULL,
      NULL,
      3.033447,
      ' 7- 6-1982',
      NULL,
      ' 7-22-1987',
      3.712521,
      2.129005,
      0.114516,
      NULL,
      0.410168,
      3,
      1,
      0.276792,
      0.116818,
      15.761714,
      4,
      13.043472,
      6.139586,
      8.753633,
      11.790420,
      7,
      17,
      0,
      2.073808,
      NULL,
      1.359560,
      0.171089,
      1,
      NULL,
      1.187770,
      0,
      NULL,
      0.013918,
      0,
      1,
      0.806175,
      2.943723,
      3,
      0,
      0.283934,
      NULL,
      1,
      0,
      1.573265,
      0,
      NULL,
      10.813200,
      1.068871,
      2,
      NULL,
      NULL,
      3.368936,
      2.607297,
      NULL,
      0.675426,
      1.387073,
      NULL,
      1.816882,
      NULL,
      NULL,
      1.657594,
      NULL,
      NULL,
      5,
      0,
      0.778294,
      0.601326,
      1.052589,
      NULL,
      3.482389,
      1,
      3,
      NULL,
      1.782562,
      1,
      0.856931,
      0.278356,
      2,
      1.777553,
      1,
      3,
      3.106668,
      0,
      1,
      NULL,
      6,
      NULL,
      5,
      3.184844,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.198918,
      0.456298,
      0.704237,
      1.997315,
      3,
      NULL,
      1,
      0,
      0,
      0,
      1,
      1,
      1,
      NULL,
      1,
      1.314195,
      0,
      0,
      0,
      NULL,
      0.187800,
      0.943237,
      5.642698,
      3,
      0,
      NULL,
      0,
      3.533677,
      0,
      2.422306,
      5,
      5,
      3,
      4,
      3.055540,
      5,
      NULL,
      NULL,
      2.394376,
      NULL,
      NULL,
      2,
      6,
      1.418059,
      NULL,
      1.622082,
      3.831740,
      3,
      ' 2- 7-1980',
      9,
      ' 4- 5-1979',
      4,
      0,
      0.620848,
      0,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      3,
      3.959603,
      NULL,
      2,
      0,
      0.714441,
      3.226373,
      NULL,
      1,
      0.694146,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.932479,
      0.187856,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11.821932,
      2,
      0.011710,
      NULL,
      NULL,
      NULL,
      0.237848,
      1,
      NULL,
      NULL,
      3.549500,
      1.069375,
      0.659759,
      1.840627,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.847395,
      3,
      1.212385,
      0,
      0.607000,
      NULL,
      0,
      1,
      21,
      1,
      0.693371,
      NULL,
      NULL,
      NULL,
      2.067457,
      0,
      2.398567,
      1,
      1.518722,
      NULL,
      2,
      0.194616,
      1,
      2.962808,
      1,
      NULL,
      NULL,
      1.806550,
      3.171588,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.297776,
      0.012783,
      1,
      1,
      0,
      0.073182,
      0.004142,
      1.579309,
      NULL,
      1,
      3,
      0,
      5.913599,
      8.035769,
      4.686483,
      3,
      6.194547,
      NULL,
      NULL,
      3.031417,
      0,
      0.142076,
      NULL,
      NULL,
      7,
      3,
      1,
      NULL,
      79,
      69.005177,
      61,
      NULL,
      0.146828,
      NULL,
      NULL,
      '11220',
      '',
      1.296297,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      2.727870,
      9.652189,
      NULL,
      10.259365,
      3.996262,
      43,
      8,
      8.622048,
      4.949006,
      3.335012,
      0.554716,
      1,
      1.777354,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      0.800724,
      3.122543,
      NULL,
      0.541043,
      0.988675,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      NULL,
      1,
      3.143357,
      1.495723,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.844675,
      NULL,
      NULL,
      5.805392,
      0.417984,
      0.927303,
      0.387076,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.487887,
      0.962802,
      NULL,
      0.891505,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      1,
      1,
      1,
      3,
      1.301861,
      1.371126,
      NULL,
      1.226495,
      1,
      3,
      1,
      2,
      3.558960,
      1.058386,
      NULL,
      NULL,
      1.554761,
      NULL,
      NULL,
      3.508053,
      NULL,
      0.954548,
      NULL,
      1,
      NULL,
      1,
      1.023991,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.564289,
      NULL,
      NULL,
      1.439800,
      NULL,
      NULL,
      0.392772,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.997066,
      0.625132,
      3.961578,
      1,
      1.525870,
      4.338804,
      0.897370,
      0.900743,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.738203,
      NULL,
      NULL,
      1.363405,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.864053,
      NULL,
      NULL,
      2.517244,
      0.485871,
      NULL,
      5,
      0.729931,
      NULL,
      5,
      2.103411,
      NULL,
      NULL,
      NULL,
      NULL,
      0.334924,
      0.789411,
      0,
      2.522749,
      2,
      2,
      0.388338,
      0,
      1,
      6.635807,
      3,
      4,
      3.351731,
      2.352546,
      3,
      1,
      NULL,
      0,
      2,
      2,
      0,
      0,
      1,
      2,
      6.556382,
      2,
      NULL,
      3.267838,
      0.030654,
      0,
      1,
      3.470084,
      0.242634,
      1,
      2.661128,
      0,
      1.049662,
      0,
      0,
      NULL,
      NULL,
      1.045707,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.121980,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.812040,
      NULL,
      NULL,
      0.309221,
      NULL,
      NULL,
      1.151123,
      NULL,
      NULL,
      1,
      2,
      0,
      1,
      1,
      0,
      3.188734,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.194863,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.103109,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.094818,
      1,
      NULL,
      NULL,
      1,
      1.749317,
      NULL,
      NULL,
      0.891526,
      0.017504,
      NULL,
      NULL,
      3,
      0.087717,
      NULL,
      NULL,
      NULL,
      0.803566,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      2.727443,
      2.901869,
      NULL,
      NULL,
      1.773452,
      3.811639,
      NULL,
      NULL,
      1.480034,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      3.487825,
      NULL,
      NULL,
      NULL,
      NULL,
      5.727564,
      5.103114,
      2,
      NULL,
      22,
      3,
      14,
      12,
      1,
      NULL,
      NULL,
      NULL,
      8.925430,
      5.520410,
      1,
      NULL,
      NULL,
      3,
      3,
      NULL,
      0.048209,
      NULL,
      1.143565,
      305,
      0,
      0,
      NULL,
      0.390249,
      3.342449,
      1,
      2.139972,
      NULL,
      2.041387,
      NULL,
      2,
      1.618322,
      1.736470,
      1,
      0,
      NULL,
      1,
      1.996628,
      3,
      NULL,
      0.871116,
      NULL,
      2.644682,
      NULL,
      1,
      NULL,
      0,
      NULL,
      3,
      NULL,
      42.836092,
      NULL,
      3,
      NULL,
      NULL,
      0.383792,
      3,
      NULL,
      NULL,
      1.180457,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.656114,
      NULL,
      NULL,
      NULL,
      1.447173,
      NULL,
      NULL,
      NULL,
      1.515280,
      NULL,
      1.777123,
      NULL,
      1,
      NULL,
      0.777860,
      NULL,
      0.582255,
      NULL,
      0.029670,
      NULL,
      0.147292,
      3.922477,
      0,
      1.833147,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.348288,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.195725,
      0.743169,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.080961,
      3.547668,
      NULL,
      2.398151,
      NULL,
      1.042044,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.468394,
      1.853683,
      0.515542,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.540640,
      3.308760,
      NULL,
      2.093356,
      NULL,
      0.284856,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.014651,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.291463,
      NULL,
      4.555526,
      NULL,
      0.081372,
      4.239206,
      4.156740,
      0.980083,
      NULL,
      3,
      1.267604,
      2.522340,
      1,
      NULL,
      0,
      NULL,
      1.760396,
      0.283525,
      1,
      0,
      2.584862,
      1,
      NULL,
      0,
      2.941666,
      0,
      1,
      0.677897,
      1,
      1.337724,
      1,
      2.085291,
      2.148212,
      3.298614,
      0,
      0,
      0.334548,
      1.220359,
      0.377068,
      0,
      0,
      NULL,
      1,
      0,
      1.665215,
      3.026592,
      0.318935,
      0,
      0.076525,
      NULL,
      NULL,
      0,
      NULL,
      2.196449,
      NULL,
      2.637373,
      NULL,
      0.360242,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.934463,
      NULL,
      0.514141,
      NULL,
      1.999845,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.863957,
      57,
      0,
      NULL,
      3,
      1.511730,
      0.821485,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.718479,
      NULL,
      0.266606,
      NULL,
      1,
      NULL,
      0,
      NULL,
      2.610426,
      NULL,
      0.660727,
      NULL,
      1.947558,
      NULL,
      1,
      NULL,
      0.145657,
      0,
      0,
      1.404380,
      1,
      NULL,
      10,
      NULL,
      1.908332,
      2,
      NULL,
      34.695101,
      4,
      NULL,
      5,
      '14232',
      '10400',
      '',
      1,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '');
commit;
end;
/


