set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9606885';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-5-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '0',
      NULL,
      NULL,
      '4343342',
      2,
      1.962091,
      1,
      NULL,
      '0402',
      0,
      NULL,
      NULL,
      NULL,
      ' 2- 3-1995',
      19.795388,
      NULL,
      4,
      3,
      0,
      NULL,
      17,
      2,
      199,
      58,
      3.372042,
      ' 3-24-1977',
      ' 1-24-1975',
      ' 2-29-1974',
      3,
      3,
      0.198734,
      1.943899,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      4,
      9,
      7.727476,
      12.177191,
      15,
      2,
      9,
      6,
      NULL,
      6.522917,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.251738,
      2,
      1,
      0.030047,
      1.096698,
      1.985326,
      0,
      0.558373,
      0.456036,
      NULL,
      11.444635,
      0.703594,
      NULL,
      4,
      5.385858,
      3,
      1.108010,
      0.474727,
      0,
      4,
      3,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      9.691488,
      9.055366,
      0,
      NULL,
      0.550006,
      NULL,
      NULL,
      1,
      NULL,
      3,
      1.893782,
      2,
      0,
      0.077662,
      1.353568,
      NULL,
      1.784162,
      0,
      4,
      0.642620,
      6,
      NULL,
      0.146787,
      5.017207,
      5,
      1.851040,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      0,
      1,
      0.108966,
      0,
      1,
      1.004565,
      0,
      0.686736,
      0.942104,
      1,
      1,
      0.132116,
      1,
      1.902385,
      1,
      0,
      0,
      NULL,
      0,
      5,
      2.714843,
      NULL,
      0.941023,
      1,
      3.320766,
      0,
      0.735427,
      2.215062,
      1.824063,
      NULL,
      0,
      5.059433,
      1.583282,
      6.396856,
      0,
      5.155694,
      6.157206,
      1.195305,
      0,
      0,
      NULL,
      8.542325,
      1.915814,
      1.879943,
      1.515148,
      3,
      '11-14-1977',
      403.318673,
      NULL,
      135,
      1,
      NULL,
      1,
      3.729212,
      0.688762,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.519189,
      1,
      1.263356,
      NULL,
      1.453863,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      5,
      1,
      3.630892,
      NULL,
      0.352641,
      1.899890,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.970558,
      6,
      0.496778,
      0,
      0.320211,
      NULL,
      NULL,
      NULL,
      0.751757,
      NULL,
      1.797175,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.818353,
      0.488363,
      0.269130,
      NULL,
      NULL,
      0.066557,
      0,
      2.950477,
      120,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.319044,
      0.644516,
      3,
      0,
      2.460431,
      NULL,
      NULL,
      2,
      3.111342,
      2,
      0.343955,
      3.355446,
      3,
      0,
      3.053812,
      9.586663,
      0,
      0,
      NULL,
      0,
      0.204504,
      NULL,
      NULL,
      0,
      1,
      0.601807,
      1.912066,
      NULL,
      0.731776,
      1.115665,
      2,
      0.321899,
      6,
      3.315143,
      NULL,
      NULL,
      7,
      6.464962,
      4,
      NULL,
      7,
      2.611756,
      NULL,
      2,
      24,
      1.106334,
      3.011979,
      NULL,
      32,
      NULL,
      NULL,
      3,
      3.613304,
      3,
      '44234',
      '02420',
      '',
      1.739571,
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      3.543157,
      37.620855,
      60,
      1.061579,
      1,
      NULL,
      1.726824,
      1,
      0.593723,
      1,
      3.446942,
      NULL,
      1.384504,
      NULL,
      NULL,
      0.420970,
      NULL,
      NULL,
      0,
      1,
      1.504714,
      0,
      2.523061,
      0.363978,
      3.460816,
      2.007104,
      0,
      3,
      1,
      1.540799,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      0.832108,
      0.219671,
      0.197446,
      NULL,
      1,
      NULL,
      1,
      7.924948,
      6,
      1.631429,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.019334,
      3.862388,
      1.463545,
      3.774362,
      1.874673,
      2,
      2.003875,
      2.844726,
      1,
      0.015112,
      3.332384,
      0.402847,
      NULL,
      0.925745,
      2,
      0,
      3,
      3,
      0.592375,
      0,
      3.068487,
      2.140747,
      2,
      NULL,
      0,
      1.499628,
      1.637944,
      NULL,
      NULL,
      NULL,
      NULL,
      3.295244,
      8.404111,
      2,
      4,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0.648929,
      0,
      NULL,
      1.043061,
      0,
      0.335552,
      NULL,
      NULL,
      9,
      1,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.592092,
      NULL,
      NULL,
      0.506389,
      NULL,
      NULL,
      1.729699,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.467944,
      3,
      NULL,
      1.469166,
      NULL,
      NULL,
      NULL,
      NULL,
      7.855881,
      NULL,
      4.029735,
      NULL,
      0,
      NULL,
      NULL,
      0,
      3.068902,
      0,
      2.416612,
      0,
      2,
      NULL,
      0,
      3,
      4.001059,
      NULL,
      1,
      0,
      0.135879,
      3,
      0.958603,
      0,
      NULL,
      1,
      2.178905,
      NULL,
      NULL,
      0.920610,
      3,
      NULL,
      3,
      4,
      4.196301,
      1,
      5,
      3.722176,
      2,
      6,
      0,
      0,
      0,
      1.778529,
      NULL,
      1.646263,
      NULL,
      NULL,
      0.450479,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.139971,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.149581,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.461781,
      1,
      0,
      1.582840,
      0.822187,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      120,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.657657,
      NULL,
      NULL,
      NULL,
      1.601129,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.964980,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.574413,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.420468,
      NULL,
      NULL,
      NULL,
      2.461475,
      1.538337,
      1.824010,
      5.770411,
      NULL,
      25.116975,
      0.823330,
      0,
      0,
      1.225542,
      0.049881,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.286383,
      NULL,
      NULL,
      0.909105,
      NULL,
      0,
      358.690561,
      3.868341,
      NULL,
      NULL,
      1.341957,
      0.783313,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.345997,
      0.102352,
      1.708212,
      NULL,
      0,
      0.561751,
      NULL,
      NULL,
      0.516837,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.730952,
      2.046596,
      1.067611,
      1,
      3.243719,
      NULL,
      3,
      NULL,
      11.214348,
      NULL,
      1,
      1.489611,
      0,
      1,
      NULL,
      0.470219,
      2.930686,
      NULL,
      2.675574,
      1.117068,
      NULL,
      0,
      0.298054,
      NULL,
      2.506871,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.283725,
      1.809531,
      NULL,
      1,
      1,
      NULL,
      1,
      3,
      NULL,
      1,
      0,
      NULL,
      0,
      1.644571,
      1.609510,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.909673,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.568695,
      NULL,
      1,
      NULL,
      1.786549,
      NULL,
      0.930992,
      2,
      NULL,
      3,
      NULL,
      1.530326,
      39.257395,
      1.154013,
      NULL,
      0.286188,
      NULL,
      '01204',
      '21303',
      '',
      1,
      '',
      '',
      '',
      1.815135,
      '',
      NULL,
      '');
commit;
end;
/


