set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6616650';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1982-10-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4243222',
      2,
      0.257737,
      0,
      0,
      '1141',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8- 7-2000',
      50.848076,
      NULL,
      2.289842,
      NULL,
      19,
      NULL,
      93,
      0,
      274,
      NULL,
      NULL,
      ' 0- 9-1989',
      ' 1-29-1988',
      ' 0-10-2001',
      0.653490,
      1.111537,
      NULL,
      0.752727,
      0,
      0.628107,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      11.395534,
      7,
      61,
      158.690228,
      NULL,
      11,
      NULL,
      1.807580,
      1.632826,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.054073,
      1.509092,
      NULL,
      0.418574,
      0,
      NULL,
      0.950925,
      3,
      0,
      NULL,
      NULL,
      1.916432,
      1.043178,
      5.618505,
      NULL,
      1,
      0,
      1.909177,
      0.739973,
      0.368447,
      1,
      0,
      NULL,
      0.307568,
      NULL,
      1.221188,
      1,
      1.667759,
      NULL,
      NULL,
      0.910332,
      NULL,
      NULL,
      0.760816,
      0,
      1.340162,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.732037,
      0,
      1.755436,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.324908,
      1,
      0,
      0,
      2.540007,
      1,
      5.406676,
      1,
      0.314571,
      NULL,
      0.046280,
      0.458696,
      1.666885,
      4.541393,
      1.815263,
      NULL,
      1.125706,
      1,
      1,
      NULL,
      1,
      0.559256,
      0,
      0,
      1.467493,
      1.413726,
      3,
      1.719738,
      0,
      1,
      1,
      0,
      0,
      1,
      1,
      1,
      2,
      1,
      2.712789,
      1,
      4,
      3,
      4,
      3,
      0.608424,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.932993,
      0,
      1,
      1.986956,
      1,
      0,
      1,
      0.106474,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.748965,
      0,
      1.071045,
      1.727475,
      NULL,
      0.930445,
      0.430405,
      NULL,
      NULL,
      NULL,
      0.127604,
      0,
      0.884473,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.490522,
      1,
      1.463219,
      0.501282,
      0,
      NULL,
      2.954211,
      NULL,
      3.114481,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.569322,
      4,
      2,
      5,
      NULL,
      4.914763,
      4.942185,
      2,
      0.475942,
      5.678765,
      1.377089,
      1,
      NULL,
      48.772468,
      NULL,
      NULL,
      NULL,
      2.671329,
      42.640545,
      33.105572,
      0,
      1.718598,
      1,
      '',
      '',
      '',
      NULL,
      '43431',
      NULL,
      '',
      1.786627,
      NULL,
      '',
      '',
      3.603458,
      30,
      188.922414,
      73,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.450620,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.868577,
      NULL,
      NULL,
      3.062536,
      3,
      0,
      0,
      3.800944,
      1,
      0.418159,
      NULL,
      2,
      NULL,
      1,
      0,
      0.314045,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.293018,
      NULL,
      NULL,
      1.597171,
      NULL,
      NULL,
      1.970823,
      NULL,
      NULL,
      2.863763,
      5,
      2,
      1.630722,
      NULL,
      NULL,
      NULL,
      NULL,
      0.083943,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.863075,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.766320,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      7.917114,
      0.134109,
      NULL,
      NULL,
      1.420528,
      NULL,
      NULL,
      2.142505,
      NULL,
      NULL,
      2,
      1,
      2,
      1.782824,
      NULL,
      NULL,
      4.635003,
      1,
      1.423739,
      0.038698,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.618369,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      3.681291,
      7.053400,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.401652,
      NULL,
      NULL,
      1.557405,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.023404,
      NULL,
      3.985175,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.693798,
      NULL,
      0.643588,
      1.765682,
      0,
      1,
      NULL,
      3.144415,
      2,
      1.117914,
      5,
      5,
      2.084031,
      NULL,
      NULL,
      3.121811,
      NULL,
      2.985028,
      0.915706,
      1,
      0.607761,
      1,
      1.660223,
      0.426709,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.137217,
      0,
      NULL,
      NULL,
      1,
      1.571121,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.878451,
      NULL,
      NULL,
      NULL,
      0.246295,
      1,
      1,
      0,
      NULL,
      NULL,
      1.481054,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.435330,
      NULL,
      NULL,
      1.170175,
      NULL,
      NULL,
      0,
      NULL,
      0.658734,
      1960,
      1173.546869,
      1.712055,
      0,
      1,
      1.283977,
      NULL,
      0.142455,
      1.605727,
      0,
      0,
      1.771143,
      0.173073,
      0.051926,
      NULL,
      1.865062,
      NULL,
      1,
      0.942670,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.195621,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.627077,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.777171,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.535578,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.113069,
      NULL,
      NULL,
      0.584502,
      NULL,
      NULL,
      0.446712,
      1,
      1.683975,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.038807,
      NULL,
      0.553432,
      2,
      9,
      1,
      2.176735,
      3.459255,
      88,
      87.288806,
      9.850175,
      NULL,
      0,
      '',
      '',
      '',
      0.877766,
      '12003',
      '',
      '',
      1,
      '',
      NULL,
      '');
commit;
end;
/


