set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9855678';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-12-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0.288273,
      3,
      2,
      NULL,
      3.948849,
      3,
      2.929085,
      0.997288,
      NULL,
      '31212024',
      20.925177,
      11,
      '0122104',
      1,
      1,
      NULL,
      1,
      '3124',
      1,
      0,
      NULL,
      NULL,
      ' 7- 4-1995',
      182.181835,
      85.464263,
      NULL,
      1.755131,
      2,
      ' 7-10-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-20-1981',
      NULL,
      ' 6-22-2002',
      1,
      NULL,
      2,
      1.436922,
      1.173373,
      2,
      1.488507,
      0,
      1,
      22.587826,
      NULL,
      9.973585,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      2,
      NULL,
      NULL,
      0.695091,
      0,
      0,
      NULL,
      0.008285,
      NULL,
      0.670825,
      NULL,
      0.511088,
      0,
      1,
      0,
      5,
      1,
      5,
      0.907539,
      1.337379,
      3,
      1,
      5.419789,
      11,
      0,
      1,
      0.442906,
      0,
      1,
      7,
      1,
      5.956964,
      1.262789,
      4,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.379145,
      1,
      9.246682,
      3.964063,
      0,
      1.482968,
      NULL,
      2,
      3,
      2.501052,
      0,
      0.796354,
      NULL,
      0,
      NULL,
      1.337451,
      NULL,
      0,
      0.017718,
      0.736930,
      NULL,
      1,
      NULL,
      NULL,
      2.550772,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.660881,
      1.995005,
      0.869570,
      0.719426,
      0,
      7.612983,
      1,
      3,
      0.811771,
      NULL,
      NULL,
      1.004665,
      3.192573,
      NULL,
      0.823338,
      NULL,
      0.133549,
      1.062552,
      NULL,
      1,
      NULL,
      1.553483,
      0.531557,
      1,
      0.461542,
      3.417762,
      2,
      0.368248,
      0.638898,
      0.153679,
      1,
      3,
      1,
      1.759550,
      1,
      2.397081,
      NULL,
      6.609868,
      NULL,
      5.967718,
      3,
      8.099352,
      5,
      0,
      0.530737,
      1.491713,
      0.861722,
      '10-17-1987',
      466.101098,
      NULL,
      152,
      2.659922,
      0.694796,
      1,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.189265,
      0,
      0.776130,
      5.838879,
      0,
      1,
      NULL,
      0.859384,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.886794,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.954382,
      1.213183,
      4.699491,
      0,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.686895,
      1,
      3,
      1.871353,
      0,
      0.622773,
      2.886513,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.124707,
      0.066663,
      0.064115,
      2,
      3,
      0.230431,
      1.487738,
      NULL,
      NULL,
      0.913395,
      1.024244,
      3,
      2,
      2.337619,
      4.182847,
      0,
      3.339233,
      0.460108,
      1.737238,
      NULL,
      1,
      0,
      0.407736,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      2.419568,
      2,
      NULL,
      7.593229,
      5.784117,
      0,
      8.072008,
      4,
      NULL,
      3,
      1.045708,
      3,
      3,
      3,
      0.697183,
      10.229447,
      2,
      2,
      18.551495,
      NULL,
      16,
      NULL,
      3,
      5.249389,
      NULL,
      '30413',
      '',
      '',
      1.050898,
      '',
      '',
      '',
      1.570617,
      '',
      '',
      '',
      3,
      9.702861,
      NULL,
      27,
      2.425362,
      NULL,
      NULL,
      7,
      3,
      0,
      2.397761,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.717593,
      1,
      0.395134,
      NULL,
      NULL,
      0.891560,
      0.326990,
      NULL,
      3.721673,
      3,
      0.866919,
      1.844797,
      1,
      1.302808,
      0.128556,
      NULL,
      NULL,
      1.456113,
      NULL,
      NULL,
      2,
      1,
      0.039388,
      1,
      NULL,
      NULL,
      11.831827,
      1,
      4,
      1.632256,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.724940,
      NULL,
      2.082841,
      3,
      NULL,
      0.873316,
      1.229781,
      1.023557,
      0.834559,
      3.739293,
      1,
      1.338985,
      NULL,
      NULL,
      1.874658,
      1.422853,
      1,
      NULL,
      2,
      0,
      NULL,
      1,
      1.951347,
      1.103223,
      0,
      2.828774,
      0.922101,
      NULL,
      NULL,
      NULL,
      NULL,
      1.597586,
      NULL,
      1,
      9,
      1.979786,
      1,
      1.328791,
      1.157532,
      NULL,
      NULL,
      NULL,
      1.603924,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.436784,
      NULL,
      NULL,
      0.361284,
      0,
      1,
      1,
      0.614148,
      1,
      5.627775,
      0,
      0,
      2.979454,
      0.661958,
      1,
      0.561796,
      NULL,
      NULL,
      5,
      1,
      2.257259,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.848516,
      NULL,
      NULL,
      0.479273,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.186520,
      NULL,
      0.786039,
      NULL,
      NULL,
      3,
      1,
      1,
      4.992420,
      0.683913,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0.927017,
      NULL,
      0,
      2,
      1.286361,
      0,
      NULL,
      6,
      5,
      2,
      3,
      1,
      NULL,
      3,
      1.044557,
      0,
      NULL,
      NULL,
      0.700524,
      3,
      3.209221,
      0,
      9,
      2.721967,
      1.695105,
      NULL,
      0,
      0,
      0,
      3.788116,
      NULL,
      1,
      NULL,
      0.516234,
      0,
      0.266555,
      3.205981,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.716886,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.552954,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.252184,
      NULL,
      NULL,
      1.536310,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.749838,
      0.962906,
      0,
      0.031369,
      3.082419,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.977883,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.439230,
      NULL,
      NULL,
      NULL,
      9.255353,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      1,
      44,
      NULL,
      0.660341,
      NULL,
      NULL,
      0.073983,
      100,
      NULL,
      1.979772,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      298,
      NULL,
      0.074577,
      0,
      0,
      NULL,
      1,
      0.200975,
      0,
      0.701978,
      0,
      0.885917,
      1.924224,
      1.603172,
      1.699692,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.947097,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.131087,
      0.230053,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.012328,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.443994,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.052512,
      3.444435,
      5.588235,
      0,
      5,
      NULL,
      NULL,
      NULL,
      15.942911,
      3.532460,
      1.253478,
      0,
      0.634083,
      0,
      NULL,
      3,
      0,
      NULL,
      3.235918,
      3.725151,
      NULL,
      1.606159,
      1,
      NULL,
      3,
      0,
      NULL,
      3,
      0.082599,
      NULL,
      0.973082,
      0.015234,
      NULL,
      NULL,
      3,
      NULL,
      1,
      0.371560,
      NULL,
      2.163088,
      0,
      NULL,
      2,
      NULL,
      NULL,
      0,
      1.120313,
      1.438791,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.905954,
      NULL,
      1.582332,
      NULL,
      1,
      1,
      NULL,
      NULL,
      62,
      62,
      5.050101,
      NULL,
      3,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


