set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7925101';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-5-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '20',
      '04',
      NULL,
      33,
      '1414341',
      1.239990,
      NULL,
      4,
      2,
      '2430',
      4.760669,
      1.907527,
      NULL,
      NULL,
      '11-18-2001',
      3,
      29,
      NULL,
      3,
      0,
      ' 5-17-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      3.033989,
      '11-16-1993',
      NULL,
      ' 0-16-1988',
      0.514633,
      3.875448,
      3.609814,
      NULL,
      3.055293,
      0.036250,
      0.038730,
      1.641007,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      1,
      1.137836,
      0.039200,
      0,
      NULL,
      0.433400,
      1,
      0,
      NULL,
      3.098999,
      1.866008,
      2.073626,
      1.507615,
      0,
      3.217386,
      2,
      0.492584,
      2.621241,
      NULL,
      1,
      4,
      0,
      3.795091,
      3.813378,
      1.157970,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.764838,
      1.067720,
      NULL,
      NULL,
      0.211987,
      NULL,
      NULL,
      NULL,
      6,
      2,
      2.323541,
      1,
      NULL,
      0,
      3,
      NULL,
      0.105489,
      3,
      3.583297,
      3.197896,
      0,
      3.626658,
      0.711574,
      NULL,
      3.786847,
      2,
      1.509064,
      1,
      1.331513,
      3.150006,
      0,
      1,
      3,
      1.990453,
      NULL,
      NULL,
      0.489459,
      NULL,
      NULL,
      1,
      0,
      4,
      1.764947,
      3.057268,
      1.726787,
      3.307369,
      NULL,
      0,
      1.358469,
      NULL,
      2,
      1.692282,
      NULL,
      NULL,
      0,
      1,
      1.611644,
      2.784164,
      NULL,
      0.959845,
      1,
      NULL,
      NULL,
      1,
      3,
      1,
      4,
      1,
      5.825670,
      1.499228,
      3,
      5.367480,
      1.533561,
      NULL,
      1,
      6,
      3.662352,
      3,
      0,
      NULL,
      0,
      7.995466,
      6.907219,
      4,
      NULL,
      1.201043,
      2,
      ' 9-26-1986',
      28.736276,
      ' 2- 1-1986',
      NULL,
      2,
      0,
      NULL,
      2,
      0.267478,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.013005,
      1.655630,
      0.421612,
      0.156659,
      0,
      0,
      1.641451,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.196881,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.122413,
      1.109872,
      0.444541,
      NULL,
      NULL,
      1,
      3.580308,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.106445,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.887930,
      1.245008,
      0.506290,
      1,
      0.128327,
      1.883943,
      82.915141,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.252515,
      0.697366,
      1.133590,
      3,
      3,
      2.682286,
      0.494438,
      0,
      2.807293,
      1.197864,
      3,
      3.937042,
      0.866623,
      1,
      3.866319,
      0.771800,
      1,
      NULL,
      NULL,
      1.025268,
      1.123525,
      NULL,
      NULL,
      0,
      0,
      1.770733,
      1.037533,
      NULL,
      0.806153,
      0,
      3.578796,
      0.381067,
      6,
      11,
      7.494674,
      NULL,
      5.308452,
      2,
      1.995164,
      1.495720,
      3,
      2,
      NULL,
      0,
      7,
      0.334009,
      NULL,
      0,
      NULL,
      1.579648,
      70,
      NULL,
      NULL,
      1.827896,
      '30204',
      '',
      '',
      0,
      '',
      '',
      NULL,
      0,
      NULL,
      NULL,
      '',
      1.439981,
      18.269407,
      54.970497,
      34.652628,
      0.527149,
      NULL,
      NULL,
      NULL,
      NULL,
      0.174964,
      2,
      1.699144,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.289466,
      3,
      3.990740,
      0.260184,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      2.497006,
      NULL,
      1.596226,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.332816,
      NULL,
      NULL,
      2,
      2,
      1.846780,
      2,
      0.164916,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.801552,
      3,
      0.439144,
      1,
      NULL,
      1,
      1.643033,
      NULL,
      NULL,
      0,
      0.556715,
      1,
      0,
      2,
      0,
      3.836795,
      1.362235,
      NULL,
      NULL,
      1,
      0,
      1,
      3,
      NULL,
      0.268880,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      2.787606,
      3,
      1.389422,
      NULL,
      NULL,
      NULL,
      1.641988,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.129305,
      NULL,
      NULL,
      0.424650,
      NULL,
      NULL,
      0.508639,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.359007,
      2.664650,
      NULL,
      1.958019,
      NULL,
      NULL,
      7,
      0.512564,
      3,
      0.380401,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.520676,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.898008,
      NULL,
      NULL,
      NULL,
      2,
      2.657670,
      3.402453,
      0.484880,
      5.647753,
      NULL,
      NULL,
      NULL,
      5.046223,
      NULL,
      3,
      2.266719,
      1.583355,
      1,
      0.030169,
      1,
      0,
      NULL,
      3.007099,
      0,
      4,
      4,
      0,
      2,
      NULL,
      3.407277,
      NULL,
      1.091589,
      2,
      NULL,
      1,
      2,
      3,
      1.874445,
      NULL,
      1.541528,
      0.967147,
      3,
      2,
      NULL,
      0,
      2.163326,
      NULL,
      NULL,
      NULL,
      0.673611,
      1,
      1.587299,
      0,
      2,
      NULL,
      NULL,
      0.523054,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.811555,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.497502,
      0.335279,
      1.264714,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.174380,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.799690,
      NULL,
      NULL,
      NULL,
      1.627514,
      NULL,
      NULL,
      NULL,
      0.470620,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.640831,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      1,
      2,
      12,
      NULL,
      1,
      NULL,
      NULL,
      3.911082,
      0.538978,
      1,
      1.637022,
      NULL,
      NULL,
      0.159609,
      NULL,
      NULL,
      NULL,
      NULL,
      1.317153,
      164.741592,
      1.975931,
      1.447926,
      0,
      1.546515,
      NULL,
      1.519983,
      0,
      1,
      NULL,
      NULL,
      0.889086,
      1,
      NULL,
      1,
      0.515126,
      1.300466,
      0.588059,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.047778,
      1.346343,
      0,
      8,
      NULL,
      3,
      2,
      NULL,
      NULL,
      3,
      1,
      0,
      NULL,
      0.342510,
      NULL,
      0.100043,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      3.221541,
      NULL,
      0,
      1.960303,
      NULL,
      1.289061,
      1,
      NULL,
      0.275169,
      0,
      NULL,
      1,
      1,
      NULL,
      1.897320,
      3.007897,
      NULL,
      1,
      0.498421,
      NULL,
      NULL,
      NULL,
      1.321313,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.473939,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      2,
      4,
      1.731146,
      NULL,
      NULL,
      65.056356,
      20.815719,
      NULL,
      5.883557,
      2.446503,
      '11003',
      '',
      '',
      0,
      '',
      '',
      '',
      1.680004,
      NULL,
      '',
      '');
commit;
end;
/


