set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8325901';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-11-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '1',
      NULL,
      NULL,
      '2043431',
      1,
      1,
      5,
      0,
      '4024',
      1.185435,
      3,
      1.262369,
      NULL,
      ' 1- 8-2001',
      16,
      NULL,
      1.480531,
      1,
      NULL,
      ' 6- 0-2001',
      49.894127,
      NULL,
      NULL,
      77,
      0.044692,
      ' 0-21-1990',
      '11-23-1975',
      ' 5-19-1989',
      2.323222,
      2,
      3.785166,
      2.985177,
      0.409701,
      NULL,
      4,
      0,
      0,
      NULL,
      NULL,
      7.251337,
      7,
      5,
      18,
      1,
      12.478111,
      4.562998,
      2,
      9,
      1,
      NULL,
      2,
      NULL,
      5.450372,
      1.942684,
      1.545952,
      0,
      1,
      NULL,
      1.204177,
      3,
      3.838870,
      NULL,
      1,
      5,
      0.734123,
      1,
      4.923091,
      NULL,
      NULL,
      NULL,
      3.494351,
      NULL,
      1,
      0.821291,
      0,
      3,
      1,
      4,
      NULL,
      2,
      0.658629,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.926359,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.996234,
      0,
      NULL,
      0.627403,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.958648,
      NULL,
      1,
      NULL,
      0.380602,
      NULL,
      1.035522,
      NULL,
      1,
      0.050467,
      0.972065,
      NULL,
      0.974115,
      5,
      NULL,
      2.188840,
      1,
      0.135367,
      4,
      NULL,
      3.764173,
      1.241912,
      0,
      0.586214,
      4,
      0.394651,
      NULL,
      3,
      3,
      4.934861,
      7.820014,
      NULL,
      7,
      5,
      0,
      1,
      2,
      0.051224,
      8,
      2.300981,
      7.694235,
      NULL,
      2,
      NULL,
      7,
      2.010361,
      NULL,
      NULL,
      ' 9-27-1980',
      108.487392,
      NULL,
      53,
      NULL,
      1,
      1,
      6.240447,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.263632,
      1.060625,
      1.364722,
      0.624501,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      40,
      2.350406,
      1.649919,
      6.285007,
      0.931666,
      0.699746,
      3,
      2,
      1,
      3,
      1.813760,
      1,
      1.603391,
      3.333049,
      2,
      1.606336,
      NULL,
      7,
      4,
      1,
      3.936862,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.529613,
      0.140780,
      NULL,
      0,
      NULL,
      0,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.116422,
      1.453409,
      2.409671,
      0.418973,
      3.301813,
      1.264516,
      2.363946,
      0,
      3.779972,
      0.647600,
      3,
      2,
      2,
      3,
      2.574749,
      3.306706,
      1,
      0.324916,
      0,
      2,
      NULL,
      0.363535,
      NULL,
      0,
      0.200219,
      NULL,
      0,
      1.828241,
      0,
      0.559496,
      2,
      1,
      1,
      6,
      5,
      5,
      4.503223,
      7.575934,
      NULL,
      2.576040,
      7,
      0,
      3,
      0.194690,
      30,
      1,
      NULL,
      NULL,
      45,
      33.928694,
      8.828467,
      3,
      NULL,
      3,
      NULL,
      '',
      NULL,
      1,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      0.470626,
      17.260310,
      282.874199,
      0,
      1,
      4.957480,
      NULL,
      1.323288,
      NULL,
      1.457351,
      NULL,
      NULL,
      0.596573,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.083708,
      NULL,
      NULL,
      1.690745,
      NULL,
      0.196671,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.856017,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.580397,
      NULL,
      NULL,
      1.030953,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.269214,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.000353,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.914189,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.427839,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.225348,
      NULL,
      NULL,
      1.346944,
      NULL,
      NULL,
      1.933796,
      NULL,
      0,
      3.782001,
      0,
      1.593961,
      0,
      1,
      1.105927,
      4.136524,
      NULL,
      1,
      1.185735,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.583555,
      1.679656,
      3.026967,
      3.299582,
      NULL,
      NULL,
      2,
      0,
      1.120614,
      3.413504,
      1.191097,
      NULL,
      1.387176,
      0,
      1,
      1.095826,
      NULL,
      NULL,
      0.238763,
      2,
      0,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      1,
      1.224112,
      0,
      1.633198,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.809654,
      NULL,
      0.069345,
      NULL,
      0,
      NULL,
      1.901806,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0.764216,
      3.662133,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.744620,
      0,
      0,
      NULL,
      NULL,
      1.845636,
      NULL,
      NULL,
      0.253989,
      NULL,
      0,
      4,
      2,
      NULL,
      1,
      0,
      0.741270,
      1.445848,
      0.506567,
      1,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      1.501415,
      1.226059,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      1.175198,
      3,
      1,
      3.811602,
      NULL,
      2.196277,
      14,
      0.174922,
      3.811425,
      0.062410,
      NULL,
      0,
      NULL,
      1.435550,
      1.713736,
      NULL,
      0.060778,
      1.414182,
      NULL,
      1,
      1.458288,
      NULL,
      1,
      0,
      NULL,
      1.038003,
      0,
      NULL,
      1.419423,
      3.749626,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.987012,
      NULL,
      2,
      3,
      NULL,
      1.173724,
      1,
      NULL,
      3,
      0,
      1.007434,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.726338,
      NULL,
      1.219145,
      NULL,
      2,
      1,
      0.828222,
      1,
      3,
      0,
      37.288219,
      67,
      NULL,
      0,
      0,
      '04322',
      '',
      '',
      0,
      NULL,
      '',
      '',
      0.748881,
      NULL,
      NULL,
      '');
commit;
end;
/


