set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8325901';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-7-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.252025,
      0,
      3,
      '2301',
      1,
      NULL,
      NULL,
      NULL,
      '11-18-2001',
      6,
      NULL,
      NULL,
      0,
      0.701388,
      ' 5- 4-1999',
      64,
      2.883038,
      343,
      143.702648,
      2,
      ' 7-28-1985',
      ' 5-22-1983',
      ' 3-23-1999',
      NULL,
      3,
      2.986721,
      2,
      0,
      2,
      1.808114,
      NULL,
      NULL,
      16.231122,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      0.998168,
      4.422378,
      6,
      NULL,
      7.009266,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      6,
      1.682377,
      7,
      1,
      6.391957,
      2,
      1,
      NULL,
      NULL,
      6,
      3.990481,
      NULL,
      8,
      1.966196,
      9.790360,
      0.285098,
      NULL,
      0.195615,
      0,
      0.490912,
      NULL,
      NULL,
      2,
      2.032000,
      0,
      3,
      1,
      1,
      1.247557,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.544778,
      3.006351,
      1,
      NULL,
      2,
      0.259894,
      1.842172,
      NULL,
      NULL,
      0.195684,
      NULL,
      0.494462,
      0.102156,
      0,
      NULL,
      0,
      1,
      0.982736,
      5,
      1.763222,
      0,
      5,
      1,
      0,
      0,
      5,
      1.120859,
      1.870819,
      NULL,
      0,
      2.408413,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.290430,
      NULL,
      5.008553,
      1.608309,
      1,
      0,
      0.460658,
      8.556789,
      7,
      NULL,
      NULL,
      1.794005,
      NULL,
      1,
      5,
      2.256314,
      NULL,
      3.098883,
      5,
      5.098035,
      NULL,
      0.846136,
      5.812558,
      2.125989,
      '11-11-1992',
      25,
      ' 0- 1-1982',
      25,
      3,
      0,
      1.808924,
      1.854135,
      0.499366,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.313697,
      0,
      0.371212,
      NULL,
      0.841403,
      1.704856,
      0.345194,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2.822039,
      2,
      NULL,
      1,
      0.000077,
      1.566672,
      1.770128,
      7.996826,
      3.265961,
      1,
      1.304280,
      0.680345,
      3,
      0,
      6,
      NULL,
      4.093043,
      7,
      8.295028,
      9,
      1.452128,
      NULL,
      NULL,
      NULL,
      2,
      5,
      1.517317,
      1,
      0.329907,
      0.315953,
      NULL,
      '11-21-1986',
      295.525144,
      ' 4-20-2000',
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.650609,
      0,
      1,
      NULL,
      1,
      1.464169,
      1,
      50.322292,
      1,
      0.337305,
      NULL,
      NULL,
      NULL,
      NULL,
      1.980109,
      2.366279,
      0,
      3.081428,
      0.515827,
      3,
      NULL,
      1,
      1.266714,
      2,
      3,
      3.891384,
      0.355358,
      0.540832,
      0,
      1.173591,
      0,
      NULL,
      NULL,
      0,
      1,
      0,
      1.750839,
      0.679632,
      4,
      1,
      NULL,
      1,
      1,
      3,
      0.524720,
      10.845481,
      7.463583,
      1.283843,
      6.709968,
      5,
      3.773383,
      4.535413,
      NULL,
      0,
      0.091763,
      1,
      1,
      22.540708,
      NULL,
      NULL,
      NULL,
      22,
      29,
      NULL,
      NULL,
      1,
      3,
      '34121',
      '',
      '',
      0.527752,
      '',
      '',
      NULL,
      0,
      '',
      '',
      '',
      3.644430,
      9.770619,
      295,
      44,
      3.570697,
      25,
      5.560078,
      3,
      NULL,
      2.450287,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.311996,
      1,
      NULL,
      0.470572,
      0.686534,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.677416,
      1,
      3,
      0.319685,
      0.573510,
      0,
      1,
      0.761900,
      0,
      0,
      0.038488,
      3,
      NULL,
      NULL,
      1,
      NULL,
      0.556354,
      4.843205,
      1,
      1.763178,
      0,
      1.746599,
      NULL,
      NULL,
      NULL,
      1.054955,
      NULL,
      NULL,
      NULL,
      3,
      0.804341,
      1.466225,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.786739,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.301762,
      0.676728,
      1,
      1.285236,
      NULL,
      NULL,
      0.119380,
      NULL,
      NULL,
      0.597858,
      NULL,
      1,
      1.643268,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.420139,
      NULL,
      0.136647,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3.291417,
      1,
      NULL,
      0.810756,
      NULL,
      NULL,
      3,
      0.511056,
      2,
      1.710046,
      NULL,
      NULL,
      0.225909,
      NULL,
      NULL,
      0.510848,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.240870,
      NULL,
      NULL,
      0.533087,
      NULL,
      NULL,
      3,
      1,
      3.463495,
      0.437543,
      NULL,
      NULL,
      9.379623,
      3,
      0.077271,
      7,
      NULL,
      3.925656,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      2.267410,
      2.964209,
      3,
      NULL,
      NULL,
      NULL,
      2.445377,
      1.467903,
      NULL,
      0.217660,
      3,
      NULL,
      1,
      NULL,
      1.098269,
      NULL,
      2.041620,
      3.338620,
      1.911159,
      NULL,
      2,
      NULL,
      4,
      2,
      1,
      0,
      1.676754,
      NULL,
      0.829530,
      NULL,
      0,
      NULL,
      1.795697,
      3.964758,
      NULL,
      NULL,
      0.497024,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.338724,
      NULL,
      NULL,
      1.544112,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.336911,
      NULL,
      NULL,
      0.225805,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      1,
      3,
      2.981009,
      NULL,
      NULL,
      1,
      2.445093,
      NULL,
      NULL,
      179,
      32.799285,
      NULL,
      NULL,
      2,
      3.743282,
      NULL,
      NULL,
      0.653985,
      2,
      NULL,
      NULL,
      1,
      0.855347,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      1.086386,
      NULL,
      NULL,
      NULL,
      3.756323,
      NULL,
      NULL,
      NULL,
      2.089185,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.544653,
      NULL,
      NULL,
      0,
      0.694745,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1,
      3.819694,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.395785,
      0,
      NULL,
      NULL,
      2.441772,
      1.688524,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      1,
      0.118774,
      NULL,
      NULL,
      5.959634,
      10.246519,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.621973,
      10.077922,
      1.879093,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      3.244939,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      12.702103,
      5.231373,
      NULL,
      0.305284,
      1.281044,
      1,
      0,
      1.982149,
      0.599591,
      NULL,
      0.384881,
      0.617954,
      0.616545,
      1,
      1.885423,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      2,
      5.678546,
      2,
      3.258673,
      13.057421,
      3.140439,
      3,
      2,
      0,
      1,
      0.172391,
      1.160584,
      NULL,
      3.748126,
      0.924562,
      1.161104,
      0.342037,
      0,
      1,
      0.361959,
      0.450786,
      0,
      3.216166,
      1.459695,
      1.334524,
      NULL,
      3.888785,
      NULL,
      3,
      3.290798,
      3.745818,
      0.628539,
      0,
      NULL,
      0,
      3.432659,
      3,
      2,
      0,
      0,
      0.657501,
      2,
      0,
      0.760860,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      3.277890,
      NULL,
      0,
      NULL,
      0.780020,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3.550612,
      NULL,
      3,
      NULL,
      1.721565,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.722250,
      NULL,
      0,
      9.518701,
      3,
      NULL,
      0,
      0.929936,
      1.629643,
      NULL,
      1.775531,
      0,
      2,
      1,
      7,
      1,
      1.568664,
      3,
      NULL,
      63,
      0.662384,
      1,
      3,
      '01024',
      '44243',
      '',
      3,
      '21243',
      '',
      NULL,
      0,
      '',
      '',
      '');
commit;
end;
/


