set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7616534';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-10-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '1',
      NULL,
      NULL,
      '1322404',
      1.806254,
      0,
      6,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      6.555624,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      100,
      128.239339,
      7,
      NULL,
      NULL,
      ' 0- 9-1997',
      2,
      NULL,
      1.582077,
      2.633221,
      1,
      NULL,
      NULL,
      1.787088,
      NULL,
      NULL,
      NULL,
      0,
      2,
      28.220454,
      8,
      NULL,
      7.843255,
      NULL,
      1,
      0.182071,
      NULL,
      0,
      1.653601,
      0.763139,
      0,
      0,
      0.442263,
      1,
      1.710833,
      NULL,
      1,
      5.351736,
      2,
      0,
      1.723859,
      9,
      1,
      1.270581,
      0.943030,
      1,
      1.194884,
      3.873577,
      1,
      NULL,
      0.471596,
      0,
      0,
      7,
      0,
      1.753233,
      NULL,
      1.566597,
      1.328540,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6.659137,
      NULL,
      0.227816,
      3.272524,
      NULL,
      1,
      3,
      1,
      1.999982,
      0.530164,
      NULL,
      1,
      0.134546,
      NULL,
      NULL,
      1,
      2.326054,
      1.635653,
      NULL,
      1,
      0.676702,
      0,
      6,
      0,
      NULL,
      3,
      0.660805,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.142720,
      3,
      1,
      0.184530,
      0.643125,
      NULL,
      NULL,
      1,
      1,
      0.151579,
      0,
      4,
      1,
      0.953605,
      1,
      0.418389,
      1.552444,
      1.550158,
      0,
      NULL,
      0,
      1.457203,
      0,
      0,
      0.800054,
      1.420011,
      0,
      1,
      0.303991,
      1,
      1,
      1.883177,
      1,
      1.456722,
      5,
      NULL,
      0,
      0,
      3.609115,
      5.110471,
      NULL,
      5,
      3.006866,
      0,
      1,
      1,
      NULL,
      2,
      ' 9-14-1992',
      28,
      ' 1-11-1996',
      5.810737,
      NULL,
      0,
      4.133371,
      4.265722,
      NULL,
      NULL,
      2,
      1.032515,
      NULL,
      1.891520,
      0.771096,
      1,
      0.416461,
      1.341735,
      0.436577,
      NULL,
      4,
      NULL,
      0,
      0.196010,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.484026,
      1.216413,
      NULL,
      0,
      1,
      0.648854,
      NULL,
      NULL,
      NULL,
      NULL,
      0.426881,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.257588,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      21.764467,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0,
      2.431033,
      1.877480,
      3,
      0,
      0,
      NULL,
      1,
      3.873312,
      NULL,
      1.467717,
      3,
      0.809121,
      1.044200,
      3.233396,
      2,
      0,
      0,
      NULL,
      NULL,
      1.649047,
      NULL,
      1,
      NULL,
      1,
      1,
      1.323966,
      0.401000,
      0.146957,
      1.071696,
      1.254721,
      11,
      8.349191,
      0.629504,
      8.320873,
      5.677319,
      7.252799,
      0.416104,
      2,
      2.150138,
      0.642375,
      0.551435,
      1,
      NULL,
      0,
      1.937075,
      46.650198,
      NULL,
      NULL,
      NULL,
      1,
      5.529071,
      2,
      NULL,
      '11430',
      '',
      1.463418,
      '1242',
      '',
      NULL,
      0,
      '',
      '',
      '',
      0.164216,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.455305,
      NULL,
      0.691908,
      NULL,
      NULL,
      1.097466,
      NULL,
      NULL,
      2.647048,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.567849,
      130,
      7.372503,
      NULL,
      0,
      2,
      0,
      NULL,
      0.714070,
      0.853498,
      0.331652,
      0.873330,
      1,
      NULL,
      0,
      NULL,
      0,
      0.653316,
      1,
      1,
      1.737607,
      NULL,
      NULL,
      3.744882,
      NULL,
      1,
      NULL,
      3,
      NULL,
      0,
      NULL,
      91.147682,
      NULL,
      2.898160,
      NULL,
      12.764293,
      NULL,
      0.938417,
      NULL,
      2,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.282012,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.870790,
      NULL,
      2.361476,
      NULL,
      1,
      NULL,
      0.151457,
      NULL,
      0.697129,
      NULL,
      1,
      NULL,
      2.808231,
      NULL,
      1,
      1.672604,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.139373,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.142116,
      NULL,
      1.363018,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.987674,
      NULL,
      1,
      NULL,
      3,
      0,
      0.491840,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.995127,
      NULL,
      1,
      NULL,
      0.013325,
      NULL,
      0,
      NULL,
      1.609347,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.189476,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      1,
      1.862564,
      NULL,
      1.871014,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.870396,
      7.140632,
      NULL,
      3,
      0.736923,
      2,
      NULL,
      NULL,
      2.877859,
      NULL,
      0,
      0.050792,
      0,
      2,
      3,
      6,
      1.835467,
      3,
      1,
      NULL,
      0,
      1.308688,
      0.427111,
      0.962795,
      1,
      1,
      1.619848,
      1,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      0,
      1.325853,
      1,
      1.033003,
      0,
      0.319760,
      0,
      NULL,
      1,
      0,
      1.958453,
      NULL,
      1,
      0.031516,
      1.198867,
      NULL,
      1,
      1.679115,
      3,
      2.311787,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.625312,
      1,
      1.998742,
      1,
      1,
      NULL,
      5.473841,
      1,
      NULL,
      NULL,
      81,
      19.770623,
      5.915262,
      3,
      3,
      NULL,
      '41304',
      '',
      NULL,
      '2401',
      '',
      NULL,
      0,
      NULL,
      NULL,
      '');
commit;
end;
/


