set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6228275';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-3-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '12',
      7,
      13.999927,
      '1101414',
      NULL,
      1.101898,
      1,
      1,
      '4221',
      3,
      0,
      NULL,
      NULL,
      ' 6-22-1988',
      69,
      25,
      NULL,
      1,
      1.661635,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      ' 7-15-1994',
      NULL,
      NULL,
      1.767997,
      NULL,
      NULL,
      2.499098,
      NULL,
      0,
      2,
      NULL,
      5,
      12,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3,
      NULL,
      0,
      1.505745,
      NULL,
      0.558084,
      NULL,
      1,
      1.996887,
      0,
      1.359807,
      0,
      1.823301,
      1.858408,
      1.352426,
      1,
      NULL,
      2,
      0.191135,
      0.885760,
      1,
      1,
      5,
      NULL,
      1.440365,
      NULL,
      NULL,
      0.314494,
      1.840222,
      8,
      1.029167,
      NULL,
      0.779344,
      1.837883,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.485071,
      0,
      0.526515,
      0.091113,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.727863,
      0.921224,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.946477,
      NULL,
      4.225996,
      NULL,
      2.350783,
      NULL,
      5,
      0.199654,
      NULL,
      1.942901,
      1,
      NULL,
      1,
      4.750606,
      0,
      1.603642,
      1,
      NULL,
      0.928937,
      NULL,
      0,
      1.520509,
      1.870301,
      1.200573,
      1.741151,
      1,
      1,
      0.611181,
      0.572336,
      NULL,
      1,
      NULL,
      NULL,
      0.058890,
      NULL,
      2.023836,
      4.806389,
      1.303689,
      NULL,
      NULL,
      1.142638,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      0.099907,
      1,
      ' 9-22-1979',
      NULL,
      ' 9-13-1985',
      1859.614674,
      0.339108,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      6.528292,
      NULL,
      3,
      0,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.341343,
      1,
      3.692142,
      3.344075,
      2.602181,
      1,
      0,
      0.156137,
      1,
      0.366640,
      NULL,
      0.009384,
      1.878763,
      NULL,
      NULL,
      NULL,
      0.650763,
      0.455633,
      0.827245,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.937556,
      0.462343,
      0.361859,
      0,
      0,
      1.013797,
      0.873708,
      NULL,
      1.037358,
      1.652605,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.925783,
      2.606616,
      NULL,
      1,
      NULL,
      1,
      0.771952,
      NULL,
      2.532781,
      3.297948,
      2,
      0.841730,
      3.509733,
      4,
      1,
      0.340252,
      1.386393,
      0,
      0.091719,
      1,
      0.977544,
      1.849744,
      2.297625,
      1,
      1.809677,
      4,
      1.852404,
      0.010060,
      1,
      8.373855,
      7,
      6.455632,
      9,
      0.825758,
      7.433423,
      4,
      NULL,
      0,
      1.258658,
      NULL,
      0,
      66,
      0,
      NULL,
      30,
      NULL,
      NULL,
      NULL,
      3,
      5,
      2,
      '42040',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      0.039741,
      NULL,
      '',
      '',
      3.133459,
      42,
      716.495305,
      43.369268,
      0.699282,
      NULL,
      NULL,
      NULL,
      NULL,
      0.970392,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.734878,
      1.310235,
      1.668250,
      NULL,
      NULL,
      NULL,
      3,
      0.514333,
      3.899377,
      NULL,
      NULL,
      NULL,
      0.679894,
      NULL,
      NULL,
      0.253636,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.089737,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.080194,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.639485,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4.661082,
      0,
      1.830877,
      NULL,
      0.846487,
      NULL,
      NULL,
      NULL,
      0.472097,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.668440,
      0.314225,
      3,
      3,
      NULL,
      1,
      1.705779,
      NULL,
      NULL,
      4.115634,
      NULL,
      NULL,
      1,
      0,
      3.649721,
      0,
      1,
      3.553955,
      2.550205,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.132606,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.598639,
      NULL,
      NULL,
      0.513067,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4.377310,
      3.316566,
      NULL,
      1,
      3,
      3.646994,
      NULL,
      3,
      0.014872,
      0,
      NULL,
      NULL,
      7,
      7.080178,
      3.089125,
      NULL,
      3,
      1.271684,
      1,
      NULL,
      NULL,
      0,
      1.266280,
      1,
      NULL,
      1.302365,
      2,
      NULL,
      4,
      7,
      0.860578,
      NULL,
      NULL,
      0.085038,
      NULL,
      4.472926,
      NULL,
      1.440895,
      NULL,
      1.011754,
      1,
      3.611202,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.234708,
      NULL,
      NULL,
      2.344952,
      NULL,
      NULL,
      0.959191,
      NULL,
      NULL,
      3.896410,
      NULL,
      NULL,
      0.774092,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.579296,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      0,
      0,
      0.764114,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.318724,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.296193,
      NULL,
      NULL,
      NULL,
      7.615922,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      486,
      25990.669415,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.605762,
      NULL,
      0,
      1.529687,
      0.294561,
      0,
      0.199675,
      1,
      NULL,
      0.882438,
      NULL,
      1,
      1.305254,
      0,
      1,
      1.885458,
      NULL,
      0.106034,
      1,
      1.326609,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.331395,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.739741,
      0.179072,
      NULL,
      NULL,
      1.753212,
      1.315674,
      1.531907,
      2,
      1,
      3.323610,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      1.195571,
      NULL,
      NULL,
      1.159366,
      NULL,
      NULL,
      0.806725,
      1.880584,
      NULL,
      1,
      3.181764,
      NULL,
      0.190255,
      0.666491,
      NULL,
      3,
      0,
      NULL,
      0,
      1.917214,
      NULL,
      0,
      0.178856,
      NULL,
      NULL,
      0.065275,
      1.991025,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.666821,
      NULL,
      1.848199,
      NULL,
      NULL,
      NULL,
      6.626832,
      NULL,
      2.727607,
      1.750744,
      1,
      2.486629,
      16,
      46,
      NULL,
      3.630321,
      0.052905,
      '20420',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


