set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9875215';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-5-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1,
      2.930434,
      7.985714,
      0,
      1,
      NULL,
      1,
      NULL,
      '324',
      '00021031',
      6,
      38.173124,
      '0144032',
      1.552990,
      1,
      3,
      3,
      '0234',
      5,
      NULL,
      NULL,
      NULL,
      ' 7-19-2001',
      128.079045,
      140.953129,
      NULL,
      0,
      1.451703,
      '11-25-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      2.456470,
      '10-11-2000',
      '10- 9-2000',
      ' 1-19-1986',
      NULL,
      2,
      2,
      3.062728,
      1.985442,
      2,
      5.013026,
      1,
      1.907569,
      2.478199,
      7,
      0.874189,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      7.501533,
      1,
      NULL,
      0.234975,
      NULL,
      1,
      1,
      1,
      1,
      0.555686,
      1,
      0.778954,
      0,
      0,
      NULL,
      3,
      4.428645,
      2.673118,
      NULL,
      0.706333,
      0.403800,
      1,
      1.606844,
      7,
      4,
      4,
      3,
      3,
      2.004717,
      0.051957,
      2,
      1.259032,
      1.261363,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0.789583,
      NULL,
      NULL,
      NULL,
      1.076606,
      NULL,
      2,
      NULL,
      3.915662,
      3.470269,
      NULL,
      NULL,
      1.226681,
      2,
      NULL,
      1.302229,
      0.785047,
      NULL,
      1,
      NULL,
      0.276558,
      1.489502,
      7,
      0.680037,
      2.770085,
      2,
      NULL,
      2,
      2.772991,
      0.041379,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.853907,
      4,
      NULL,
      NULL,
      1.633038,
      4,
      1,
      3.661896,
      NULL,
      1,
      0,
      NULL,
      NULL,
      5,
      1.502479,
      0.525737,
      NULL,
      1,
      0.616236,
      NULL,
      1,
      1.002224,
      4,
      NULL,
      NULL,
      2,
      4.059670,
      0,
      0.537996,
      1.740183,
      1,
      3,
      1.136961,
      NULL,
      7,
      NULL,
      6,
      1.015105,
      3,
      0,
      7.837770,
      NULL,
      3.088781,
      NULL,
      0,
      3,
      5,
      NULL,
      '11-15-1988',
      NULL,
      ' 0-20-1977',
      84.942021,
      3,
      1,
      0.457589,
      NULL,
      1.039022,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      5.286310,
      NULL,
      NULL,
      5.550721,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.183144,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.981937,
      0,
      4,
      0.336923,
      0,
      7.683731,
      1.448879,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.164621,
      1,
      NULL,
      NULL,
      0,
      0.964555,
      1.150394,
      1,
      25,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.294201,
      2,
      1,
      0,
      1.206777,
      2,
      3,
      3.748291,
      3.419232,
      3,
      0.050885,
      0,
      2.873887,
      0.335719,
      0,
      0,
      0,
      3.892054,
      0,
      NULL,
      1,
      0.555582,
      NULL,
      NULL,
      NULL,
      1,
      3.823616,
      0,
      1.764194,
      0,
      6.921526,
      9,
      1,
      10,
      11.615156,
      1,
      2,
      NULL,
      NULL,
      NULL,
      1,
      0,
      14.777781,
      NULL,
      3.199663,
      55.625579,
      NULL,
      56.729242,
      4,
      3,
      2.713072,
      0,
      NULL,
      NULL,
      '',
      1,
      '',
      '',
      '',
      0.636971,
      '00144',
      '',
      '',
      2,
      7.195514,
      60,
      24.653414,
      3,
      20,
      1.603950,
      0.788614,
      2,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.498278,
      2.961887,
      2,
      1,
      2,
      2,
      0.641578,
      2,
      3,
      NULL,
      NULL,
      3,
      0.914755,
      NULL,
      NULL,
      1.992434,
      NULL,
      NULL,
      0.637836,
      NULL,
      NULL,
      0.653746,
      NULL,
      NULL,
      3.356032,
      2.894952,
      1,
      3.411144,
      NULL,
      0,
      1.417643,
      0.322655,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.766854,
      3,
      0.039075,
      NULL,
      NULL,
      2,
      0,
      2.965412,
      1.283684,
      3,
      1.456629,
      0,
      1,
      1.883561,
      3.345043,
      1.682221,
      2.610431,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      2,
      0,
      NULL,
      NULL,
      2,
      1.292365,
      NULL,
      1.217435,
      4,
      NULL,
      NULL,
      1.863797,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.175399,
      0.566257,
      3,
      2.963408,
      3.411874,
      NULL,
      1.731023,
      NULL,
      NULL,
      3,
      NULL,
      7,
      3,
      3.021696,
      0.561128,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      7.660721,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.493551,
      NULL,
      NULL,
      1.472153,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.825000,
      1,
      3.832556,
      4,
      4.688803,
      2.221100,
      0.826221,
      NULL,
      2,
      7.505480,
      NULL,
      1.298868,
      NULL,
      NULL,
      NULL,
      1.556134,
      1,
      3.629860,
      0,
      NULL,
      NULL,
      4,
      3.285575,
      6.308512,
      3.591003,
      0.153209,
      NULL,
      0,
      0,
      NULL,
      2.914945,
      1,
      NULL,
      2,
      3.384531,
      2,
      3,
      4,
      NULL,
      NULL,
      5.626027,
      3.259859,
      0.659043,
      2.848016,
      NULL,
      1.177884,
      NULL,
      1,
      0,
      0.022121,
      0.380498,
      NULL,
      NULL,
      0.524189,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.274135,
      NULL,
      NULL,
      3.273996,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.574692,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      1,
      0.410369,
      0,
      1,
      3,
      1.922989,
      NULL,
      NULL,
      1.835148,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.868172,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.808521,
      1,
      1.215981,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.377494,
      NULL,
      NULL,
      1.258743,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.724242,
      NULL,
      0.172408,
      0.657232,
      0,
      0,
      0.683878,
      NULL,
      0,
      NULL,
      0.685087,
      1,
      0.701315,
      0.411127,
      0.353088,
      NULL,
      0,
      1.364223,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.261362,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.940526,
      1,
      NULL,
      1,
      NULL,
      0.429250,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      1,
      3.236479,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.649813,
      NULL,
      0.881394,
      NULL,
      0,
      0.048486,
      0.553250,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.338344,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      6.277602,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0.092355,
      NULL,
      1.057561,
      NULL,
      NULL,
      0.436127,
      NULL,
      NULL,
      0,
      2.412201,
      NULL,
      0.492660,
      2,
      NULL,
      NULL,
      0.995636,
      NULL,
      NULL,
      1.482607,
      NULL,
      1.285374,
      1,
      NULL,
      0,
      0.902368,
      NULL,
      1.858805,
      NULL,
      NULL,
      1.122095,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      3.703867,
      0.398067,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.390697,
      NULL,
      0.943703,
      NULL,
      7.368618,
      1.265767,
      3,
      3,
      1.702178,
      1,
      45.792374,
      36.729058,
      NULL,
      5.567908,
      1,
      '40122',
      '',
      '',
      1.691024,
      '',
      '',
      '',
      1,
      '12244',
      '',
      '');
commit;
end;
/


