set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9229226';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-6-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '3',
      NULL,
      NULL,
      '4440131',
      1.734906,
      1,
      NULL,
      2,
      '1144',
      NULL,
      1,
      NULL,
      NULL,
      '11-26-1977',
      34,
      NULL,
      2,
      NULL,
      2.677826,
      NULL,
      45.115706,
      NULL,
      312.960833,
      110,
      NULL,
      '10-26-1986',
      '10-25-1991',
      ' 0-29-1983',
      1,
      3,
      1.995494,
      NULL,
      1,
      0.703967,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.784742,
      35,
      4.483520,
      1,
      NULL,
      4.272768,
      2,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.172062,
      1.204405,
      NULL,
      2,
      4.891222,
      1,
      4,
      6,
      2.330039,
      NULL,
      2,
      0,
      7,
      0,
      2.978743,
      1.647911,
      9.222575,
      0,
      0.068001,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.510574,
      3,
      3.730520,
      1.159135,
      0.312487,
      NULL,
      0,
      NULL,
      NULL,
      0.973877,
      0.577083,
      1.478470,
      0,
      2,
      0.565892,
      0,
      0.008855,
      1.722535,
      NULL,
      NULL,
      1,
      5,
      1,
      0.046423,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.567770,
      1,
      NULL,
      1.121387,
      4.095988,
      9.807474,
      7.030484,
      NULL,
      1.588008,
      4,
      NULL,
      NULL,
      NULL,
      7.836671,
      NULL,
      1,
      1,
      0.996898,
      0.479486,
      NULL,
      0.850223,
      0,
      5,
      7,
      NULL,
      0.446552,
      NULL,
      1,
      NULL,
      0.474408,
      5.906720,
      1,
      1,
      7,
      1.278294,
      NULL,
      0.082107,
      0.136130,
      NULL,
      0,
      8,
      3.605614,
      7.703711,
      9,
      2.115177,
      0,
      4,
      3.121143,
      ' 6- 8-1985',
      NULL,
      NULL,
      27,
      0,
      0.895544,
      0.994332,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.311264,
      NULL,
      NULL,
      1.719961,
      0,
      1.296614,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.782334,
      0.390336,
      0.060054,
      0.100705,
      NULL,
      0.912924,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.623821,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.422695,
      1.525919,
      0.633746,
      0.139976,
      NULL,
      NULL,
      1,
      13.854900,
      0,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0,
      3.918978,
      NULL,
      1,
      0,
      2.926856,
      3.631358,
      1,
      2,
      3,
      NULL,
      NULL,
      2.932393,
      3,
      0,
      NULL,
      0,
      0,
      0.096230,
      1,
      1.511389,
      1.042439,
      1.455986,
      1,
      1,
      0,
      1.959104,
      1.438222,
      0,
      1.201659,
      1.389357,
      2.596112,
      1,
      NULL,
      7,
      8,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      57.139922,
      0.056251,
      0.968687,
      NULL,
      38,
      24.314888,
      74.114081,
      4.219957,
      NULL,
      4.939491,
      '42411',
      '44000',
      '22114',
      NULL,
      '',
      NULL,
      '',
      0.062645,
      '',
      NULL,
      '',
      1.325039,
      22,
      15.035344,
      27.285924,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.738867,
      1,
      2,
      0.235987,
      0,
      1,
      2,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.369919,
      NULL,
      0.943766,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.678242,
      NULL,
      NULL,
      2,
      1,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.616081,
      NULL,
      NULL,
      NULL,
      NULL,
      2.829129,
      2,
      0.000806,
      NULL,
      NULL,
      0.065533,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.387786,
      0.715815,
      0,
      0,
      1.617392,
      1.356412,
      0,
      1.057933,
      0,
      2.875196,
      1.467590,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.717093,
      NULL,
      NULL,
      4,
      4,
      1.977585,
      1.316821,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.483543,
      NULL,
      NULL,
      NULL,
      2,
      1.572762,
      0.098343,
      NULL,
      NULL,
      2.843650,
      2,
      NULL,
      0,
      1.038326,
      NULL,
      NULL,
      NULL,
      NULL,
      6.877343,
      2.894498,
      3,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.359019,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.161737,
      NULL,
      NULL,
      0.482471,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      2,
      NULL,
      3,
      2.325784,
      5,
      3,
      3.998806,
      NULL,
      1,
      NULL,
      NULL,
      0.090739,
      NULL,
      NULL,
      0.495958,
      3,
      3,
      3,
      0.972595,
      NULL,
      2,
      5,
      4.481460,
      2,
      NULL,
      0,
      3.124444,
      0.761688,
      3.492675,
      NULL,
      1,
      2,
      3.225535,
      0,
      0,
      7.933281,
      NULL,
      6,
      3,
      5,
      2.255972,
      2.180720,
      1,
      NULL,
      1.213016,
      1,
      0.758983,
      NULL,
      0.764741,
      1,
      NULL,
      NULL,
      1.440433,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.832990,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.007104,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.246210,
      NULL,
      NULL,
      0.450046,
      NULL,
      NULL,
      1,
      0.681769,
      NULL,
      1.510286,
      1,
      0,
      0,
      NULL,
      NULL,
      0.403268,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.124932,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.228441,
      NULL,
      NULL,
      NULL,
      3.357570,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.039030,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      5.010594,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1.079279,
      0.413572,
      0.945216,
      NULL,
      NULL,
      0.091797,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      14,
      1,
      0,
      NULL,
      NULL,
      0.500634,
      NULL,
      0,
      123,
      1,
      3.888300,
      1,
      1,
      0,
      1.685502,
      0,
      1,
      0,
      1.676282,
      NULL,
      0.503986,
      0,
      NULL,
      0.582063,
      NULL,
      NULL,
      NULL,
      NULL,
      1.430789,
      NULL,
      3,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      49.093642,
      NULL,
      1.710694,
      NULL,
      18,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.599338,
      NULL,
      0.190115,
      NULL,
      0.718096,
      NULL,
      1,
      NULL,
      0.461716,
      NULL,
      0.166712,
      NULL,
      0.706146,
      NULL,
      0.312511,
      NULL,
      3,
      1.394026,
      0.960639,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.687397,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.717467,
      1.105921,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.118895,
      1.362662,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.812761,
      NULL,
      NULL,
      NULL,
      1.543488,
      2.413120,
      0.896507,
      NULL,
      NULL,
      2.042361,
      NULL,
      85,
      NULL,
      NULL,
      NULL,
      1.736604,
      NULL,
      0,
      NULL,
      3,
      1.609156,
      31,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      2.917945,
      0,
      NULL,
      NULL,
      5,
      3.512780,
      4.473071,
      NULL,
      NULL,
      NULL,
      1,
      0.322841,
      0,
      NULL,
      1.850439,
      2.151476,
      NULL,
      NULL,
      2,
      NULL,
      3.982291,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.506878,
      2.696326,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.454014,
      NULL,
      NULL,
      1,
      NULL,
      2,
      2.869391,
      NULL,
      0.893333,
      0.844697,
      NULL,
      3,
      0.628761,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.832081,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.118835,
      1.282766,
      8.240796,
      0.056261,
      NULL,
      NULL,
      22,
      27,
      NULL,
      NULL,
      NULL,
      '23424',
      '32440',
      '32434',
      0,
      NULL,
      '',
      '',
      1.468747,
      '',
      '',
      '');
commit;
end;
/


