set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7420666';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-6-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      NULL,
      '0342401',
      0,
      1,
      3,
      3,
      '4140',
      3,
      0.655737,
      NULL,
      NULL,
      NULL,
      27,
      NULL,
      3,
      NULL,
      1,
      ' 6-19-2003',
      48,
      3.197167,
      112.714069,
      9.024754,
      1,
      NULL,
      NULL,
      ' 6-23-1986',
      2.012213,
      0.885950,
      0.162468,
      1.953262,
      1,
      2.133579,
      4.218842,
      1.186190,
      0.921828,
      74,
      6,
      16.191326,
      3.486388,
      2,
      10.656280,
      4.737747,
      NULL,
      4.124598,
      3.925426,
      1,
      1,
      NULL,
      NULL,
      0.428241,
      0,
      1.875156,
      1.260743,
      1,
      1,
      0,
      159,
      NULL,
      NULL,
      7,
      2.138800,
      3,
      NULL,
      NULL,
      4.021086,
      NULL,
      NULL,
      1,
      1.444194,
      7.925169,
      1,
      1.048767,
      0.193917,
      6.742613,
      0.941535,
      2.945407,
      4.972127,
      0.316561,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4.980996,
      1.990809,
      0.928523,
      2,
      3,
      0,
      1,
      0,
      3,
      1.880462,
      0,
      0,
      0.976279,
      1,
      3.635148,
      0.091217,
      0.616935,
      0.499061,
      3.097095,
      0.965139,
      1,
      2.755944,
      2.501170,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.130712,
      3.561730,
      1,
      6,
      NULL,
      3.413691,
      NULL,
      5,
      1.096257,
      2.514819,
      4,
      5,
      6.842221,
      0.459081,
      1,
      0.937898,
      NULL,
      1,
      NULL,
      0.557061,
      0.651017,
      3,
      0,
      1,
      0,
      7,
      NULL,
      0,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      0.237002,
      4.841796,
      1.169845,
      9.234462,
      1,
      8.442974,
      5,
      6,
      2.826887,
      NULL,
      0,
      6.313568,
      2.898314,
      ' 8- 8-1981',
      183.445414,
      NULL,
      1281,
      0,
      1.575789,
      1,
      2,
      1.037613,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.122891,
      0.364347,
      0.928166,
      NULL,
      1.130983,
      NULL,
      0.885476,
      1.790341,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.514772,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.829008,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.681116,
      3.836149,
      0.926231,
      1.802482,
      5.584265,
      0.482411,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.938228,
      NULL,
      1,
      1.801664,
      1.647109,
      0.564330,
      1,
      NULL,
      14665,
      1,
      3,
      28.427199,
      476,
      1828.434148,
      3,
      0.078458,
      1.609328,
      NULL,
      0,
      3.143005,
      3,
      NULL,
      NULL,
      1,
      3.197617,
      2,
      3,
      NULL,
      3,
      0.862897,
      2.359066,
      0.287355,
      0,
      3.011825,
      NULL,
      0.321540,
      NULL,
      1.050737,
      NULL,
      1.351581,
      0,
      1,
      1,
      0.744972,
      3.088027,
      0.362157,
      NULL,
      9.308333,
      2.364661,
      11.433793,
      4,
      NULL,
      3.975869,
      0,
      NULL,
      3.343301,
      2,
      0.135639,
      9.833783,
      2.640738,
      3.323227,
      NULL,
      11,
      5.893310,
      NULL,
      0.110680,
      0.067365,
      3,
      NULL,
      NULL,
      '',
      0.730606,
      '',
      '',
      '',
      0,
      '20324',
      '00421',
      '',
      3.843578,
      29.079349,
      1061,
      45,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.434745,
      3,
      NULL,
      2.187405,
      1.643260,
      0.479679,
      0.310883,
      3.334105,
      3.638946,
      0.697340,
      0,
      1,
      1,
      NULL,
      NULL,
      0.782912,
      NULL,
      NULL,
      0.619126,
      3.186572,
      2.412551,
      NULL,
      1.953779,
      1,
      3.596622,
      0,
      0,
      2.946187,
      NULL,
      1.347057,
      3.696385,
      1.341400,
      1,
      0.301083,
      NULL,
      NULL,
      4,
      4,
      7.136378,
      0.527494,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      2.430476,
      NULL,
      1.772629,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.772786,
      1.873484,
      NULL,
      3,
      1.171903,
      1.346831,
      1,
      1,
      1.997893,
      2.910044,
      0,
      1.628342,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.137924,
      1,
      0.217819,
      NULL,
      NULL,
      4,
      2.068110,
      2.472447,
      0,
      0.963510,
      NULL,
      NULL,
      NULL,
      1.471232,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.303813,
      3.702091,
      1,
      3,
      1,
      1.739797,
      NULL,
      NULL,
      NULL,
      3,
      2.162673,
      3.534663,
      3,
      1,
      NULL,
      0,
      NULL,
      2,
      5,
      7,
      1.609451,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.812026,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.755594,
      NULL,
      NULL,
      1.356143,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.601203,
      2,
      1,
      1,
      2,
      0.307185,
      1.147185,
      NULL,
      NULL,
      5,
      0,
      2,
      1.891562,
      0.449367,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      2,
      8.435068,
      1.830388,
      1.333830,
      NULL,
      0,
      NULL,
      3.301200,
      0,
      2.582640,
      1,
      1,
      0.170352,
      NULL,
      8.134155,
      7,
      1,
      4.415191,
      6.658813,
      1,
      1.344230,
      5,
      8.484428,
      0,
      0.957810,
      0,
      1.088976,
      0.899770,
      3.611663,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.599133,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.300543,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.863376,
      0,
      0,
      0,
      2.517221,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.050452,
      NULL,
      NULL,
      NULL,
      0.785224,
      NULL,
      NULL,
      NULL,
      0.924296,
      NULL,
      NULL,
      NULL,
      0.243521,
      NULL,
      NULL,
      NULL,
      0.994519,
      NULL,
      NULL,
      NULL,
      3.536963,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      3.800146,
      3,
      0,
      1,
      278,
      194,
      1.286424,
      NULL,
      NULL,
      1.849713,
      NULL,
      NULL,
      1.895450,
      NULL,
      NULL,
      0.545183,
      42.444640,
      9.389518,
      1,
      4.878333,
      0.274916,
      3,
      NULL,
      NULL,
      347.043370,
      NULL,
      1,
      0.344862,
      NULL,
      0,
      0.767490,
      0.443230,
      1.010296,
      NULL,
      0,
      0.663789,
      0,
      1,
      1,
      NULL,
      1.403254,
      0,
      1,
      0.877622,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.846311,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.020849,
      0.911403,
      1,
      1.826217,
      1,
      0.598239,
      0,
      6,
      3.122259,
      0.486375,
      1.216426,
      0.381381,
      NULL,
      NULL,
      0.051765,
      0.634095,
      NULL,
      1.039501,
      3.299100,
      NULL,
      0,
      1,
      NULL,
      1.868770,
      0,
      NULL,
      1.787751,
      1,
      NULL,
      0.742108,
      0.552055,
      NULL,
      0,
      2,
      NULL,
      0,
      0.977533,
      NULL,
      0.726375,
      2,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      9.190734,
      12.670873,
      9,
      0,
      1.559581,
      1.786388,
      19.628065,
      NULL,
      2,
      0,
      NULL,
      '20241',
      NULL,
      '',
      0.985223,
      NULL,
      '',
      '',
      1.966580,
      '00233',
      '30431',
      '');
commit;
end;
/


