set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9532151';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-11-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      NULL,
      2,
      1.971067,
      1,
      1,
      NULL,
      2,
      0,
      NULL,
      NULL,
      ' 7-13-1983',
      30.779684,
      NULL,
      1.267428,
      NULL,
      2,
      ' 1- 7-1983',
      51.991199,
      1.193917,
      135,
      NULL,
      NULL,
      '10-23-1977',
      ' 6-28-1978',
      ' 5-15-1990',
      1.043026,
      3.580322,
      0,
      NULL,
      1,
      1.204639,
      1.224536,
      0,
      1.227643,
      NULL,
      0,
      17.218683,
      1,
      NULL,
      NULL,
      1.136917,
      28.870376,
      1.663962,
      1.307524,
      0.535696,
      NULL,
      NULL,
      1,
      1.108765,
      1.999120,
      0.858095,
      0,
      0.482552,
      NULL,
      1.874334,
      0.575905,
      NULL,
      1.586118,
      4,
      NULL,
      1.266758,
      1.907246,
      0.734374,
      NULL,
      NULL,
      1,
      0.875924,
      0,
      NULL,
      0,
      0.675192,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.975965,
      NULL,
      0,
      1.701588,
      2.053833,
      0.805105,
      1,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      1,
      0,
      1,
      2.537339,
      1,
      1.358432,
      1.624387,
      3.720158,
      NULL,
      1,
      3,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      5,
      0,
      1,
      NULL,
      0,
      4.763488,
      1.753078,
      NULL,
      0,
      1.506104,
      0.155043,
      NULL,
      NULL,
      1,
      1,
      0.093367,
      1.946900,
      0,
      NULL,
      1.919377,
      1,
      NULL,
      1,
      1.902638,
      1,
      1.306144,
      2,
      1,
      2.152558,
      0,
      3.658745,
      1,
      5,
      NULL,
      5.340936,
      4,
      NULL,
      5.653876,
      0,
      0.061971,
      1.650022,
      5.813634,
      8,
      NULL,
      1,
      3.637902,
      3.684038,
      ' 9- 3-1978',
      76,
      ' 4- 1-1975',
      0,
      0.553614,
      0.493045,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.043175,
      0,
      1.806016,
      NULL,
      3,
      1.942803,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.498098,
      NULL,
      NULL,
      NULL,
      NULL,
      0.289079,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.515728,
      1,
      NULL,
      0.231725,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      1.439580,
      NULL,
      1.192189,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      0,
      1.127208,
      1.574356,
      NULL,
      3,
      5,
      NULL,
      1.212376,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      0.235439,
      0,
      0.458731,
      2,
      2.930743,
      0.785761,
      1.755845,
      1.719383,
      3,
      NULL,
      NULL,
      13,
      11,
      NULL,
      1.591322,
      1.979075,
      NULL,
      0,
      1,
      1,
      1.396057,
      0,
      1.549307,
      NULL,
      1,
      1,
      0.959170,
      7.733058,
      0,
      2.808616,
      8.374242,
      6,
      3.055601,
      1.438318,
      4.822475,
      1.449294,
      NULL,
      3,
      NULL,
      2,
      0.669267,
      NULL,
      1,
      NULL,
      NULL,
      1.947263,
      52,
      NULL,
      4,
      3,
      0,
      '20224',
      NULL,
      '',
      0.197695,
      '',
      NULL,
      NULL,
      1,
      NULL,
      '',
      NULL,
      NULL,
      3,
      5.592567,
      NULL,
      1.406541,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.323294,
      NULL,
      NULL,
      0.505580,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.378875,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.400887,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.030680,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.999375,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      1.086797,
      1.713972,
      NULL,
      0.468167,
      0.921636,
      NULL,
      1.314033,
      NULL,
      NULL,
      0.092312,
      NULL,
      2.296057,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.867672,
      NULL,
      NULL,
      4.342074,
      NULL,
      2,
      1.431634,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.505596,
      2.731853,
      1,
      2.838351,
      3.111766,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.191151,
      4.611768,
      NULL,
      2,
      2,
      NULL,
      1,
      NULL,
      NULL,
      3.639772,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.844065,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.886230,
      NULL,
      2,
      3,
      NULL,
      2,
      0,
      0,
      NULL,
      5.628617,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.052204,
      1.703164,
      1.064709,
      3,
      0.839394,
      3,
      3.164573,
      1.696894,
      0,
      6,
      0.670170,
      NULL,
      0.221082,
      0,
      1.358690,
      1.842093,
      0,
      1,
      NULL,
      2.148613,
      NULL,
      3.945667,
      9,
      3,
      5,
      NULL,
      0,
      2,
      2,
      1.605867,
      4.597334,
      0.026685,
      1,
      1.587012,
      0,
      0.964612,
      0.299981,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.436498,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.896055,
      NULL,
      NULL,
      1.020419,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.126553,
      NULL,
      NULL,
      0.037597,
      0.188526,
      0.501347,
      0,
      NULL,
      3.124381,
      1.017899,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.301174,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.768006,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.558343,
      NULL,
      NULL,
      NULL,
      0.836660,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.917674,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.823647,
      NULL,
      NULL,
      NULL,
      8.734865,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      6,
      0.221151,
      0.061547,
      NULL,
      NULL,
      2.116268,
      1.287335,
      1,
      NULL,
      NULL,
      NULL,
      1.696664,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      38.707333,
      0.353922,
      0.417389,
      0.305727,
      0.845766,
      1.788870,
      0,
      0,
      0,
      0.974687,
      1,
      0,
      0,
      0.067717,
      NULL,
      NULL,
      NULL,
      1,
      0.637120,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.168554,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      1,
      NULL,
      0.972161,
      NULL,
      NULL,
      NULL,
      0.158266,
      NULL,
      1.189536,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.788333,
      0.117944,
      0.821509,
      0.181195,
      0,
      1.172270,
      1,
      2.258880,
      NULL,
      0,
      1,
      0.586721,
      0.442605,
      0,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.625204,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.721563,
      0,
      NULL,
      1,
      0,
      NULL,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.051589,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.483893,
      NULL,
      1.580318,
      NULL,
      1,
      NULL,
      1.101535,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1.270525,
      0,
      '30241',
      NULL,
      '',
      NULL,
      '',
      '',
      NULL,
      1.207403,
      '',
      NULL,
      '');
commit;
end;
/


