set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9705629';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-7-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '14',
      NULL,
      NULL,
      5,
      '4032124',
      3,
      0.026730,
      0,
      1,
      NULL,
      3.209219,
      1,
      NULL,
      NULL,
      ' 9-11-1985',
      7.837342,
      31.767562,
      NULL,
      2,
      NULL,
      '11- 7-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      2.950261,
      ' 8-24-1998',
      ' 8-15-1994',
      ' 2-26-1984',
      1,
      NULL,
      1,
      0.705700,
      0.101942,
      NULL,
      1.083635,
      1.777232,
      1,
      1,
      9.554798,
      1,
      1.910468,
      NULL,
      NULL,
      NULL,
      NULL,
      1.348157,
      0.073686,
      NULL,
      0.939601,
      4,
      0.190355,
      NULL,
      0.286090,
      NULL,
      NULL,
      0.536051,
      0.974209,
      0,
      1.998647,
      2.125699,
      NULL,
      2.060372,
      3,
      4.310009,
      1,
      0,
      7,
      1,
      0,
      4,
      1.579086,
      2,
      3,
      1,
      1,
      6,
      0,
      4,
      NULL,
      1.942578,
      0.537534,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.759087,
      NULL,
      1.766500,
      0,
      1,
      NULL,
      3.827302,
      1,
      NULL,
      2.162961,
      0,
      1,
      0.192879,
      1,
      1.780294,
      3,
      1.095591,
      NULL,
      0.029333,
      2,
      5,
      3,
      8,
      0.592228,
      2.571363,
      0.471033,
      0.408256,
      NULL,
      NULL,
      0.062247,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.656875,
      1.015768,
      5.214458,
      0,
      0,
      5,
      NULL,
      1.729043,
      0.474180,
      5,
      0.072272,
      1.431992,
      1,
      NULL,
      1.770400,
      NULL,
      1,
      0.344249,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.049828,
      0,
      0.231068,
      1.680190,
      0.216748,
      0.544055,
      NULL,
      1.547361,
      0.767305,
      4.412146,
      4.033452,
      2,
      0,
      0.776133,
      0,
      1.134554,
      2.730851,
      NULL,
      0,
      1.578806,
      0,
      NULL,
      371,
      ' 5- 2-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      9,
      1.113042,
      9,
      0,
      2.405888,
      NULL,
      0.271611,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.626058,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.862616,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.034763,
      1,
      0,
      1,
      2.181189,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.614275,
      1,
      0.267479,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.391279,
      1.570080,
      NULL,
      0,
      0,
      0,
      1,
      30,
      1.635727,
      NULL,
      NULL,
      NULL,
      NULL,
      1.783380,
      0.523869,
      0.730961,
      NULL,
      1.695309,
      0.089833,
      0,
      NULL,
      NULL,
      1,
      2.877932,
      2,
      1,
      4,
      3,
      0,
      0,
      NULL,
      1,
      1.668045,
      NULL,
      0,
      NULL,
      NULL,
      0.963563,
      1.797609,
      1.010445,
      NULL,
      1.549431,
      1.460195,
      1.731059,
      1.620823,
      7.090114,
      6.934867,
      5,
      9,
      NULL,
      0.967403,
      NULL,
      0.668421,
      NULL,
      0,
      2,
      1,
      NULL,
      NULL,
      2.530945,
      15,
      NULL,
      2,
      54,
      0.672424,
      0.423698,
      NULL,
      '34400',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      0.563959,
      16.649107,
      35,
      36,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.806642,
      2.719326,
      1.588510,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.297201,
      NULL,
      NULL,
      0.462112,
      NULL,
      NULL,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.700700,
      1,
      3,
      1.134291,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.800504,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1.193459,
      0.735708,
      1,
      1.736038,
      2,
      2,
      2,
      0.778492,
      2.666831,
      NULL,
      1,
      1.361396,
      0.412848,
      1,
      0.237450,
      1.104423,
      0.034226,
      1,
      1,
      1.204087,
      1.139374,
      NULL,
      NULL,
      3.942387,
      1.552566,
      1.133799,
      1.941182,
      NULL,
      NULL,
      NULL,
      2.714029,
      1.927820,
      1,
      5.408308,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      3,
      1,
      NULL,
      3.281109,
      2.947674,
      1.490517,
      NULL,
      NULL,
      1.301602,
      NULL,
      NULL,
      NULL,
      1,
      0.168922,
      2,
      1.273678,
      NULL,
      0,
      1,
      6.053126,
      0.609245,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.617793,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.329312,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.866872,
      NULL,
      NULL,
      0,
      3,
      2.989336,
      NULL,
      NULL,
      NULL,
      5,
      4,
      5,
      0,
      2,
      NULL,
      1.464353,
      NULL,
      NULL,
      1.423012,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.629787,
      0.576022,
      4,
      0,
      1,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.472020,
      NULL,
      NULL,
      3.929354,
      NULL,
      NULL,
      0.783755,
      NULL,
      NULL,
      0.057707,
      NULL,
      NULL,
      1.451647,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.487442,
      NULL,
      0,
      NULL,
      0,
      0.254861,
      NULL,
      NULL,
      1.931889,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.463242,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.037111,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.229277,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.922051,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.865985,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.997355,
      2.713694,
      7.968964,
      2.825620,
      2,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.831548,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.292659,
      107.728691,
      NULL,
      NULL,
      1,
      1.100357,
      NULL,
      1.205273,
      0,
      1.988225,
      0,
      NULL,
      0.262817,
      0,
      1,
      0,
      NULL,
      1,
      1,
      1.404388,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.167453,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.415037,
      3,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.855478,
      NULL,
      1,
      0,
      3,
      NULL,
      0.366117,
      NULL,
      0.904793,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.368111,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.188425,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.811391,
      NULL,
      3,
      NULL,
      0.987898,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.822050,
      NULL,
      1.545675,
      NULL,
      2.642077,
      0,
      18,
      NULL,
      1.331161,
      NULL,
      NULL,
      NULL,
      0,
      0.803301,
      1.891074,
      0.652669,
      1,
      0,
      NULL,
      1.734440,
      0.203548,
      2.577781,
      1.554185,
      1,
      1.232145,
      NULL,
      NULL,
      0.794260,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      1.036100,
      NULL,
      NULL,
      1.738859,
      NULL,
      2.135909,
      0.808940,
      NULL,
      1,
      1.418760,
      NULL,
      1.373636,
      0.812999,
      NULL,
      1,
      0.079114,
      NULL,
      0,
      1.117724,
      NULL,
      0.148931,
      NULL,
      NULL,
      NULL,
      0.506208,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.941728,
      NULL,
      1,
      NULL,
      1.818609,
      NULL,
      6.085771,
      0,
      5,
      1,
      NULL,
      NULL,
      65,
      NULL,
      4,
      2.603057,
      2,
      '40302',
      NULL,
      '',
      0,
      '',
      '',
      '',
      1.002980,
      NULL,
      '',
      '');
commit;
end;
/


