set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9705629';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-7-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      1.602251,
      2,
      1.539076,
      3.980932,
      0.797570,
      3,
      0,
      '313',
      '32434014',
      71.524765,
      20.557725,
      '3221210',
      5,
      0.069776,
      3,
      2,
      NULL,
      5,
      1,
      NULL,
      NULL,
      ' 2-13-1980',
      58.903799,
      170.957576,
      NULL,
      0.028389,
      NULL,
      ' 2-22-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-23-1982',
      3,
      1,
      2,
      NULL,
      0,
      1.192628,
      0.201637,
      3.757275,
      NULL,
      NULL,
      NULL,
      1.567986,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      2.985782,
      NULL,
      NULL,
      0,
      0.215521,
      0,
      NULL,
      NULL,
      NULL,
      1.174744,
      NULL,
      NULL,
      1,
      3.841469,
      NULL,
      1.409626,
      1.494627,
      1.770019,
      1.375586,
      0.519793,
      1,
      1,
      0.860956,
      1.754225,
      0.435152,
      0.586261,
      4.538116,
      1.658294,
      2.587653,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.704136,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.553053,
      0,
      4.951919,
      5,
      NULL,
      0,
      1.395882,
      1,
      NULL,
      0,
      3,
      1,
      0.713233,
      1.793855,
      0.689916,
      1,
      NULL,
      1.328772,
      NULL,
      0.037549,
      0,
      NULL,
      0,
      0.850396,
      3.111955,
      1,
      1.455382,
      1,
      1.798306,
      1,
      1.836615,
      1,
      4.231786,
      0.316414,
      7,
      6,
      NULL,
      0,
      0,
      0,
      1,
      1,
      0,
      1.990101,
      3.147654,
      ' 8-25-1993',
      NULL,
      ' 1- 7-1996',
      3.124077,
      1.318887,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.768168,
      NULL,
      1.043761,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.713104,
      NULL,
      NULL,
      NULL,
      NULL,
      4.170476,
      0,
      1,
      0,
      1.483459,
      NULL,
      4,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      3,
      0,
      0.481262,
      0,
      NULL,
      NULL,
      NULL,
      0.768138,
      5.818706,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.987753,
      NULL,
      1.893059,
      NULL,
      0.026701,
      1.119957,
      0,
      NULL,
      2.663913,
      1,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      4,
      NULL,
      2.524092,
      4.273803,
      3.875042,
      NULL,
      4,
      1,
      0.008846,
      4,
      3.893813,
      0.520043,
      3,
      0,
      NULL,
      0,
      0.036775,
      NULL,
      0.867313,
      1,
      1.133684,
      1.483098,
      1,
      0.570558,
      1,
      0.272340,
      1,
      0,
      NULL,
      3.562770,
      7,
      NULL,
      8.030296,
      9.548151,
      1.160242,
      2.341425,
      2.047993,
      NULL,
      3,
      1,
      NULL,
      22,
      3.719049,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      '43343',
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      NULL,
      3,
      NULL,
      3.321213,
      35,
      1,
      43,
      1.769160,
      0.995341,
      1,
      0,
      2,
      0.903256,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.550686,
      0,
      0.383184,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.298007,
      0.909151,
      0.225424,
      2.786502,
      0.799964,
      1.985258,
      0.914642,
      3,
      NULL,
      2,
      NULL,
      1.801503,
      3,
      NULL,
      1,
      0,
      2,
      8,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.798437,
      NULL,
      NULL,
      NULL,
      3,
      2.794017,
      0.315251,
      0,
      3,
      0.659793,
      0.896668,
      NULL,
      NULL,
      NULL,
      1.152828,
      NULL,
      0.420458,
      3.723749,
      1.470460,
      2.934845,
      1.494741,
      0,
      1,
      1,
      NULL,
      NULL,
      0.674356,
      0,
      0.188085,
      1,
      NULL,
      NULL,
      3.695944,
      2,
      0,
      1,
      1,
      0.900414,
      9.625608,
      1.585447,
      6,
      0,
      1.552248,
      NULL,
      NULL,
      NULL,
      1.677130,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.817170,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.407072,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1,
      4.960569,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.991246,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.686082,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.195718,
      1.051477,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      0,
      6,
      0,
      0,
      2.110783,
      2.453357,
      0,
      NULL,
      3.902468,
      1.594638,
      1,
      1.460505,
      0,
      1.386787,
      3.552383,
      3.081538,
      8.368009,
      0,
      NULL,
      NULL,
      2,
      2.510135,
      0.153129,
      1.829318,
      0.480927,
      NULL,
      0.813421,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.601310,
      NULL,
      NULL,
      2.560260,
      NULL,
      NULL,
      1.260736,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.031972,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.966380,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.065392,
      0,
      1.466421,
      0.889317,
      0.687851,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.418491,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.488464,
      NULL,
      NULL,
      NULL,
      NULL,
      1.136812,
      NULL,
      NULL,
      1.845877,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.283592,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.414947,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.780923,
      1.291232,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      4.524240,
      4.247818,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      49,
      1,
      NULL,
      NULL,
      0.651356,
      NULL,
      NULL,
      1.710453,
      NULL,
      NULL,
      0.518700,
      NULL,
      NULL,
      1.973657,
      NULL,
      NULL,
      NULL,
      NULL,
      1.494111,
      94.823926,
      NULL,
      1,
      1,
      1,
      1.286641,
      0,
      0.834880,
      1.135668,
      0,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.843273,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.195603,
      0.461320,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.540969,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.154522,
      NULL,
      0.779532,
      NULL,
      0,
      NULL,
      0,
      0.647714,
      NULL,
      NULL,
      0,
      NULL,
      1.914140,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.967825,
      NULL,
      1,
      NULL,
      0.302615,
      1.881110,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.124067,
      NULL,
      NULL,
      NULL,
      1.214648,
      NULL,
      NULL,
      NULL,
      1.706372,
      1,
      2,
      NULL,
      3,
      NULL,
      3.916202,
      NULL,
      NULL,
      NULL,
      1.961711,
      NULL,
      0.879218,
      NULL,
      0.946923,
      1.186405,
      3,
      17.567203,
      33,
      NULL,
      NULL,
      NULL,
      NULL,
      0.803172,
      NULL,
      0.321420,
      1.209138,
      0,
      0,
      0.677831,
      0.945070,
      1.193717,
      0.580777,
      NULL,
      3.524232,
      1.014584,
      NULL,
      NULL,
      0,
      2.546009,
      3,
      NULL,
      0.171191,
      2,
      0,
      1.572174,
      0,
      1.288225,
      1,
      1,
      NULL,
      2.557459,
      0.798241,
      0.985574,
      NULL,
      1,
      0.846176,
      1.622929,
      3.140731,
      0.060270,
      NULL,
      1,
      1,
      2.726837,
      0.393267,
      0.159163,
      NULL,
      NULL,
      2,
      0.727776,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.923505,
      0,
      1,
      0.050747,
      0.547200,
      4,
      2,
      1,
      0.600611,
      NULL,
      NULL,
      80.895887,
      57,
      3,
      4,
      NULL,
      '12120',
      '33141',
      '',
      0,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL);
commit;
end;
/


