set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9933915';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-6-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3.060562,
      7.138401,
      4,
      NULL,
      0,
      1,
      2.567398,
      2.635927,
      '103',
      NULL,
      14.222202,
      NULL,
      '2332201',
      1,
      0.415926,
      0,
      1,
      NULL,
      NULL,
      1.084704,
      NULL,
      NULL,
      NULL,
      238,
      35,
      NULL,
      1.284380,
      0.218330,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      ' 6-16-1979',
      ' 7-28-1986',
      ' 1-10-1982',
      3.352489,
      3,
      NULL,
      2.898092,
      NULL,
      NULL,
      NULL,
      0,
      1.745748,
      42.872822,
      5,
      19,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.933983,
      0.840533,
      NULL,
      1.854439,
      0.363910,
      NULL,
      0,
      1.473988,
      0,
      1,
      NULL,
      NULL,
      NULL,
      5.328163,
      6,
      0,
      5.435240,
      3.092092,
      3.305737,
      0.781449,
      0,
      1,
      1,
      6,
      1,
      1,
      NULL,
      0,
      NULL,
      1,
      2,
      1.433458,
      2.235829,
      3,
      0.594936,
      1.507984,
      NULL,
      NULL,
      0.966480,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.182217,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.878552,
      0.787846,
      1,
      0,
      1,
      3,
      1.633157,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1,
      7.256896,
      2.416786,
      2.809352,
      1,
      1,
      NULL,
      0.077795,
      0.396194,
      0,
      2.373263,
      0.258522,
      3.775315,
      0,
      0.895184,
      1,
      NULL,
      0,
      NULL,
      1.568679,
      0,
      0,
      1,
      2,
      1.081998,
      1,
      7.569761,
      4.255282,
      3.024928,
      NULL,
      1,
      7.270603,
      5,
      NULL,
      NULL,
      2.281456,
      8,
      3.417117,
      5.843429,
      9.164175,
      1,
      6,
      2.913461,
      1.017651,
      0.412325,
      NULL,
      NULL,
      ' 9- 5-1983',
      101,
      ' 2-19-1976',
      15,
      3,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.829025,
      0.403706,
      NULL,
      0,
      NULL,
      1,
      5.496442,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.395185,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      1,
      2,
      NULL,
      1.022813,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.206212,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.560453,
      3.934835,
      1,
      NULL,
      1.716479,
      NULL,
      0,
      0.756942,
      8,
      3.611945,
      0.429824,
      NULL,
      NULL,
      NULL,
      1.072797,
      1.009773,
      1,
      1.378250,
      NULL,
      3,
      1.689819,
      2,
      NULL,
      NULL,
      NULL,
      3.442893,
      0.939779,
      2.179441,
      2.216662,
      NULL,
      NULL,
      0.321290,
      1,
      0.747706,
      2,
      0,
      0.644009,
      0,
      1,
      1.020633,
      NULL,
      NULL,
      1.698554,
      3.525503,
      3,
      1,
      NULL,
      2.560071,
      0,
      4.732748,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      3.692504,
      NULL,
      0,
      57,
      3,
      NULL,
      31.521091,
      NULL,
      23.499716,
      39.841754,
      2.460651,
      0,
      0.828026,
      '01040',
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      2.647902,
      NULL,
      NULL,
      13.258286,
      3,
      18,
      5.586150,
      16.555323,
      NULL,
      0.907421,
      2,
      2.940223,
      1.803120,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      3,
      2.173605,
      1.165529,
      1.926577,
      NULL,
      2.439221,
      1.245507,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.621063,
      NULL,
      NULL,
      4.934677,
      6,
      1.857955,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.481803,
      NULL,
      NULL,
      NULL,
      3.926335,
      3,
      1,
      1.563473,
      2.476262,
      0.685234,
      2,
      NULL,
      0,
      1.452389,
      NULL,
      0.387690,
      0,
      NULL,
      NULL,
      1,
      0.304983,
      1,
      0,
      2.438715,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.272583,
      0,
      2,
      0.431192,
      NULL,
      NULL,
      1.005079,
      2.940468,
      0,
      3,
      7.864081,
      5.207815,
      0.442619,
      0.323290,
      NULL,
      NULL,
      NULL,
      0.590104,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      1.191648,
      0.248910,
      NULL,
      0.303917,
      3.919696,
      3.040361,
      9.697800,
      9,
      1,
      2.207459,
      2.673442,
      1,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.362953,
      NULL,
      NULL,
      0.385083,
      NULL,
      NULL,
      0.495988,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      4.972541,
      0.140971,
      4.532450,
      0,
      2,
      NULL,
      3,
      0,
      3.866135,
      1.659101,
      2,
      NULL,
      NULL,
      3,
      1,
      0,
      4,
      7.434771,
      7,
      0.798116,
      NULL,
      3.531961,
      3.313648,
      0.235917,
      1.644437,
      0,
      1.737324,
      1.643288,
      0.558865,
      3.691836,
      2.110728,
      8,
      NULL,
      9,
      0.677096,
      5,
      0.821670,
      3.935982,
      1,
      5.976830,
      NULL,
      0,
      NULL,
      1,
      0,
      0.248584,
      NULL,
      NULL,
      1.940302,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.985614,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.681025,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4.479514,
      NULL,
      NULL,
      1.642598,
      1.202543,
      0,
      0.390234,
      NULL,
      2.925440,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.297782,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2.433421,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.858622,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.204906,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.719029,
      NULL,
      NULL,
      NULL,
      0.504430,
      NULL,
      NULL,
      NULL,
      0.130360,
      NULL,
      NULL,
      NULL,
      2.310346,
      7.468469,
      NULL,
      0,
      21.230330,
      1,
      0.053739,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.784284,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.957669,
      NULL,
      NULL,
      81.926103,
      23,
      0.269758,
      3,
      1.602054,
      1.411353,
      1.938241,
      0,
      0.302904,
      2,
      1.828987,
      3,
      1.797068,
      0,
      1,
      1,
      NULL,
      NULL,
      0.734483,
      NULL,
      NULL,
      1.061386,
      NULL,
      0.420606,
      NULL,
      0,
      NULL,
      3.611055,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      13,
      0.099647,
      0.745784,
      2.498360,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.595871,
      NULL,
      0.489559,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.535595,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.711060,
      1,
      1.992014,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.846584,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      155,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.066503,
      0.914435,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.691925,
      NULL,
      2,
      NULL,
      488.756688,
      NULL,
      1,
      1.706902,
      1.615539,
      NULL,
      3,
      NULL,
      1.183847,
      NULL,
      314,
      NULL,
      2.783278,
      NULL,
      2,
      NULL,
      2.446968,
      NULL,
      0.424577,
      10.349052,
      8.887265,
      1.214284,
      NULL,
      3,
      0,
      3.842089,
      2.423036,
      3,
      5,
      NULL,
      0,
      0.665575,
      5,
      2,
      NULL,
      0.316570,
      0,
      0.227090,
      0.720124,
      NULL,
      NULL,
      2.434871,
      NULL,
      NULL,
      1.821236,
      NULL,
      0.304824,
      NULL,
      NULL,
      0.954499,
      2,
      NULL,
      0.524544,
      0.885808,
      NULL,
      0,
      0.717571,
      NULL,
      1,
      2,
      NULL,
      0.303746,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.176710,
      NULL,
      3,
      0.810901,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.728546,
      NULL,
      0,
      NULL,
      NULL,
      6.684946,
      3,
      0.951626,
      NULL,
      NULL,
      53,
      57,
      4.309732,
      3,
      4.188779,
      '03241',
      '04323',
      '',
      1,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


