set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5808669';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-2-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0.352242,
      2,
      1,
      11.853406,
      ' 2-17-1999',
      NULL,
      NULL,
      NULL,
      2.946042,
      1.234080,
      ' 7-28-1978',
      82,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      ' 9-23-2002',
      2.201607,
      0,
      2,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      1.972289,
      NULL,
      2.005367,
      NULL,
      4.173748,
      46.960491,
      NULL,
      5,
      14,
      2,
      3.655632,
      9,
      NULL,
      0,
      0,
      0.111094,
      1,
      1.917785,
      1,
      1,
      0,
      0.013505,
      108.487903,
      5,
      5.352808,
      0,
      3,
      0,
      1,
      1,
      1.493257,
      NULL,
      0.074136,
      0.400424,
      1.173257,
      0.648714,
      0,
      1.495027,
      0.821420,
      1.366584,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.302636,
      0.356245,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.577587,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.810144,
      1,
      0.540439,
      1.533671,
      0.893537,
      0,
      4,
      1.213777,
      1.752166,
      5,
      NULL,
      NULL,
      1,
      3.096407,
      0.943946,
      1.523926,
      1.798109,
      NULL,
      1.588530,
      NULL,
      NULL,
      0,
      0.904646,
      0,
      0.742455,
      NULL,
      NULL,
      4,
      5.603665,
      4,
      2,
      0,
      1.034758,
      0,
      NULL,
      NULL,
      3.718095,
      4,
      3.234479,
      2.803860,
      NULL,
      1.537928,
      3,
      7.511000,
      4.460446,
      0,
      2.341051,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.848830,
      0.377992,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.704730,
      NULL,
      1,
      1.417646,
      0.763381,
      1,
      0.307803,
      1.428605,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.230880,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.417126,
      NULL,
      1.836007,
      1.412276,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      3.573073,
      2.998627,
      0,
      NULL,
      NULL,
      2.057482,
      0.207886,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.011575,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.785699,
      73.668521,
      NULL,
      NULL,
      NULL,
      1.484218,
      1.458722,
      NULL,
      '11332',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      0.157227,
      1.811143,
      500,
      1,
      0,
      58.275967,
      7.806491,
      55.657909,
      5.362067,
      1.325325,
      NULL,
      1.589917,
      NULL,
      0.138939,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.276380,
      1.300201,
      1,
      0,
      0.527653,
      NULL,
      NULL,
      3.501271,
      0.231831,
      1.430695,
      0.019617,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.357711,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.830303,
      0.878395,
      0,
      3.500504,
      0.677583,
      1,
      0.004827,
      0,
      NULL,
      NULL,
      NULL,
      0.174764,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.980372,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.081145,
      1.873298,
      1.229259,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.596922,
      1,
      2,
      3.041269,
      1,
      1.893574,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.063587,
      NULL,
      NULL,
      NULL,
      0.190203,
      NULL,
      3.968781,
      1,
      1,
      9.653283,
      1.366015,
      NULL,
      0.676534,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.531688,
      1.785016,
      NULL,
      3.425750,
      3,
      0,
      3,
      0,
      1,
      NULL,
      1,
      3,
      1,
      14.435450,
      0.232872,
      3.798653,
      14.961704,
      0.158067,
      2.466446,
      NULL,
      1,
      1.989293,
      6,
      0,
      8.661679,
      1.992939,
      1.881581,
      4,
      2.100556,
      1,
      3.051944,
      3,
      4.423135,
      1,
      2,
      3,
      0.481315,
      0.940746,
      0,
      6,
      NULL,
      NULL,
      52,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.081374,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.681553,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      13.462426,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      2,
      NULL,
      0.669997,
      0.941608,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.169234,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      9.311356,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.810907,
      NULL,
      NULL,
      NULL,
      1.153133,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.835279,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.289641,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.986167,
      NULL,
      NULL,
      NULL,
      0.509732,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5.251786,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.610877,
      NULL,
      NULL,
      0,
      240.010225,
      21.162090,
      NULL,
      NULL,
      NULL,
      0.267524,
      NULL,
      NULL,
      1.105188,
      NULL,
      NULL,
      1,
      155.631145,
      107,
      1,
      10.023295,
      0,
      3.746650,
      7.731981,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      0.025117,
      1,
      0.107359,
      0,
      1,
      1.017576,
      NULL,
      0,
      0.340279,
      1,
      0,
      0,
      0,
      0.894540,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.178206,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      5.381095,
      1,
      2.190042,
      1.294891,
      2,
      8.808582,
      3.328576,
      1,
      3,
      NULL,
      9.994701,
      1.688669,
      NULL,
      NULL,
      1,
      NULL,
      5,
      0,
      NULL,
      NULL,
      1,
      0,
      0.331311,
      0,
      1,
      NULL,
      NULL,
      0.521240,
      0,
      1.374484,
      12,
      8,
      1.003668,
      0,
      1,
      1.663770,
      1,
      1,
      1,
      0.501735,
      15,
      1.123160,
      2.874917,
      1.098179,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.522695,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.575529,
      0,
      0.556277,
      0,
      5,
      10,
      10.149902,
      1,
      0.657257,
      NULL,
      8,
      76,
      7.327711,
      NULL,
      1.647918,
      '33030',
      '',
      '',
      0,
      '',
      '',
      NULL,
      1,
      '',
      '',
      '');
commit;
end;
/


