set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7001218';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-4-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      NULL,
      '0104143',
      1.162096,
      NULL,
      1,
      3,
      NULL,
      NULL,
      0.513641,
      NULL,
      NULL,
      ' 2-26-1991',
      66.475007,
      NULL,
      3.077711,
      3,
      1.760733,
      ' 8- 9-1989',
      87,
      NULL,
      123.070617,
      NULL,
      1,
      '11-11-1995',
      '10-28-1977',
      NULL,
      0.458140,
      0,
      1,
      1.814258,
      1,
      1.971806,
      3,
      NULL,
      1,
      NULL,
      7.116630,
      7,
      0.268821,
      121,
      60,
      6,
      7,
      5.320480,
      0,
      NULL,
      NULL,
      1.382976,
      1,
      1.494069,
      0,
      1,
      NULL,
      0.357982,
      NULL,
      1,
      1.075754,
      2,
      1.618535,
      11.073949,
      NULL,
      2.880489,
      0,
      NULL,
      5.743989,
      1,
      0,
      3.953217,
      0,
      0.565209,
      0,
      0,
      0,
      8.385809,
      NULL,
      5,
      3.370351,
      0.371393,
      0.151563,
      NULL,
      NULL,
      1.922147,
      NULL,
      NULL,
      0.661547,
      1,
      1.491442,
      1.222727,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.886951,
      1.837943,
      2.038737,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.790534,
      3.231259,
      NULL,
      0.303686,
      8.800778,
      NULL,
      5,
      0,
      NULL,
      NULL,
      1.326748,
      NULL,
      0.126181,
      2,
      NULL,
      NULL,
      0.137836,
      0,
      NULL,
      1.195371,
      4.784530,
      8.167506,
      0.038814,
      NULL,
      1.278224,
      5,
      9,
      4,
      4.635673,
      3.151841,
      5,
      NULL,
      8,
      2.189643,
      NULL,
      1.809133,
      11,
      1.107556,
      4,
      7.275619,
      NULL,
      3,
      NULL,
      5,
      2.901518,
      NULL,
      3,
      ' 0-10-1991',
      727,
      ' 7- 2-1993',
      1532,
      NULL,
      0,
      1.318434,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.618126,
      NULL,
      0,
      0,
      1.125084,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.092996,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.539618,
      NULL,
      NULL,
      NULL,
      0.377478,
      1.800678,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      NULL,
      0.501281,
      NULL,
      1.144888,
      1.519652,
      360,
      1.117698,
      1.615318,
      7.719293,
      1972,
      270,
      NULL,
      NULL,
      NULL,
      3.844018,
      3,
      3,
      3,
      0.766675,
      2.145229,
      NULL,
      0,
      1,
      0.111770,
      0.006467,
      NULL,
      0,
      NULL,
      0,
      1,
      2,
      1.781057,
      1,
      1,
      NULL,
      1,
      1.847890,
      1.620554,
      0.146089,
      0,
      1.879722,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      51.302122,
      5,
      20,
      3,
      0.942771,
      0,
      '32422',
      '',
      '',
      0.302731,
      NULL,
      '',
      '',
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      41.041843,
      3.621129,
      38,
      13,
      936.564545,
      0.950933,
      1,
      3,
      3,
      0,
      NULL,
      NULL,
      0.044615,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      1.345303,
      0.092598,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.342848,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6.308067,
      2,
      9,
      NULL,
      0.480094,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.297343,
      NULL,
      NULL,
      2,
      1.365718,
      2,
      NULL,
      0,
      NULL,
      NULL,
      0.026535,
      0,
      2.233864,
      0.668723,
      2,
      0,
      0.742334,
      1,
      0.174133,
      0,
      0,
      0.120196,
      1,
      1.412461,
      0.891928,
      1,
      NULL,
      NULL,
      0.079638,
      NULL,
      NULL,
      0.249104,
      1.914825,
      0.406458,
      8.566756,
      3,
      2,
      0.281363,
      1.240822,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.462890,
      NULL,
      NULL,
      1.214533,
      0,
      1.285170,
      1.615519,
      NULL,
      2.477071,
      0.946032,
      NULL,
      NULL,
      2,
      5,
      0,
      1,
      2.159484,
      3,
      1.802077,
      NULL,
      NULL,
      2,
      5.953870,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.890030,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.003754,
      0,
      NULL,
      7,
      0.705490,
      4.005806,
      2,
      1,
      0.963702,
      1,
      0.551018,
      1,
      6.011142,
      1.590902,
      4,
      4,
      0.296440,
      1,
      NULL,
      NULL,
      NULL,
      0.126764,
      1,
      NULL,
      2,
      1,
      3,
      0,
      3.926997,
      2,
      NULL,
      0.880971,
      8,
      2,
      0.458953,
      2,
      3.487397,
      2.315548,
      1,
      NULL,
      0,
      NULL,
      3.113070,
      1.512803,
      2.203591,
      1,
      NULL,
      5,
      6,
      6,
      4.414230,
      2,
      0,
      3.758355,
      NULL,
      1,
      NULL,
      1.827651,
      0.758509,
      0.958222,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.881298,
      NULL,
      NULL,
      1.967457,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.852873,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.142022,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      1,
      2,
      0.845828,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.034761,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.289609,
      NULL,
      NULL,
      NULL,
      1.842393,
      NULL,
      NULL,
      NULL,
      2.876140,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.610707,
      NULL,
      NULL,
      NULL,
      1.866808,
      NULL,
      NULL,
      NULL,
      2.316048,
      1283.034872,
      NULL,
      NULL,
      NULL,
      NULL,
      0.931683,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.067419,
      NULL,
      NULL,
      1.614733,
      NULL,
      NULL,
      0.753141,
      NULL,
      0,
      13662,
      NULL,
      0,
      1.354917,
      1,
      NULL,
      0,
      0.173829,
      0.501397,
      1,
      0.571473,
      0,
      1,
      0.726009,
      1.735803,
      3,
      0.493292,
      NULL,
      0,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      371,
      NULL,
      0.186053,
      35,
      5.487816,
      1.719945,
      1,
      NULL,
      NULL,
      1.721251,
      NULL,
      1.644710,
      NULL,
      NULL,
      NULL,
      0.547708,
      NULL,
      1.430225,
      NULL,
      2.889667,
      NULL,
      1.120781,
      NULL,
      1,
      NULL,
      2.569657,
      NULL,
      0,
      NULL,
      1.436314,
      NULL,
      0.604671,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.067336,
      0,
      1.101525,
      0,
      NULL,
      0,
      3.016948,
      NULL,
      0,
      0.189323,
      NULL,
      0,
      1,
      NULL,
      0,
      1.906517,
      NULL,
      0.708976,
      0.435870,
      NULL,
      0.744957,
      0.602640,
      NULL,
      1.337450,
      NULL,
      NULL,
      1.249355,
      0,
      NULL,
      0.878161,
      0.998532,
      NULL,
      1,
      1.109083,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.652251,
      NULL,
      1,
      NULL,
      0,
      NULL,
      2.684580,
      NULL,
      6.934354,
      0,
      0.914340,
      1.224998,
      NULL,
      54.454144,
      0,
      0.635920,
      3,
      '13244',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


