set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7100746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-8-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '4',
      NULL,
      NULL,
      '0424202',
      2.602987,
      1.243155,
      1,
      2,
      '1333',
      0.135897,
      1,
      NULL,
      NULL,
      ' 0-16-1974',
      0,
      NULL,
      5,
      0.235941,
      0.044677,
      ' 9-26-1996',
      5.996693,
      4.478332,
      1505,
      1721.620956,
      1.054430,
      NULL,
      ' 6-28-1977',
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      1.576565,
      NULL,
      0.387499,
      1,
      284,
      4,
      NULL,
      1.591261,
      192,
      NULL,
      6,
      18,
      NULL,
      NULL,
      6,
      1,
      0,
      1.955568,
      NULL,
      1.620878,
      1,
      0,
      1.851868,
      0.804436,
      0.541446,
      161.721529,
      NULL,
      8,
      7.893448,
      2,
      5,
      1,
      1,
      0,
      NULL,
      0,
      1.368277,
      1,
      5.277671,
      0,
      0.389282,
      0.245379,
      NULL,
      1.123861,
      NULL,
      3.524223,
      0.134228,
      1.038477,
      NULL,
      NULL,
      1.262461,
      NULL,
      NULL,
      0.718262,
      1.683051,
      2.317780,
      3.415583,
      1.798697,
      0,
      NULL,
      0,
      1.806033,
      1,
      0,
      1,
      1,
      1,
      0,
      0.299871,
      1.470656,
      1.879714,
      1.325854,
      0,
      0.859816,
      0,
      0.350555,
      0.880598,
      5.711532,
      NULL,
      1,
      NULL,
      NULL,
      0.446960,
      NULL,
      NULL,
      NULL,
      0,
      0.666712,
      NULL,
      4.013142,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      1.965095,
      3,
      0,
      1,
      0,
      1.899467,
      NULL,
      NULL,
      1,
      4.298617,
      4.615530,
      1,
      0.907285,
      0.991735,
      NULL,
      1,
      2.218591,
      0,
      0,
      1.865080,
      2,
      NULL,
      1.131009,
      7,
      3,
      5,
      2.522301,
      5.112254,
      1,
      NULL,
      11,
      5,
      NULL,
      NULL,
      NULL,
      0.256414,
      NULL,
      871,
      ' 4- 4-2000',
      531,
      NULL,
      0,
      1.458031,
      NULL,
      0.497882,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.038629,
      0,
      1.400563,
      1,
      1,
      1,
      0.485650,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.454319,
      5.372993,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5.599995,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.674112,
      1.484089,
      NULL,
      1,
      NULL,
      0.926302,
      NULL,
      2,
      4980,
      NULL,
      0.821738,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      51.361635,
      26.102765,
      48,
      NULL,
      0,
      2.836297,
      '31300',
      NULL,
      '',
      0.056536,
      NULL,
      '',
      '',
      2.895655,
      NULL,
      '',
      '',
      0.262649,
      37,
      140.387700,
      21.577783,
      0,
      42,
      15,
      145,
      1,
      1.530358,
      2,
      NULL,
      1.299132,
      NULL,
      NULL,
      1.316161,
      NULL,
      NULL,
      0.373662,
      NULL,
      NULL,
      0.508452,
      NULL,
      NULL,
      0.514391,
      NULL,
      NULL,
      0.345860,
      NULL,
      1.019779,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.399181,
      0.514767,
      NULL,
      0.252270,
      1,
      NULL,
      0.329048,
      NULL,
      NULL,
      8.158343,
      1,
      0.006490,
      1,
      1.848911,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      2.525544,
      1,
      6.559721,
      NULL,
      NULL,
      12,
      NULL,
      NULL,
      0.516995,
      NULL,
      0.037095,
      1,
      0,
      1.161140,
      1,
      NULL,
      1,
      0.805020,
      0.087227,
      NULL,
      0,
      1,
      0.658858,
      0.523834,
      0.509283,
      NULL,
      NULL,
      0.193983,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      4,
      3,
      0.337563,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.208693,
      1.291178,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.083225,
      0.900765,
      NULL,
      1.170057,
      NULL,
      NULL,
      5.313348,
      NULL,
      NULL,
      0.167478,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.034234,
      0,
      1.762472,
      NULL,
      0,
      0,
      8,
      1,
      4,
      3.523780,
      NULL,
      1.091577,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      0.853715,
      NULL,
      NULL,
      1.531907,
      NULL,
      NULL,
      0,
      3.026671,
      NULL,
      1.181499,
      NULL,
      3.843024,
      0,
      1,
      1,
      0.850640,
      NULL,
      0.862530,
      NULL,
      6.246270,
      0,
      2,
      NULL,
      NULL,
      3,
      1,
      4,
      1.373477,
      1,
      0,
      0.224207,
      0.183510,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.594466,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.698042,
      0.520408,
      1,
      NULL,
      1,
      0.254754,
      1.517146,
      NULL,
      NULL,
      1.579618,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.490602,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.093181,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      6.921448,
      7.277061,
      0,
      259.486818,
      56.683367,
      3.303012,
      1740,
      107.197724,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.454362,
      660,
      294,
      1.470723,
      NULL,
      NULL,
      3,
      1058.803950,
      1.629807,
      18890,
      11.172094,
      1,
      NULL,
      1.062448,
      0,
      1,
      1,
      0.547220,
      0.763465,
      NULL,
      0.734968,
      0.175035,
      NULL,
      1,
      0.213023,
      0.159327,
      0.366722,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.378527,
      0.211013,
      5.822434,
      0,
      0,
      1.902297,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      7.486777,
      NULL,
      14,
      7,
      NULL,
      16,
      18,
      NULL,
      14,
      0,
      NULL,
      2.582464,
      6.767814,
      NULL,
      2.666121,
      NULL,
      NULL,
      NULL,
      19,
      NULL,
      NULL,
      10.976413,
      NULL,
      11,
      13.579377,
      NULL,
      6,
      19.249865,
      NULL,
      5.204803,
      2.194382,
      NULL,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.957128,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.128366,
      NULL,
      1,
      NULL,
      8,
      4,
      11.757186,
      NULL,
      1,
      2.421443,
      24.529137,
      33.963049,
      0,
      1,
      3,
      '12424',
      '',
      '',
      1,
      '',
      NULL,
      '',
      1.944767,
      '3122',
      '',
      '');
commit;
end;
/


