set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7100746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-1-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '14',
      '03',
      7.396293,
      23.442270,
      '3433120',
      4.016778,
      NULL,
      NULL,
      NULL,
      '0014',
      2,
      NULL,
      NULL,
      NULL,
      '10- 8-1974',
      137,
      NULL,
      NULL,
      0,
      0.799155,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      ' 9-15-1998',
      ' 6-22-2002',
      '10- 2-1980',
      0,
      0,
      1.349524,
      NULL,
      NULL,
      1.683320,
      2.332816,
      0,
      1.938517,
      929.527182,
      0,
      18,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.161176,
      1.538627,
      1,
      0.747783,
      0.970719,
      1.289895,
      NULL,
      15,
      6.356538,
      6.768162,
      0.399436,
      3,
      1.882661,
      0.743640,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.859279,
      NULL,
      0,
      0.804381,
      4,
      NULL,
      1.985172,
      3.285237,
      3,
      0,
      NULL,
      NULL,
      0.077545,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0.245472,
      NULL,
      2,
      0,
      0,
      NULL,
      NULL,
      1.167785,
      1.793894,
      0.815188,
      0,
      0,
      2,
      0,
      3.302787,
      2.033101,
      1.680864,
      0.665570,
      8.116023,
      1.499623,
      0.301994,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.094606,
      0,
      0,
      0,
      1,
      NULL,
      0.575869,
      NULL,
      NULL,
      1,
      NULL,
      0.566817,
      0.590815,
      0.895218,
      0,
      0.882577,
      NULL,
      1,
      0.341508,
      NULL,
      NULL,
      NULL,
      0.500744,
      NULL,
      1,
      NULL,
      1.036971,
      NULL,
      0.742460,
      NULL,
      NULL,
      5,
      0,
      0.996703,
      1.629725,
      7.516543,
      0,
      1,
      4,
      2.229190,
      5,
      0.031396,
      4.889820,
      6.919505,
      1,
      7,
      3.625165,
      0,
      NULL,
      NULL,
      ' 6-13-1975',
      2368.304970,
      2,
      0.508087,
      1.281133,
      2.466400,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.634967,
      1,
      NULL,
      1.018104,
      1.314263,
      0,
      1,
      1.300653,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.380521,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      1.044072,
      1.230307,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.230723,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.919412,
      1,
      NULL,
      NULL,
      1,
      0.497357,
      0.426423,
      2,
      6,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.063918,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.343450,
      NULL,
      NULL,
      1.451158,
      1.680649,
      NULL,
      NULL,
      3.599347,
      0.784556,
      1.469672,
      1.365940,
      0.309939,
      1,
      1.075452,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.947605,
      0,
      0.007260,
      1.550871,
      3.607049,
      0.398929,
      11,
      9.778721,
      6.736028,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1.229534,
      2.914626,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      62,
      2,
      3.863298,
      1.019361,
      '10322',
      '',
      '',
      1.130391,
      '',
      '',
      '',
      4.883997,
      NULL,
      '24400',
      NULL,
      0.529477,
      22,
      486,
      38.966063,
      2,
      36,
      NULL,
      NULL,
      0.844340,
      NULL,
      2.604828,
      3,
      1.019086,
      NULL,
      NULL,
      0.522964,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.468770,
      NULL,
      NULL,
      3,
      1.393950,
      0.535808,
      NULL,
      NULL,
      NULL,
      0.569061,
      NULL,
      NULL,
      2,
      0.927782,
      2,
      1.079209,
      1,
      1.673771,
      3.040918,
      NULL,
      NULL,
      0.148757,
      NULL,
      NULL,
      6.325962,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.657531,
      0.545716,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.252200,
      3,
      NULL,
      3.318432,
      0.193277,
      NULL,
      NULL,
      1.053447,
      1.093532,
      1,
      1,
      2,
      0.251359,
      2.097653,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.335233,
      NULL,
      NULL,
      11,
      2,
      6,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.420804,
      0.375914,
      0.277588,
      NULL,
      3,
      0.088337,
      2,
      2,
      1.470606,
      1.589039,
      NULL,
      NULL,
      6.378268,
      9,
      1.751844,
      1.096290,
      2,
      2.587327,
      0.592672,
      NULL,
      NULL,
      3,
      0,
      3.760757,
      1.834824,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.027173,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      3,
      3,
      NULL,
      1,
      9.776830,
      8.616005,
      7,
      1.713592,
      5,
      3.550522,
      NULL,
      NULL,
      2,
      NULL,
      0.190156,
      2.347932,
      0.232602,
      0.449484,
      0.345814,
      NULL,
      NULL,
      2,
      4,
      5,
      2.486404,
      3.798846,
      NULL,
      3.748617,
      2,
      1.132589,
      NULL,
      3,
      0.914108,
      0.442549,
      3,
      3.132757,
      8.219086,
      6.893989,
      5,
      4,
      NULL,
      2,
      3,
      2.841275,
      1.360865,
      0.014611,
      0.098719,
      NULL,
      0.318303,
      0,
      1,
      NULL,
      NULL,
      1.448802,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.928653,
      NULL,
      NULL,
      1.439925,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.987035,
      NULL,
      NULL,
      1.321689,
      NULL,
      NULL,
      0.982478,
      0,
      NULL,
      1.130102,
      NULL,
      1.714551,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.709423,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.764042,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.911765,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.675464,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.402534,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.256181,
      NULL,
      245.022118,
      NULL,
      1,
      NULL,
      NULL,
      0.123459,
      NULL,
      NULL,
      0.998909,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      34.342025,
      0.360062,
      NULL,
      1.174989,
      0.781995,
      0.271252,
      0.273995,
      NULL,
      1,
      1,
      1,
      0,
      1.941211,
      1.046412,
      NULL,
      0,
      1.799031,
      1.971676,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.860730,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.130856,
      0.621910,
      3.978115,
      0.207853,
      1,
      3,
      NULL,
      2,
      NULL,
      3.211763,
      3.160714,
      1.122356,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.527711,
      0.900578,
      NULL,
      0,
      1,
      NULL,
      0,
      1.369203,
      NULL,
      0,
      NULL,
      NULL,
      1.282236,
      NULL,
      NULL,
      0,
      1.418915,
      NULL,
      0,
      0.140835,
      NULL,
      0.635914,
      0.521008,
      NULL,
      2,
      0.085568,
      1.641751,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.050777,
      4.293466,
      6.071879,
      1,
      1,
      3,
      56,
      42,
      3.870886,
      0.646229,
      2,
      '11040',
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      '34213',
      '42101',
      '');
commit;
end;
/


