set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8002651';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1987-9-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '0',
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      0,
      '4423',
      NULL,
      NULL,
      NULL,
      15.221586,
      NULL,
      31.180805,
      NULL,
      1.034943,
      0.791495,
      NULL,
      ' 1-15-1981',
      18,
      1,
      179.383929,
      103,
      1,
      NULL,
      ' 3- 0-1992',
      ' 7-29-2001',
      3,
      NULL,
      2,
      1,
      1.764224,
      0,
      3.375539,
      0.665361,
      NULL,
      81,
      10.456992,
      11.926858,
      NULL,
      12,
      5.420178,
      3.590017,
      10.949380,
      3.609475,
      9,
      0,
      0,
      NULL,
      0.767291,
      1.296604,
      1,
      1.062302,
      1.800667,
      0,
      NULL,
      1.416988,
      1,
      2,
      NULL,
      6.796011,
      0.279520,
      0,
      0.780206,
      0,
      1,
      1.272707,
      0,
      1,
      1.905517,
      3,
      3,
      1,
      NULL,
      6.802954,
      NULL,
      0.986437,
      0,
      0.043877,
      0.310019,
      NULL,
      NULL,
      1.329897,
      NULL,
      NULL,
      1.815200,
      1.008737,
      0,
      0.234663,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.407796,
      0.040061,
      0.168369,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      0,
      NULL,
      NULL,
      7.153145,
      1,
      1,
      0.186069,
      NULL,
      1.964751,
      1.838621,
      4,
      1.050858,
      NULL,
      1.595699,
      0.068582,
      NULL,
      NULL,
      1.209657,
      0.351951,
      0,
      0.418665,
      1,
      0,
      1.541115,
      NULL,
      1.206021,
      1,
      1,
      1.933627,
      1.017866,
      0,
      NULL,
      5,
      2,
      1,
      8,
      3,
      0,
      9.920819,
      7,
      4.662276,
      NULL,
      1,
      3.755728,
      0,
      NULL,
      381,
      NULL,
      359.057485,
      0.972619,
      0,
      1,
      4,
      1.248488,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.366764,
      2.135711,
      NULL,
      0.006124,
      0,
      2.080197,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.360140,
      1.241542,
      NULL,
      0.056057,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.454277,
      1,
      0.148144,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.368117,
      0,
      0.297135,
      1.139785,
      0.366911,
      0,
      0.123047,
      0.326929,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.986552,
      NULL,
      NULL,
      2.790158,
      NULL,
      1.283094,
      3.303808,
      0,
      0.159021,
      NULL,
      1,
      0.516478,
      2.228779,
      13,
      16,
      NULL,
      1,
      1,
      2,
      0,
      0.895065,
      1.817693,
      0,
      1.680440,
      NULL,
      0,
      NULL,
      1,
      0,
      3.342603,
      1.851691,
      3.460887,
      11.947820,
      0,
      7,
      5,
      1,
      0.573811,
      3,
      5,
      1,
      NULL,
      NULL,
      49.525601,
      3.000920,
      3,
      NULL,
      35,
      50.093884,
      57,
      1.396053,
      1,
      1.963401,
      '40133',
      '',
      NULL,
      0.077558,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      1.936106,
      36.349519,
      217.764429,
      NULL,
      1.930866,
      NULL,
      2.486153,
      2.987429,
      5.295083,
      3,
      NULL,
      0.933066,
      1.261813,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.813293,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      16.779778,
      13,
      NULL,
      NULL,
      NULL,
      2.116955,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.155222,
      NULL,
      NULL,
      0.551002,
      NULL,
      NULL,
      2,
      3,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.936103,
      NULL,
      NULL,
      NULL,
      1.469096,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.519407,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.404051,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      1.454866,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.091170,
      NULL,
      NULL,
      0,
      2,
      3.452044,
      1.273972,
      3.174908,
      1.235385,
      0.919935,
      NULL,
      NULL,
      4.774190,
      NULL,
      0,
      2.828132,
      0,
      0,
      2,
      NULL,
      1,
      2.196267,
      6.172999,
      7,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.840454,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0.314483,
      0.515409,
      NULL,
      7.580156,
      6,
      5,
      1.761722,
      NULL,
      NULL,
      NULL,
      0,
      1.899184,
      3.342107,
      2.660433,
      0,
      1.395817,
      3,
      0,
      3.188209,
      2.333295,
      0,
      NULL,
      NULL,
      1.171659,
      2,
      0.288747,
      NULL,
      1.873497,
      1.500902,
      3,
      0,
      NULL,
      0,
      NULL,
      0,
      2,
      NULL,
      4,
      1,
      4.159620,
      4.475606,
      NULL,
      0.832892,
      0,
      NULL,
      1,
      0.491102,
      0.562863,
      1,
      0,
      3.738951,
      NULL,
      NULL,
      0.752507,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.683810,
      NULL,
      NULL,
      0.662851,
      NULL,
      NULL,
      1.849981,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.943274,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.223836,
      NULL,
      NULL,
      1.841800,
      NULL,
      NULL,
      1.621316,
      NULL,
      NULL,
      1.025977,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.471240,
      3.035642,
      2,
      0.998121,
      1,
      2,
      0.981490,
      NULL,
      NULL,
      4.080373,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.473717,
      3.459020,
      NULL,
      NULL,
      1.126610,
      1.971066,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      1.731275,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.968834,
      NULL,
      NULL,
      3.274976,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      3.639743,
      NULL,
      NULL,
      1.471413,
      3,
      NULL,
      NULL,
      0.270250,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.497320,
      3.180657,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      0.729870,
      2,
      NULL,
      NULL,
      0,
      1.084274,
      NULL,
      NULL,
      8.052013,
      NULL,
      NULL,
      NULL,
      150,
      1.434031,
      NULL,
      NULL,
      NULL,
      2.197793,
      23.507788,
      2,
      0.486355,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.803130,
      NULL,
      NULL,
      3,
      1.291552,
      5,
      0.066408,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      0.947141,
      0.817942,
      1.580223,
      1.575402,
      1,
      1,
      0.009891,
      0,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.948313,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4.498372,
      0,
      0,
      5,
      NULL,
      3,
      NULL,
      NULL,
      2.638603,
      2,
      0,
      1.839282,
      0.833765,
      NULL,
      3,
      1,
      NULL,
      1.037979,
      2,
      NULL,
      1.237220,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.995324,
      NULL,
      0,
      2,
      NULL,
      3,
      2.438025,
      NULL,
      0,
      1.153468,
      NULL,
      1.039196,
      0,
      NULL,
      2,
      3,
      NULL,
      2,
      1.065207,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.562348,
      0.186178,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      2.156635,
      NULL,
      1,
      NULL,
      0.933066,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.660017,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      5.759335,
      NULL,
      NULL,
      NULL,
      1,
      0,
      31.447325,
      73.211812,
      3.339560,
      1,
      3,
      '30224',
      NULL,
      NULL,
      0.070808,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '');
commit;
end;
/


