set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '3372312';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-5-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2.093895,
      NULL,
      1,
      NULL,
      2,
      2,
      NULL,
      3.862725,
      '014',
      '21124434',
      26.362086,
      3,
      '2112402',
      2,
      1,
      3,
      0,
      '0444',
      6.179566,
      0,
      NULL,
      NULL,
      ' 7- 4-1987',
      24,
      27.499177,
      NULL,
      0,
      NULL,
      ' 4-24-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-27-1987',
      NULL,
      1.229982,
      1,
      0,
      0.720697,
      3.544510,
      3,
      2.966163,
      NULL,
      NULL,
      NULL,
      6.465380,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.780324,
      2.341287,
      NULL,
      1,
      0,
      NULL,
      1.463446,
      0,
      NULL,
      1.437489,
      NULL,
      1.883729,
      1,
      0.733066,
      1.920387,
      5.470747,
      5.964200,
      3.602269,
      NULL,
      0.504255,
      2.452307,
      1,
      1,
      NULL,
      3.722192,
      0.411996,
      1.563796,
      5.379299,
      1,
      NULL,
      1.540802,
      1.356454,
      1.159225,
      3.986768,
      1,
      NULL,
      NULL,
      NULL,
      1.171598,
      1.697855,
      1.638424,
      1,
      NULL,
      1.005896,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.412152,
      0,
      1.386383,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.521785,
      4.661370,
      1,
      6.383829,
      5.286548,
      NULL,
      0.921198,
      1.005943,
      0,
      NULL,
      0.226414,
      1.271122,
      1.525376,
      0.779844,
      0,
      1,
      0,
      1,
      0,
      NULL,
      0,
      0,
      4,
      0.429920,
      NULL,
      1,
      1,
      5.681250,
      3.911193,
      0.726829,
      NULL,
      1.063703,
      0.824842,
      1,
      1.722550,
      5.452484,
      NULL,
      NULL,
      5,
      2,
      3.566377,
      NULL,
      2,
      1.706777,
      1.090701,
      1.628784,
      NULL,
      1,
      ' 9- 1-1979',
      112,
      ' 3-18-1980',
      54.832575,
      0,
      NULL,
      0.155897,
      NULL,
      1.707911,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.469361,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.911010,
      NULL,
      0.824060,
      NULL,
      1.758766,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.177074,
      1,
      3.115663,
      3.950282,
      0,
      0,
      3,
      0.330670,
      4.137184,
      3.141371,
      4,
      7,
      4,
      1,
      NULL,
      NULL,
      0,
      11.458646,
      NULL,
      0,
      0.513452,
      NULL,
      NULL,
      ' 5-15-1974',
      NULL,
      ' 6- 3-1988',
      15,
      2,
      1.647093,
      0.707539,
      0,
      3.755369,
      NULL,
      0.502003,
      NULL,
      1,
      1.189106,
      0,
      NULL,
      NULL,
      1.081985,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      1.107171,
      1.783872,
      NULL,
      0.885117,
      0,
      3,
      NULL,
      0,
      2,
      1.622781,
      2.582068,
      0.884392,
      1,
      0.348136,
      0,
      0,
      0.725173,
      1.154598,
      NULL,
      0,
      1,
      0,
      0,
      0,
      1.144455,
      0.780182,
      3,
      1,
      0,
      9,
      7.931660,
      9.186266,
      7,
      7,
      5.144253,
      NULL,
      7,
      0,
      3,
      2.147509,
      NULL,
      3,
      NULL,
      77.033639,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      '31340',
      '0143',
      NULL,
      2,
      '01033',
      NULL,
      NULL,
      1,
      NULL,
      '',
      '',
      1,
      14.242225,
      105.606886,
      3.647760,
      0.740957,
      NULL,
      NULL,
      NULL,
      NULL,
      2.915731,
      NULL,
      1.381223,
      1.256013,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.926067,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.962302,
      3.540007,
      1,
      1.207291,
      NULL,
      NULL,
      1.517831,
      NULL,
      NULL,
      1.275449,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.823664,
      NULL,
      NULL,
      0.318785,
      3,
      2.909820,
      NULL,
      1.526986,
      NULL,
      NULL,
      NULL,
      2,
      2,
      1.119914,
      3,
      1.057318,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.218304,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.656954,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.147361,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.454033,
      NULL,
      3.984898,
      1,
      NULL,
      NULL,
      1.764235,
      3.743723,
      NULL,
      3.350767,
      7.544449,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.612184,
      NULL,
      NULL,
      1.808717,
      NULL,
      NULL,
      0.278108,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.143221,
      NULL,
      NULL,
      1.615535,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.093419,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.311665,
      NULL,
      3,
      1.940411,
      NULL,
      NULL,
      1.292570,
      3,
      0.103665,
      1.810552,
      4.046716,
      0,
      2,
      3,
      3.915654,
      3.801850,
      1,
      2.295507,
      0,
      2.764435,
      3,
      2.819759,
      1,
      1,
      5,
      7.901632,
      7,
      1,
      NULL,
      NULL,
      0.980056,
      1.666948,
      1.620812,
      1.245927,
      NULL,
      1,
      1.239886,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      0,
      0,
      0.007544,
      3.026368,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.498215,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.499211,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.440588,
      NULL,
      NULL,
      NULL,
      0.256647,
      NULL,
      NULL,
      NULL,
      0.196317,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.297550,
      NULL,
      NULL,
      NULL,
      0.416635,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.813732,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.013164,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.505554,
      15,
      1,
      0.133479,
      1,
      0,
      NULL,
      1,
      1,
      0.405748,
      0,
      NULL,
      1,
      NULL,
      0,
      0.374882,
      0.237487,
      1,
      0.623246,
      0,
      0.759521,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.484577,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.170141,
      0,
      1,
      NULL,
      1,
      3,
      1,
      NULL,
      1.317592,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      3.142093,
      NULL,
      NULL,
      0,
      1,
      NULL,
      3.203398,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      2,
      NULL,
      2.022717,
      2,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3.664966,
      NULL,
      NULL,
      3,
      NULL,
      2.830883,
      1,
      1.377608,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.731435,
      NULL,
      1.611063,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      62.176401,
      55,
      1,
      5.333878,
      1,
      '11133',
      '2141',
      '',
      1,
      '41433',
      '',
      '',
      1.847770,
      '',
      '',
      '');
commit;
end;
/


