set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9646454';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-1-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '33',
      NULL,
      23.777628,
      4.333368,
      '0104012',
      NULL,
      NULL,
      NULL,
      NULL,
      '0204',
      0.352339,
      0,
      NULL,
      NULL,
      NULL,
      5,
      28.132873,
      NULL,
      0,
      NULL,
      ' 0- 6-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      ' 1-26-1983',
      ' 8-23-1982',
      ' 6- 1-1992',
      1.105308,
      2.221131,
      2,
      0.726193,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      7,
      15.721704,
      4.459493,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.258969,
      NULL,
      0.281495,
      0.483868,
      1,
      0.575051,
      1,
      0,
      0,
      0,
      1.928377,
      NULL,
      0.856998,
      NULL,
      0.065043,
      NULL,
      1.799627,
      1.319437,
      1,
      0.151992,
      3,
      NULL,
      0,
      1.134786,
      1.964666,
      0,
      1,
      4.595183,
      NULL,
      NULL,
      3.032047,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      1.577238,
      1.831001,
      NULL,
      1,
      NULL,
      0,
      0.095346,
      0.631852,
      0.255635,
      0.440378,
      1.716780,
      0.813869,
      0,
      1,
      0.326805,
      0.938023,
      0.504361,
      0.041636,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.732348,
      0,
      1.242129,
      NULL,
      NULL,
      3.413814,
      7,
      1.055546,
      NULL,
      0,
      1.329168,
      0,
      1,
      NULL,
      1,
      1.744815,
      0,
      0.521646,
      0,
      NULL,
      0.768123,
      NULL,
      2.984887,
      1,
      3.251438,
      1.868204,
      7.930196,
      0,
      0,
      1.024180,
      1.275056,
      1.579792,
      3,
      0,
      1,
      3,
      1.449117,
      0.506903,
      8,
      NULL,
      4,
      5,
      NULL,
      4.594095,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-11-1990',
      NULL,
      ' 3-24-2001',
      540,
      0,
      NULL,
      1.922661,
      5.480990,
      0.961259,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.936369,
      1,
      1.633579,
      0,
      NULL,
      1.125287,
      1,
      1.003626,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.915687,
      1.930956,
      2.008314,
      4,
      1,
      3.423324,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.303113,
      0.488404,
      0.557122,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      NULL,
      2.320888,
      0,
      1.013593,
      0.963772,
      275.265602,
      NULL,
      0.998680,
      NULL,
      NULL,
      NULL,
      NULL,
      1.042304,
      3.083980,
      0.344536,
      0.021100,
      NULL,
      NULL,
      2.928990,
      3,
      2,
      0,
      NULL,
      0.158638,
      2.602287,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.485255,
      8,
      NULL,
      NULL,
      2,
      NULL,
      6.026134,
      NULL,
      3,
      1,
      0.277862,
      2.466188,
      3.712248,
      43.372750,
      3.317818,
      NULL,
      52.464662,
      NULL,
      22.512831,
      NULL,
      5.613652,
      0,
      NULL,
      '03231',
      '',
      '',
      0.471818,
      '',
      '',
      '',
      3.776288,
      NULL,
      '',
      '',
      1,
      10.523692,
      141,
      NULL,
      1,
      NULL,
      3.383411,
      19,
      1,
      2.472127,
      2,
      3.270555,
      1,
      NULL,
      NULL,
      1.968952,
      NULL,
      NULL,
      0.360010,
      NULL,
      NULL,
      3.093426,
      3.536497,
      NULL,
      1.895050,
      NULL,
      3.892564,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.088581,
      NULL,
      0.959620,
      1.525846,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.712638,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.031032,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.998294,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.938625,
      3.137076,
      3,
      1,
      1,
      2,
      1,
      NULL,
      NULL,
      0.360279,
      6.533880,
      NULL,
      1.976697,
      NULL,
      NULL,
      0.679167,
      3,
      1,
      2,
      6,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.351840,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.878671,
      1,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.042260,
      0.575997,
      1.162152,
      1.365703,
      NULL,
      2.841526,
      1.261943,
      3.938778,
      3,
      0,
      2.865176,
      NULL,
      3.212829,
      2,
      NULL,
      4.841100,
      2,
      0.551301,
      3.177091,
      0,
      NULL,
      NULL,
      NULL,
      2.369151,
      3.404322,
      2.560709,
      3,
      NULL,
      1,
      9,
      NULL,
      0,
      0,
      3,
      NULL,
      3,
      NULL,
      0.048450,
      1,
      0.895767,
      1.418886,
      1.640658,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.725070,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.196972,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.025504,
      0.752318,
      1.195875,
      1.196626,
      0.113388,
      0.169789,
      1.559836,
      NULL,
      NULL,
      3.410079,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.444166,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.047015,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.118453,
      1.773847,
      NULL,
      NULL,
      0.363378,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.779951,
      NULL,
      NULL,
      NULL,
      NULL,
      1.274772,
      NULL,
      NULL,
      NULL,
      0.728503,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      1.516946,
      NULL,
      NULL,
      NULL,
      1.948897,
      NULL,
      10.801854,
      1,
      1.223210,
      257.743694,
      1.212170,
      NULL,
      NULL,
      1.260473,
      NULL,
      NULL,
      1,
      7,
      1223,
      NULL,
      NULL,
      NULL,
      1.577222,
      16.020862,
      1.843588,
      40.296563,
      0.812424,
      1.441113,
      NULL,
      0.473931,
      1,
      0,
      1,
      1.453481,
      0,
      1.849020,
      1.772823,
      0.558602,
      1,
      NULL,
      0,
      0,
      1,
      1.573971,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.420295,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.819482,
      NULL,
      0,
      1,
      NULL,
      3,
      1,
      1.003725,
      0.539267,
      0,
      2,
      0,
      1,
      0.556315,
      2.794975,
      0,
      0.410268,
      0,
      0,
      0.723351,
      2,
      NULL,
      1.982994,
      1,
      1.785950,
      0.626688,
      1.956794,
      0,
      0.598915,
      NULL,
      1.381614,
      0,
      NULL,
      NULL,
      NULL,
      0.093706,
      1.420034,
      1,
      0.046679,
      1,
      3,
      1.029553,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.132456,
      0.246512,
      1,
      0.387385,
      0,
      8,
      1.900262,
      NULL,
      1.597181,
      2.794527,
      3,
      NULL,
      29,
      2.398366,
      0.020459,
      0,
      '12321',
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      '2222',
      '',
      '');
commit;
end;
/


