set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8719263';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-4-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '4',
      NULL,
      NULL,
      '1400332',
      0,
      0.767649,
      NULL,
      0,
      '3244',
      3.920748,
      2,
      2.923408,
      3.023823,
      '11- 1-1986',
      12,
      NULL,
      3.215505,
      NULL,
      1,
      ' 5- 0-1987',
      9,
      0,
      143.458576,
      142.191983,
      1.452166,
      NULL,
      NULL,
      ' 2-19-1979',
      NULL,
      0.271272,
      NULL,
      0.346385,
      0,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      13.118568,
      2,
      NULL,
      NULL,
      NULL,
      1,
      3.750715,
      1.813794,
      0,
      0.125972,
      0,
      1,
      1.773894,
      1.442674,
      0,
      1.963363,
      3.183616,
      0,
      2.859655,
      1.229906,
      1.794092,
      1.709352,
      1,
      0,
      1,
      0.092230,
      0,
      1,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.996202,
      1.538565,
      1.007182,
      1.143380,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.682864,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.719492,
      1,
      0,
      1.243838,
      1,
      0,
      1.195457,
      1,
      0.430202,
      NULL,
      0.316940,
      NULL,
      0,
      0,
      0,
      NULL,
      0.829351,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.819550,
      0.363609,
      1.678389,
      NULL,
      0.066351,
      1,
      1,
      0.177022,
      NULL,
      1,
      0,
      0,
      0.767958,
      1.604308,
      0,
      1.152692,
      1.054138,
      4,
      NULL,
      NULL,
      1.056161,
      0.496873,
      0.175671,
      1,
      0.905194,
      1.432284,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.439474,
      0.578419,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.520871,
      1,
      0.503468,
      1,
      NULL,
      1.881540,
      1.424313,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.914092,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.380155,
      0.972116,
      0.206871,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.113245,
      0,
      0,
      1.289657,
      NULL,
      0.172019,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      1.053911,
      0,
      1,
      0,
      NULL,
      1,
      2,
      NULL,
      2.191994,
      3.672228,
      1.228434,
      3,
      4,
      1.197540,
      NULL,
      NULL,
      NULL,
      0,
      0.937356,
      0.506816,
      NULL,
      1,
      NULL,
      3,
      NULL,
      0.511812,
      6,
      1.800130,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      28,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '43241',
      '',
      '',
      0,
      NULL,
      '',
      NULL,
      0.873806,
      '',
      '',
      '',
      2,
      19,
      89,
      NULL,
      3,
      NULL,
      1,
      0,
      3.906952,
      0,
      NULL,
      NULL,
      1,
      1.222078,
      0,
      NULL,
      NULL,
      NULL,
      3.641826,
      0.870767,
      NULL,
      2,
      1.601797,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.590274,
      0.597316,
      NULL,
      1,
      0.413334,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.233421,
      NULL,
      0.080663,
      0.763547,
      0,
      NULL,
      2,
      NULL,
      1,
      1,
      3.061920,
      1,
      0.854717,
      NULL,
      NULL,
      NULL,
      0.994879,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.009978,
      0.819151,
      3.929392,
      NULL,
      0.969346,
      1,
      NULL,
      NULL,
      NULL,
      1.952847,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3.350183,
      0.145270,
      0.580244,
      1.841962,
      NULL,
      NULL,
      6.577903,
      1,
      0.821507,
      NULL,
      0.829375,
      0,
      2.727525,
      0,
      1,
      1,
      1,
      NULL,
      0.412913,
      NULL,
      NULL,
      0.488794,
      NULL,
      NULL,
      0.767748,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.843601,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0,
      0,
      0.529418,
      3.860186,
      6.600028,
      6.148434,
      1.722299,
      1,
      2,
      0,
      0.694754,
      0.608703,
      NULL,
      NULL,
      0,
      1.513600,
      0,
      3.911516,
      0,
      0.745624,
      0,
      0.916440,
      2.161922,
      7,
      NULL,
      1.984594,
      2,
      NULL,
      2,
      1,
      0,
      1,
      1,
      1.956723,
      0,
      NULL,
      1.471339,
      1,
      NULL,
      NULL,
      3,
      3.886528,
      1.147686,
      0.484442,
      0.950377,
      2.926699,
      NULL,
      1,
      1,
      2,
      3,
      1,
      0,
      3.233151,
      NULL,
      NULL,
      32.185573,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.833548,
      NULL,
      NULL,
      1.310436,
      NULL,
      NULL,
      1.884149,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.702172,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.187902,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      14,
      NULL,
      NULL,
      3.503725,
      NULL,
      2.606107,
      3,
      1,
      0,
      1.210883,
      0,
      0,
      6,
      NULL,
      NULL,
      NULL,
      20,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.833067,
      NULL,
      NULL,
      NULL,
      2.190913,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.657627,
      NULL,
      NULL,
      NULL,
      1.177455,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.871193,
      NULL,
      NULL,
      NULL,
      1.791295,
      NULL,
      NULL,
      2,
      43,
      2.627456,
      1.052634,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      8.005678,
      1.749204,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1536,
      1289,
      1,
      0.159190,
      1,
      0.543405,
      0.499706,
      0,
      1.677905,
      1.143652,
      0.780797,
      NULL,
      1,
      1,
      1,
      1.470602,
      1,
      0.408179,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.176071,
      4,
      0.720477,
      2,
      1,
      1.244732,
      2,
      2,
      NULL,
      0.659922,
      0.336477,
      1,
      1,
      0,
      3.737773,
      NULL,
      1.693514,
      1,
      0,
      NULL,
      2.146662,
      1.011614,
      1,
      0,
      1,
      0.695666,
      3,
      NULL,
      0.245463,
      0.428444,
      0.371816,
      1.803611,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.645108,
      0,
      1.410633,
      NULL,
      0.730552,
      0,
      2,
      3,
      3,
      NULL,
      0.334598,
      3.381521,
      NULL,
      2.345270,
      3,
      3,
      1.484122,
      2,
      0.245651,
      3,
      NULL,
      2,
      2,
      0.490989,
      1,
      3.266239,
      3.465794,
      1.800491,
      0,
      1.223002,
      1,
      2,
      1,
      2,
      2.124476,
      13.673231,
      2,
      NULL,
      1,
      3.844408,
      2,
      1,
      0.918113,
      0.630487,
      1,
      3,
      1,
      0,
      NULL,
      2,
      2,
      2.965040,
      NULL,
      2,
      NULL,
      2,
      1,
      1.890758,
      2.279689,
      NULL,
      1.724316,
      0,
      3.718020,
      0,
      0,
      NULL,
      3,
      NULL,
      0,
      1,
      NULL,
      NULL,
      3,
      2,
      2.712505,
      0.606246,
      NULL,
      1.823985,
      NULL,
      NULL,
      116.588947,
      41,
      0.809807,
      NULL,
      0.912948,
      '00244',
      '',
      NULL,
      0.559336,
      NULL,
      '',
      '',
      0.508927,
      '',
      NULL,
      '');
commit;
end;
/


