set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8107502';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-7-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '2',
      NULL,
      NULL,
      '3202323',
      NULL,
      NULL,
      2,
      NULL,
      '4444',
      0,
      1,
      NULL,
      NULL,
      ' 0-23-1981',
      35,
      NULL,
      NULL,
      3,
      0.601303,
      ' 6- 6-2001',
      NULL,
      3,
      NULL,
      NULL,
      0.317483,
      NULL,
      NULL,
      ' 4-14-1995',
      0,
      2,
      NULL,
      NULL,
      0,
      0,
      2,
      0,
      0.908419,
      117,
      7,
      NULL,
      1,
      114.984842,
      52,
      NULL,
      9,
      5.886314,
      NULL,
      NULL,
      1.041563,
      0.112031,
      0.815780,
      0,
      1,
      0,
      0,
      NULL,
      0.973800,
      1,
      44.169340,
      8,
      3,
      5.468273,
      3,
      0,
      1,
      3.228672,
      0.027607,
      0.814047,
      2.203625,
      NULL,
      1,
      1.349398,
      0.181384,
      0.610995,
      NULL,
      1.274683,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      6,
      1,
      0.891022,
      NULL,
      1,
      1.422926,
      NULL,
      0,
      3,
      NULL,
      1,
      1,
      0,
      2,
      NULL,
      1.372488,
      0.909265,
      NULL,
      1.341389,
      0,
      1,
      4,
      NULL,
      1.037871,
      2.065871,
      1,
      NULL,
      NULL,
      0.298744,
      NULL,
      NULL,
      1,
      4,
      NULL,
      1,
      2.767120,
      2.840246,
      5,
      1.425652,
      4,
      NULL,
      0.003262,
      1,
      1.523825,
      NULL,
      0,
      0,
      0,
      0,
      1,
      NULL,
      0.827423,
      1.990151,
      0.372358,
      5.941570,
      NULL,
      0.110488,
      6,
      0,
      NULL,
      2.728524,
      0.890371,
      0,
      1,
      4,
      1,
      1,
      6.814021,
      NULL,
      3,
      5.448232,
      NULL,
      9.664839,
      NULL,
      9.177646,
      9.155966,
      2.932978,
      NULL,
      1.948631,
      NULL,
      914.560039,
      ' 6- 6-1988',
      NULL,
      0.527858,
      1.168214,
      1.877877,
      1.153239,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.396329,
      1.453977,
      0,
      1.578674,
      1.629782,
      1,
      0,
      0.901697,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      0.433717,
      1.960293,
      NULL,
      NULL,
      NULL,
      1,
      0.881018,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.279775,
      1.012727,
      0.005181,
      0.425356,
      1.119880,
      1.249932,
      0.745154,
      1.498868,
      8,
      NULL,
      1.837840,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0.222037,
      1.854055,
      2.394962,
      2,
      3,
      3.295407,
      0.589056,
      1.013408,
      1,
      2.944804,
      2.792090,
      NULL,
      8,
      41.699387,
      NULL,
      6.091869,
      94.962795,
      NULL,
      1.156805,
      NULL,
      0.395263,
      3,
      1.227209,
      NULL,
      NULL,
      0.533684,
      5,
      NULL,
      11,
      2,
      4.320976,
      0,
      4,
      1.001734,
      2.365227,
      3.620795,
      5.268329,
      0.476244,
      1,
      1,
      19,
      0,
      2,
      NULL,
      29,
      25,
      6,
      4,
      0,
      2.691648,
      '31442',
      NULL,
      '',
      1.289284,
      '',
      NULL,
      '',
      0,
      '',
      NULL,
      '',
      3.754762,
      10,
      414.673106,
      46,
      2,
      NULL,
      18,
      862,
      0.702302,
      4,
      NULL,
      NULL,
      15,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.730462,
      NULL,
      NULL,
      0.216185,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.734744,
      NULL,
      NULL,
      NULL,
      8.649127,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.025723,
      1,
      0.340036,
      0,
      NULL,
      1,
      1.992539,
      0,
      0.469949,
      1,
      1,
      0.876235,
      0,
      15.377078,
      NULL,
      NULL,
      1.443930,
      NULL,
      NULL,
      0.277873,
      NULL,
      NULL,
      2,
      7.228181,
      3.773427,
      1.701128,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.757742,
      NULL,
      NULL,
      1.077872,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.374493,
      NULL,
      NULL,
      1.538505,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.825894,
      NULL,
      NULL,
      0.110904,
      NULL,
      NULL,
      1.363427,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.190803,
      NULL,
      NULL,
      19.675214,
      NULL,
      NULL,
      18,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2.776324,
      3,
      5,
      1,
      NULL,
      NULL,
      15.923298,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      2,
      2.113633,
      2.681534,
      NULL,
      1.310343,
      0.729022,
      1,
      1.263075,
      0,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.510136,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.922886,
      NULL,
      NULL,
      0.259008,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.767466,
      NULL,
      NULL,
      1.666725,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.333472,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.043668,
      1.626667,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.105930,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.951011,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.454107,
      NULL,
      NULL,
      NULL,
      NULL,
      15.334110,
      NULL,
      NULL,
      NULL,
      0.322559,
      NULL,
      NULL,
      0.625894,
      0,
      NULL,
      NULL,
      0.498239,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1248,
      651.698859,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.394337,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.001458,
      118.305905,
      1,
      11202.024463,
      1743,
      1.127317,
      1.242493,
      0,
      0.127516,
      1,
      NULL,
      NULL,
      0.687280,
      0,
      1,
      NULL,
      NULL,
      1.501184,
      0.340187,
      1,
      0.395297,
      1.133710,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.827401,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.228051,
      2.352653,
      3.869506,
      1,
      1,
      NULL,
      18,
      0.325796,
      0.882681,
      1.192578,
      2,
      0,
      NULL,
      0.267381,
      1,
      13.117865,
      10,
      0.559239,
      0.742536,
      1.097860,
      0.544927,
      1,
      0.433360,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.529976,
      1,
      NULL,
      1.460456,
      10,
      0,
      0,
      2.856016,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.071675,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.901074,
      0,
      0,
      1,
      0,
      1.864997,
      NULL,
      6,
      3.482384,
      0,
      NULL,
      NULL,
      16.134228,
      10.162083,
      NULL,
      0.365477,
      NULL,
      '43022',
      '',
      '',
      NULL,
      '',
      '',
      '',
      3,
      '401',
      NULL,
      '');
commit;
end;
/


