set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000173';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-9-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '3',
      NULL,
      NULL,
      '1423141',
      1.686897,
      1.122982,
      3,
      2,
      '0103',
      0,
      1.719727,
      2,
      14,
      ' 1- 0-1985',
      12.211738,
      NULL,
      4,
      1.893501,
      0.840088,
      '11-24-1990',
      21,
      NULL,
      175.716644,
      19,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.556054,
      1.176723,
      1.187794,
      1.539352,
      NULL,
      1.865243,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      19,
      10,
      0,
      4.337266,
      NULL,
      1.124578,
      2,
      NULL,
      0,
      1,
      NULL,
      0,
      0,
      0.794597,
      0.822981,
      1,
      1.954336,
      1.445706,
      3.943586,
      3,
      3.829283,
      1,
      1,
      0.777880,
      1.260972,
      1.047496,
      1.087290,
      1.575744,
      NULL,
      0,
      0,
      1.715362,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.324485,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.364926,
      1,
      1.491564,
      5.448839,
      1,
      1,
      2,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.984589,
      1,
      NULL,
      NULL,
      0,
      0.062151,
      0,
      1,
      NULL,
      0,
      1.317477,
      0,
      1,
      1.744532,
      NULL,
      0,
      0,
      NULL,
      1.922974,
      NULL,
      0,
      1.918971,
      NULL,
      0,
      NULL,
      NULL,
      0.415766,
      NULL,
      3.643522,
      2,
      0,
      0.937439,
      0,
      4,
      0,
      1,
      NULL,
      1,
      1,
      1.670456,
      3.881088,
      0.231038,
      NULL,
      3.151285,
      NULL,
      0,
      NULL,
      0.502317,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.221288,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.604680,
      1.652233,
      1.759174,
      0,
      1.910181,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.417861,
      NULL,
      NULL,
      NULL,
      NULL,
      0.496970,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.015050,
      1.518750,
      NULL,
      1.439546,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.828009,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.146172,
      1.379759,
      1,
      1,
      NULL,
      1.488552,
      NULL,
      2.952557,
      1.082867,
      NULL,
      NULL,
      NULL,
      2,
      1,
      2.361673,
      3.959047,
      0,
      1,
      2.981498,
      1.911463,
      1.891194,
      NULL,
      2,
      2.106117,
      1.087550,
      2.099036,
      NULL,
      NULL,
      10.575299,
      NULL,
      0,
      NULL,
      1.672989,
      0,
      1.363516,
      0,
      1,
      1.681429,
      1,
      0,
      NULL,
      1,
      0,
      1,
      NULL,
      5.115900,
      2,
      9.349795,
      7,
      1.161622,
      NULL,
      2.765035,
      1,
      NULL,
      NULL,
      2,
      NULL,
      2,
      1.153931,
      2.846667,
      NULL,
      NULL,
      NULL,
      3,
      0.578935,
      0,
      '',
      '',
      '',
      0.623160,
      '41231',
      '',
      '',
      1.154134,
      NULL,
      '',
      NULL,
      3,
      19,
      349.471912,
      12.971351,
      2.941453,
      0,
      3.618307,
      1.473752,
      NULL,
      NULL,
      NULL,
      NULL,
      1.575863,
      NULL,
      NULL,
      1.486056,
      NULL,
      NULL,
      0.772435,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.715172,
      NULL,
      NULL,
      0.868383,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.812459,
      NULL,
      NULL,
      5,
      1.758137,
      1.738251,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.225564,
      1.839991,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.490765,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.076458,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.009750,
      NULL,
      NULL,
      NULL,
      4.072646,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      2.871281,
      1.977067,
      1.681617,
      1,
      NULL,
      NULL,
      NULL,
      1.770193,
      NULL,
      NULL,
      3,
      11.970813,
      3.470213,
      1.169430,
      NULL,
      NULL,
      0.211206,
      1,
      1,
      1.790458,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.284944,
      NULL,
      NULL,
      1.758137,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.256574,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.041357,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.054173,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      3.308311,
      1.680654,
      2,
      NULL,
      NULL,
      4,
      0.692246,
      NULL,
      0,
      1.574053,
      3.719129,
      3,
      8,
      NULL,
      0,
      16.964305,
      0,
      3.973377,
      NULL,
      1,
      0.554032,
      0.999164,
      1,
      NULL,
      4,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      0.013028,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      0,
      0.597084,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.386767,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.788631,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.674331,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.438728,
      1,
      NULL,
      NULL,
      1.396594,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      2.382149,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.430792,
      NULL,
      NULL,
      0,
      16.605845,
      NULL,
      NULL,
      1.630163,
      2.617946,
      NULL,
      1.609599,
      NULL,
      10.316080,
      7,
      2,
      21.415300,
      0.068890,
      NULL,
      6,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      12.024510,
      NULL,
      0.728087,
      NULL,
      NULL,
      NULL,
      10.393631,
      1,
      NULL,
      0,
      1,
      1.712957,
      0.739519,
      NULL,
      1,
      1,
      1,
      1,
      1,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.498608,
      0,
      0.438710,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.686393,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.762402,
      3,
      3.379468,
      0,
      5.599489,
      0.322725,
      5.528709,
      18,
      0,
      NULL,
      1.401156,
      NULL,
      0.301512,
      0.796977,
      0,
      0.785123,
      0,
      0.658617,
      0,
      1.884902,
      3.654381,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0.885667,
      0,
      1.428445,
      NULL,
      3.168229,
      NULL,
      1,
      0,
      1,
      0,
      1.237867,
      NULL,
      1,
      NULL,
      2.378565,
      0.219377,
      0.867519,
      1.468691,
      NULL,
      2.911371,
      2,
      1,
      0,
      0.265876,
      NULL,
      1.512996,
      NULL,
      0.004059,
      NULL,
      0.531411,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.346562,
      NULL,
      0,
      NULL,
      1.425522,
      NULL,
      0,
      NULL,
      39.288768,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.942994,
      1,
      NULL,
      1,
      4.731745,
      NULL,
      0,
      0,
      3,
      0.348274,
      106.749353,
      103,
      3.206713,
      1,
      0,
      '04334',
      '',
      '',
      2.666888,
      '13334',
      NULL,
      '',
      2,
      '13133',
      '',
      NULL);
commit;
end;
/


