set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7425231';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-9-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '24',
      16,
      32.632421,
      NULL,
      0,
      0.872566,
      3,
      1,
      NULL,
      4,
      0.317052,
      NULL,
      NULL,
      ' 3-14-1988',
      57,
      NULL,
      NULL,
      3.560743,
      0,
      '10-10-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4- 3-1999',
      ' 2-24-2002',
      ' 2-25-1989',
      3.541756,
      2,
      0.305631,
      0.056838,
      1,
      0.245699,
      2,
      NULL,
      1,
      34,
      2.019124,
      14,
      3.879409,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.768645,
      NULL,
      3.907521,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      2,
      0,
      NULL,
      NULL,
      1,
      0,
      1.578720,
      5,
      2.883475,
      1,
      1.433328,
      0,
      1,
      NULL,
      0.015118,
      0.651960,
      4,
      0,
      1.343839,
      0.656193,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.773518,
      1.729734,
      1,
      1.292233,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      1,
      1,
      1,
      1.451375,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.781173,
      2.675562,
      0.211298,
      0,
      0,
      1,
      1.924053,
      1.859828,
      0,
      NULL,
      1.713870,
      0,
      NULL,
      0.594808,
      0.304105,
      1.722945,
      1.619794,
      0,
      2.967486,
      2,
      0.742826,
      3.059509,
      0.062866,
      NULL,
      1.153220,
      1,
      1.754686,
      5,
      0.158881,
      NULL,
      0,
      0.564286,
      1.907417,
      1.835822,
      2.185623,
      0.619634,
      2,
      1,
      6.578528,
      0,
      4.285224,
      3.195062,
      7,
      1,
      2.916008,
      3.474577,
      NULL,
      0,
      ' 7-20-1984',
      966.135899,
      ' 4-28-1995',
      1795.438082,
      NULL,
      1.245842,
      0,
      2.631534,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      5.726694,
      NULL,
      0.271426,
      NULL,
      1,
      2,
      NULL,
      2.049974,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      252.242173,
      NULL,
      3.269242,
      1.234756,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.686122,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      0.512589,
      NULL,
      3,
      2,
      5,
      5,
      1,
      NULL,
      NULL,
      0,
      8,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.007182,
      1.581108,
      NULL,
      0.851061,
      0,
      1,
      0,
      3,
      5.837385,
      3.720579,
      1,
      NULL,
      6,
      114.535457,
      2.387600,
      1.025261,
      0,
      2,
      3.028313,
      3.658219,
      1.634013,
      2.561172,
      3.835794,
      0.145016,
      0.979109,
      0,
      2,
      0,
      1,
      1,
      NULL,
      1,
      0.039177,
      NULL,
      0.447961,
      1.234581,
      1,
      1.556392,
      0,
      0,
      NULL,
      1,
      NULL,
      1,
      0.362848,
      1.556580,
      9,
      NULL,
      2,
      9,
      11,
      6.500551,
      5.596560,
      0,
      5,
      2.067124,
      NULL,
      1,
      NULL,
      3.725046,
      0.621781,
      12.151221,
      NULL,
      50,
      43,
      NULL,
      3.570110,
      1.820155,
      '32230',
      '',
      NULL,
      1,
      '',
      '',
      '',
      1,
      '',
      '',
      NULL,
      0,
      NULL,
      370,
      5,
      1,
      NULL,
      17,
      2.185650,
      NULL,
      1,
      1,
      3.950580,
      1.168762,
      NULL,
      NULL,
      0,
      0,
      1.123970,
      0.513422,
      NULL,
      NULL,
      1.704200,
      NULL,
      NULL,
      2,
      3,
      2.174040,
      3.368349,
      NULL,
      2,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.173323,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.597990,
      NULL,
      NULL,
      1.908511,
      5,
      1.252138,
      1.164514,
      1.888774,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1,
      3,
      3,
      NULL,
      0,
      1.441040,
      NULL,
      NULL,
      0.365955,
      NULL,
      NULL,
      1.552054,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.132708,
      2.842411,
      2.441517,
      0,
      NULL,
      0.881137,
      1,
      NULL,
      NULL,
      3.805345,
      3,
      7.565889,
      1,
      1.344392,
      NULL,
      NULL,
      NULL,
      3,
      2.475630,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.595276,
      1,
      0.830458,
      NULL,
      NULL,
      7.606323,
      NULL,
      NULL,
      0,
      0,
      1.340441,
      0,
      NULL,
      NULL,
      6,
      0.882423,
      0,
      0.525863,
      NULL,
      NULL,
      0.472177,
      NULL,
      NULL,
      1.009819,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      1.000820,
      NULL,
      NULL,
      NULL,
      0.845682,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      4.501005,
      7,
      4,
      1.989002,
      1.840279,
      NULL,
      2,
      3,
      NULL,
      NULL,
      1,
      0,
      3.811327,
      2.176611,
      7,
      3.128792,
      1,
      NULL,
      1,
      NULL,
      1.571313,
      NULL,
      2,
      0,
      NULL,
      1,
      0,
      NULL,
      9.897438,
      0,
      0,
      NULL,
      2.020621,
      1,
      0,
      2.332398,
      8,
      1.236403,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.704452,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.293671,
      NULL,
      NULL,
      1.426837,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      2.666207,
      1.359727,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.297294,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.905357,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.419135,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.430242,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.029084,
      NULL,
      NULL,
      NULL,
      2.888762,
      NULL,
      NULL,
      NULL,
      2.099357,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      131.724321,
      NULL,
      1.180537,
      9,
      2,
      1.114283,
      NULL,
      NULL,
      1,
      1.941410,
      NULL,
      1.277608,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.370278,
      NULL,
      0,
      567,
      142,
      1.868282,
      0,
      1.103477,
      NULL,
      1,
      0,
      1,
      NULL,
      0.939636,
      NULL,
      1.825334,
      NULL,
      0.224885,
      0.272760,
      1.105788,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.455332,
      5,
      0.026676,
      NULL,
      0,
      4.710999,
      2,
      2,
      13.512187,
      3.159825,
      0,
      1.636397,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      2.895753,
      NULL,
      0.960435,
      0.677388,
      NULL,
      1.094263,
      1.908790,
      NULL,
      1.694850,
      0,
      NULL,
      1.035325,
      1.195960,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.688468,
      NULL,
      1,
      2,
      NULL,
      0,
      0.151078,
      NULL,
      1,
      0.320900,
      0.654830,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.942222,
      NULL,
      3,
      NULL,
      0.156293,
      NULL,
      1.880550,
      NULL,
      1.447852,
      NULL,
      3.549527,
      NULL,
      0.418176,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      11.486719,
      1.983869,
      NULL,
      0,
      NULL,
      0.373901,
      NULL,
      0,
      NULL,
      6,
      NULL,
      10,
      1.012476,
      1.724753,
      3.586543,
      59.637040,
      58,
      3.859487,
      4,
      NULL,
      '10334',
      '',
      '',
      0.924950,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


