set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7314629';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-7-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1100223',
      3.336852,
      1.337370,
      1,
      NULL,
      '3022',
      2,
      1.444112,
      NULL,
      NULL,
      ' 8-29-1995',
      56,
      NULL,
      NULL,
      0.780961,
      1.654733,
      NULL,
      NULL,
      NULL,
      275,
      4,
      2,
      NULL,
      ' 0- 0-1990',
      '10- 0-1993',
      3,
      0.646032,
      3.456362,
      0,
      0.567966,
      0,
      3.844068,
      0.790602,
      1.537855,
      6.100694,
      4.177458,
      5.710052,
      5.921063,
      11.969078,
      16,
      3,
      20.338585,
      5,
      NULL,
      4,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      9,
      0.357031,
      3.890261,
      0.585904,
      0,
      0,
      10.443491,
      NULL,
      1,
      1,
      0.533518,
      NULL,
      1.333115,
      NULL,
      0,
      NULL,
      NULL,
      5.641611,
      3,
      3.657049,
      0,
      3.791633,
      1.781597,
      1.656706,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.550082,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.801351,
      5,
      NULL,
      0.111297,
      7,
      4.837876,
      0.818918,
      1.793467,
      2.993139,
      9,
      8,
      NULL,
      1,
      0.438510,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.493642,
      1.634460,
      1,
      1,
      1.577366,
      0,
      0,
      0,
      0,
      1,
      1.000127,
      NULL,
      1,
      1.983376,
      6.559132,
      4,
      3.855507,
      1.054041,
      2,
      NULL,
      1,
      3,
      3,
      4,
      0.196204,
      0,
      0.440872,
      0,
      ' 9- 3-1977',
      212.454439,
      ' 5-20-2001',
      16.160538,
      1,
      3.396167,
      0.946675,
      0,
      8,
      NULL,
      58,
      0,
      1,
      NULL,
      NULL,
      3.206336,
      6,
      1.881474,
      NULL,
      1.631995,
      4,
      3.872359,
      0,
      6,
      1,
      ' 4-19-1979',
      52,
      NULL,
      100.672913,
      1.478081,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.626242,
      0.256339,
      0.004279,
      1,
      0,
      0.358401,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.889765,
      NULL,
      1,
      1,
      1.564417,
      0,
      1.570534,
      2.819448,
      9,
      1.935566,
      NULL,
      NULL,
      NULL,
      NULL,
      0.227899,
      0,
      1.754584,
      3,
      2,
      NULL,
      1.272528,
      3,
      2.964199,
      NULL,
      NULL,
      3,
      NULL,
      1.345767,
      3,
      3,
      1,
      0,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      1.643800,
      NULL,
      1,
      1.184951,
      3.214940,
      0,
      1,
      0.012189,
      6,
      3,
      NULL,
      0,
      4.485942,
      2,
      6,
      1,
      3,
      1.398547,
      52.268803,
      3,
      0.810827,
      NULL,
      7.479583,
      46.351222,
      69.701880,
      1,
      1.014693,
      2.332056,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      1.379417,
      '',
      '',
      NULL,
      1,
      29.513527,
      8.909372,
      NULL,
      0.961981,
      NULL,
      NULL,
      NULL,
      NULL,
      0.099324,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.536829,
      NULL,
      NULL,
      1.559240,
      1,
      0.986472,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.921011,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.616598,
      3,
      4.853371,
      NULL,
      2.662737,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.150777,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.201063,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.868657,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.433418,
      1.350958,
      NULL,
      NULL,
      3.055874,
      3.237793,
      3,
      3.881640,
      0.458694,
      0,
      3.522200,
      NULL,
      3.474964,
      6.816974,
      2,
      5,
      1.088780,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.279977,
      NULL,
      NULL,
      0.520278,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.789673,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.771582,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5.673325,
      7.294456,
      6,
      2.147634,
      0,
      0,
      0,
      1.450152,
      0,
      1,
      NULL,
      NULL,
      NULL,
      2.203666,
      5,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      3,
      NULL,
      1,
      3.300514,
      1,
      3.436093,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      0.472705,
      1,
      1,
      NULL,
      1,
      6.041515,
      NULL,
      6,
      37.557795,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.436211,
      NULL,
      0.669070,
      0,
      NULL,
      3,
      NULL,
      NULL,
      2.164095,
      2,
      NULL,
      3,
      NULL,
      NULL,
      3,
      3,
      NULL,
      2.798790,
      NULL,
      NULL,
      3,
      2,
      NULL,
      3.124714,
      0,
      NULL,
      NULL,
      1.596789,
      NULL,
      0,
      10.000409,
      NULL,
      1,
      1,
      NULL,
      1.685752,
      1.897348,
      1,
      0,
      0.091244,
      NULL,
      0.883999,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.790744,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.256387,
      NULL,
      NULL,
      1.941425,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.725847,
      NULL,
      0,
      676,
      4,
      1.753664,
      0,
      0.115223,
      0.059479,
      1,
      1.652974,
      1,
      1.967800,
      0,
      0.705483,
      0.505969,
      1,
      0,
      0,
      1.208034,
      1,
      0.713336,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.175292,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.452388,
      0.252519,
      0,
      0.361638,
      0,
      NULL,
      NULL,
      0.589689,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.404115,
      3.748052,
      NULL,
      1.607186,
      1,
      NULL,
      1.029608,
      NULL,
      NULL,
      0,
      1,
      1,
      1.198333,
      1,
      1,
      0,
      1.559280,
      1.053562,
      0.475068,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.013493,
      NULL,
      1.246664,
      NULL,
      1,
      0.618064,
      NULL,
      NULL,
      0.567726,
      NULL,
      2,
      1,
      1.070737,
      0.558594,
      0.560369,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.079317,
      0.340166,
      0.160121,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.573840,
      0.947880,
      0.533969,
      NULL,
      1.913225,
      NULL,
      NULL,
      2.663932,
      0.867828,
      0.760878,
      3.646691,
      0.063746,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.457277,
      1.901228,
      NULL,
      NULL,
      1.387753,
      NULL,
      0.128496,
      1.336468,
      NULL,
      3.834511,
      3.691130,
      NULL,
      0.727241,
      1.646659,
      NULL,
      NULL,
      0.908661,
      NULL,
      0.054112,
      0,
      NULL,
      0.028900,
      0.170465,
      NULL,
      1.886821,
      3,
      NULL,
      1.446685,
      0,
      2.483671,
      0.357813,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.894944,
      NULL,
      0,
      NULL,
      2.061301,
      NULL,
      2.588651,
      NULL,
      0,
      NULL,
      3.506784,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      7,
      3.487285,
      NULL,
      1.778972,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.320907,
      NULL,
      1,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      15,
      NULL,
      4.951526,
      1.423791,
      '43322',
      '',
      '',
      1.966471,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


