set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9637950';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-12-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '01',
      '30',
      8,
      8.506800,
      '3444204',
      3,
      1,
      3,
      NULL,
      NULL,
      3.517231,
      NULL,
      NULL,
      NULL,
      ' 5- 8-1996',
      NULL,
      20,
      NULL,
      0.029259,
      0,
      '10- 6-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.121381,
      0.818898,
      0.476689,
      2.650854,
      4.650165,
      2.245807,
      NULL,
      NULL,
      NULL,
      0,
      1.772167,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.062740,
      1,
      1,
      0.700483,
      NULL,
      0.481802,
      2.219231,
      NULL,
      1,
      7.385911,
      0.154777,
      3.121505,
      1.259566,
      0.512891,
      1.270379,
      5.270121,
      1,
      0.575899,
      0,
      0.822849,
      1.375555,
      NULL,
      1,
      3,
      3.673586,
      NULL,
      0.189454,
      NULL,
      NULL,
      1.270355,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.411266,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.692672,
      3.092429,
      3,
      0.930706,
      0,
      NULL,
      11.806765,
      0,
      1,
      0.268847,
      4.213868,
      0,
      0,
      2,
      1,
      0,
      1,
      1.602868,
      NULL,
      NULL,
      0,
      0.537794,
      1.968320,
      0.393477,
      0.203054,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.906103,
      NULL,
      1.019773,
      1.174627,
      5,
      1.019736,
      1.709134,
      6.397660,
      9.566062,
      3.508486,
      3.559203,
      4,
      0.979433,
      0,
      NULL,
      3,
      NULL,
      0,
      ' 0-20-1999',
      9,
      0,
      NULL,
      0.689137,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      8,
      2.972765,
      1.296746,
      0,
      1,
      0,
      0.374373,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11.047930,
      1.726312,
      1.317165,
      0.464204,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.347830,
      3.599598,
      0,
      NULL,
      2.258894,
      NULL,
      5.954171,
      NULL,
      6.483164,
      5,
      1.803609,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.340936,
      0,
      0,
      1,
      1.885746,
      1.799495,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      1.726849,
      NULL,
      1,
      0.110358,
      2,
      2,
      3,
      1.262912,
      NULL,
      2.459583,
      1,
      2.967010,
      3,
      3,
      NULL,
      0.772525,
      NULL,
      0.521128,
      NULL,
      1.200119,
      0,
      1,
      1.603535,
      1.471765,
      1.272111,
      7.665909,
      3.863013,
      0,
      NULL,
      NULL,
      10,
      5,
      6,
      NULL,
      0.013520,
      3.520762,
      NULL,
      4,
      1.141013,
      2.314532,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      5,
      2,
      '0242',
      NULL,
      '',
      0,
      '',
      '',
      NULL,
      0.059831,
      '4220',
      '',
      '',
      0,
      57.524532,
      NULL,
      51,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      2.275474,
      2,
      1.408437,
      1,
      3.060304,
      2.047301,
      2.466019,
      0.486350,
      NULL,
      NULL,
      0.655519,
      NULL,
      NULL,
      3.310487,
      0,
      1.468717,
      1.904293,
      2,
      2.803666,
      0.611946,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.541778,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      5.437772,
      1.257186,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.866669,
      NULL,
      NULL,
      0.861093,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.752745,
      NULL,
      NULL,
      1.064015,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.288417,
      NULL,
      NULL,
      1.866977,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      1.583983,
      1.610125,
      1.721986,
      1.645021,
      NULL,
      1,
      3,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.900313,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.472439,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.339006,
      NULL,
      NULL,
      3,
      0,
      1.075388,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2,
      3,
      1.091168,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      NULL,
      5,
      0,
      0.604198,
      NULL,
      NULL,
      1.798654,
      1,
      4.417159,
      NULL,
      0,
      1,
      1,
      0.962724,
      3.779337,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.055120,
      NULL,
      NULL,
      1.577182,
      NULL,
      NULL,
      0.408479,
      NULL,
      NULL,
      0.812622,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.074832,
      NULL,
      NULL,
      0.276831,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      3,
      3,
      1.059571,
      0.106506,
      1,
      NULL,
      3.147448,
      NULL,
      NULL,
      0.098005,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.001092,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.287084,
      1,
      NULL,
      NULL,
      0.154856,
      NULL,
      NULL,
      NULL,
      2.902006,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.251204,
      0.458678,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      2,
      2.127349,
      NULL,
      NULL,
      1.243901,
      1,
      NULL,
      NULL,
      3,
      0.336979,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      13.902414,
      5,
      NULL,
      NULL,
      1.191861,
      NULL,
      NULL,
      NULL,
      1.099485,
      NULL,
      NULL,
      3,
      24.382878,
      5329.029501,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.505952,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      491,
      0.631734,
      1.484155,
      0,
      0.614319,
      3,
      1,
      NULL,
      0,
      3,
      1,
      3,
      NULL,
      1.793995,
      0.613821,
      1.046424,
      NULL,
      NULL,
      0.554544,
      3.488486,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.804650,
      NULL,
      0.626746,
      NULL,
      2.364317,
      NULL,
      88,
      NULL,
      1,
      30.841983,
      70,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.026643,
      NULL,
      1,
      NULL,
      1.884259,
      NULL,
      1,
      NULL,
      3.411689,
      NULL,
      2.380941,
      NULL,
      1.657150,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      0.706502,
      NULL,
      NULL,
      1.536559,
      NULL,
      1.488693,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.040446,
      NULL,
      0.206283,
      NULL,
      1.368420,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.974469,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.040480,
      NULL,
      1.539168,
      NULL,
      1,
      0.803547,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.924095,
      NULL,
      0.443198,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.171800,
      3,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.317697,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.433797,
      0.492001,
      NULL,
      1,
      0.448588,
      0,
      1.691769,
      NULL,
      5,
      1,
      3,
      NULL,
      NULL,
      1,
      0,
      0.757829,
      1,
      0.014886,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      0.927100,
      0.457923,
      NULL,
      0,
      0,
      0,
      1,
      0,
      0.380577,
      0,
      1.989293,
      1,
      0.069981,
      NULL,
      0,
      0.560444,
      3,
      0,
      1.776839,
      1.887025,
      0,
      NULL,
      2.238394,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.171218,
      1.697328,
      1,
      0.657149,
      NULL,
      5.092559,
      8,
      0,
      NULL,
      NULL,
      NULL,
      46,
      2,
      4,
      4.958412,
      '4140',
      '12332',
      NULL,
      1,
      '',
      '',
      '',
      2,
      '3031',
      NULL,
      '');
commit;
end;
/


