set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8808505';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-3-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '0',
      NULL,
      NULL,
      '4434023',
      2.933850,
      0.672862,
      1,
      NULL,
      '1041',
      3,
      0.734835,
      NULL,
      NULL,
      ' 2-20-1993',
      NULL,
      NULL,
      7,
      0.004862,
      1,
      ' 9- 5-1996',
      13,
      0.901216,
      219.147674,
      9,
      0.134606,
      ' 9-12-1999',
      ' 7- 1-1977',
      NULL,
      2.601494,
      0.449995,
      0,
      1.512326,
      NULL,
      0.205947,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      9,
      147,
      9,
      2,
      1.038758,
      8.221330,
      0,
      3.814723,
      0.550185,
      1,
      2.353942,
      1,
      1.951091,
      0,
      1.045742,
      1.411797,
      NULL,
      0,
      1.204573,
      0.673822,
      1.844024,
      NULL,
      3.877766,
      1.331223,
      1.650649,
      1.601134,
      8.078568,
      5.307583,
      1,
      1,
      1,
      3,
      NULL,
      2.949650,
      0,
      9,
      1,
      NULL,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      7,
      NULL,
      1,
      2,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.555793,
      3.827638,
      1.255403,
      4.921365,
      NULL,
      0.706281,
      NULL,
      1.836091,
      0.401392,
      6.398443,
      NULL,
      2.429589,
      1.146545,
      NULL,
      0.365258,
      1.190043,
      1.617758,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.182856,
      1,
      1,
      5.091376,
      4.532291,
      1,
      0,
      0.185706,
      3,
      0,
      0.239094,
      0.555109,
      NULL,
      1,
      NULL,
      0.197561,
      3.731358,
      1,
      0.627919,
      6.193514,
      8.062304,
      8,
      0.848770,
      NULL,
      1.463623,
      0,
      NULL,
      128.696922,
      ' 9-26-1988',
      NULL,
      0.545172,
      5.688465,
      NULL,
      0.862294,
      1.055205,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.339156,
      0.531952,
      0,
      0.821627,
      0.948999,
      1.490851,
      7.512892,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.613496,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.507679,
      1.833701,
      0,
      1.372186,
      0.488159,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.140234,
      NULL,
      0.020954,
      NULL,
      0.967707,
      1.726994,
      NULL,
      2.355468,
      14.963873,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.006999,
      2,
      NULL,
      NULL,
      2,
      3.619758,
      1.003790,
      2,
      1,
      2,
      2,
      3,
      15.788230,
      1,
      NULL,
      NULL,
      25,
      36,
      NULL,
      4.531207,
      0.999116,
      0.539055,
      NULL,
      '',
      '',
      1.621334,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0,
      66,
      NULL,
      8.095845,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.155801,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.733365,
      2.640248,
      3.161208,
      NULL,
      1.771907,
      3,
      NULL,
      NULL,
      NULL,
      2,
      1.194259,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.207358,
      3,
      5.382332,
      NULL,
      NULL,
      NULL,
      4.550612,
      7.624241,
      6.922080,
      0.597923,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1.758131,
      2.938825,
      1,
      NULL,
      NULL,
      0.397152,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.058716,
      NULL,
      NULL,
      1.774410,
      NULL,
      NULL,
      0,
      0,
      0,
      0.528721,
      NULL,
      1.509204,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.445295,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.049161,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.373053,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.746834,
      NULL,
      NULL,
      0.068931,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.052062,
      NULL,
      NULL,
      0,
      3.622658,
      1.888164,
      1.743418,
      NULL,
      NULL,
      3.011537,
      NULL,
      NULL,
      3.717507,
      3.205377,
      1,
      1,
      2.706257,
      1.368124,
      2,
      2,
      1.221428,
      1.118340,
      1.634419,
      0,
      4.241839,
      1.017306,
      9,
      NULL,
      NULL,
      NULL,
      1.031655,
      2.276826,
      0,
      1.895927,
      0,
      0,
      1.087513,
      1.611001,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.346371,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.975596,
      NULL,
      NULL,
      0.310175,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.341747,
      NULL,
      NULL,
      1.771654,
      0,
      0.529058,
      0.774043,
      1,
      0.031388,
      1.094713,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.102096,
      NULL,
      NULL,
      NULL,
      0.859385,
      NULL,
      NULL,
      NULL,
      0.404696,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.767526,
      NULL,
      NULL,
      NULL,
      1.725763,
      NULL,
      NULL,
      NULL,
      1.051001,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.928583,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.414587,
      NULL,
      NULL,
      1351,
      1825.042393,
      0,
      0.564585,
      1.641972,
      1,
      0.778676,
      0,
      NULL,
      1.203015,
      0,
      1.997145,
      0.050648,
      0.653146,
      0.440320,
      1,
      0.747729,
      1,
      1.864529,
      1.086800,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      14.804707,
      NULL,
      NULL,
      18,
      1,
      NULL,
      9.336803,
      0.579219,
      NULL,
      1,
      1.473315,
      NULL,
      17,
      0.172530,
      NULL,
      19.629066,
      1.474117,
      NULL,
      NULL,
      1.094663,
      NULL,
      7,
      NULL,
      NULL,
      2,
      0,
      NULL,
      10,
      NULL,
      NULL,
      8,
      1.667886,
      NULL,
      0,
      1.865423,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      3.391138,
      4.806180,
      3.945047,
      1,
      NULL,
      NULL,
      66.096727,
      NULL,
      NULL,
      NULL,
      3.155903,
      '13222',
      '',
      '',
      1.781266,
      '',
      '',
      '',
      1.465014,
      NULL,
      '',
      NULL);
commit;
end;
/


