set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8003246';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-10-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '3',
      NULL,
      NULL,
      '0332013',
      2.022530,
      1,
      4,
      3,
      '3023',
      0,
      0,
      NULL,
      NULL,
      ' 4-21-1987',
      NULL,
      NULL,
      1.188014,
      3.027303,
      0,
      ' 6- 4-1999',
      21.722338,
      2,
      312.306162,
      75,
      0,
      '11- 5-1977',
      ' 1-24-1990',
      ' 6- 3-1993',
      2.600188,
      3.159177,
      3.221830,
      NULL,
      0.098538,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      4,
      22,
      2.811336,
      13.541881,
      NULL,
      0.726459,
      2.296585,
      1.756011,
      1,
      1.286427,
      1.282230,
      0,
      1.072524,
      0,
      0,
      0.843770,
      NULL,
      1.726949,
      11,
      1.100055,
      4.769429,
      3,
      7,
      0,
      7.618078,
      4,
      0,
      1,
      8,
      1.697169,
      5,
      NULL,
      3.268774,
      0.413742,
      2,
      0.101784,
      4.761543,
      1.642703,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6,
      NULL,
      1,
      0.467109,
      0.362983,
      1.058265,
      0,
      NULL,
      3,
      NULL,
      2.589200,
      0,
      NULL,
      NULL,
      3.854743,
      1.789831,
      2,
      NULL,
      NULL,
      1,
      1.192278,
      0.736750,
      NULL,
      1,
      5,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.894005,
      2.785926,
      0,
      1,
      0,
      0,
      1,
      0.521626,
      0,
      1,
      0,
      1.460448,
      NULL,
      0,
      0.165164,
      1.173639,
      NULL,
      1,
      NULL,
      1,
      2.329924,
      6,
      NULL,
      7,
      10.558721,
      0,
      NULL,
      7,
      5.268840,
      0.590095,
      NULL,
      1,
      7,
      9.243331,
      7,
      NULL,
      3.245340,
      2.540800,
      6,
      2,
      10.200954,
      3,
      5.415577,
      0.839916,
      3,
      ' 8-14-2002',
      3.309190,
      NULL,
      7,
      2,
      0,
      0,
      3,
      1.265805,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.206352,
      0.361354,
      NULL,
      0.696599,
      0.076747,
      0,
      0.049791,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2,
      NULL,
      3,
      3,
      4,
      0,
      1.431352,
      3,
      3.328346,
      13,
      0.948067,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      3.125985,
      0.388304,
      3,
      1,
      0,
      0.952623,
      5,
      2.128180,
      NULL,
      14.100280,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      0,
      NULL,
      1,
      0.092800,
      NULL,
      2,
      48,
      NULL,
      0.393910,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.456388,
      0.518016,
      3.238389,
      2,
      NULL,
      0,
      NULL,
      NULL,
      3.722654,
      0,
      3,
      2,
      2,
      NULL,
      1.859236,
      NULL,
      NULL,
      0.262565,
      0.766670,
      NULL,
      0.872737,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.470718,
      0,
      NULL,
      0.310714,
      NULL,
      6,
      5,
      NULL,
      6.414351,
      NULL,
      1.896830,
      NULL,
      2,
      0.238459,
      0.546808,
      3,
      21.351075,
      NULL,
      3.500420,
      NULL,
      37,
      NULL,
      33.869205,
      2.478788,
      0.258312,
      2,
      NULL,
      NULL,
      '',
      0,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      1.882083,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.441254,
      NULL,
      2.733347,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.324777,
      NULL,
      NULL,
      0.970280,
      NULL,
      NULL,
      4,
      0,
      0.530937,
      0,
      NULL,
      1.195009,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.120487,
      0.877999,
      1.928749,
      0.411510,
      0,
      0,
      1.910469,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.705417,
      NULL,
      0.915704,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.944527,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.312262,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.407700,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.770260,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.526041,
      0,
      NULL,
      1.331012,
      NULL,
      0.038221,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.590363,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      1.912825,
      NULL,
      NULL,
      0,
      0,
      NULL,
      3,
      0,
      1.791516,
      1.986261,
      1.526668,
      1.911794,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.587414,
      NULL,
      1,
      1.830876,
      NULL,
      0.075737,
      2,
      NULL,
      0.391789,
      0.603424,
      NULL,
      NULL,
      0,
      NULL,
      0.102914,
      0.626532,
      NULL,
      1.142840,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.460579,
      0,
      NULL,
      1,
      0,
      0.616570,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.114182,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.600366,
      NULL,
      1,
      NULL,
      0,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      56,
      NULL,
      0.408398,
      NULL,
      '00213',
      '',
      '',
      0.368149,
      '',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


