set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9638589';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-1-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '21',
      '12',
      NULL,
      NULL,
      '2212224',
      1.756188,
      1,
      2,
      3,
      '3243',
      3,
      1.328073,
      NULL,
      NULL,
      ' 3-25-1983',
      NULL,
      5.406385,
      NULL,
      0,
      0.704243,
      ' 9- 8-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      1.455809,
      ' 4- 3-1974',
      NULL,
      ' 7-20-2003',
      3,
      3,
      NULL,
      NULL,
      0.686555,
      0.723237,
      1,
      1.788918,
      0.684066,
      82.698661,
      8,
      NULL,
      2.465038,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3.155087,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.212897,
      NULL,
      7,
      0,
      7.839791,
      1.366888,
      0,
      2,
      6.508052,
      9.875513,
      NULL,
      7.046600,
      1,
      0,
      NULL,
      5.258019,
      2,
      NULL,
      3.525538,
      0,
      2,
      1.334003,
      NULL,
      NULL,
      0.373920,
      NULL,
      NULL,
      8,
      0,
      5.696168,
      1,
      2.684566,
      0,
      3.666289,
      NULL,
      0,
      1,
      1.276866,
      0,
      3.157229,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.081492,
      7,
      5,
      4,
      8,
      0.635465,
      1,
      1.699440,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.786573,
      1.734571,
      0.167239,
      1,
      0.777202,
      3,
      4.064520,
      0,
      1.124066,
      NULL,
      4,
      NULL,
      1,
      NULL,
      1.186417,
      0,
      0,
      NULL,
      0.072469,
      NULL,
      0,
      0,
      0.402187,
      0.680150,
      NULL,
      NULL,
      0.384866,
      6.791437,
      1,
      NULL,
      0.681190,
      NULL,
      0.854181,
      0.247010,
      1.172331,
      2,
      NULL,
      0,
      0,
      NULL,
      8,
      8.111104,
      2.567326,
      3.164931,
      NULL,
      NULL,
      5.462641,
      1,
      ' 2-13-1992',
      NULL,
      '11-26-1996',
      1016,
      0.889786,
      NULL,
      1.978985,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.809682,
      0,
      0,
      0.478492,
      0.065714,
      3.263045,
      2.058047,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.250541,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.091999,
      0,
      1,
      1,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.347314,
      2,
      0.512541,
      0,
      1.340405,
      0.362395,
      1.841723,
      0.671238,
      77.448132,
      2,
      2.261030,
      30,
      NULL,
      8.010460,
      NULL,
      0.790643,
      NULL,
      1,
      2.278610,
      0.072472,
      2,
      2,
      3,
      0,
      1.481545,
      2,
      2.884915,
      3,
      NULL,
      1,
      3,
      NULL,
      1.662127,
      0.205348,
      0,
      1.034049,
      0,
      0.488558,
      1,
      1.972685,
      1.092605,
      0.795823,
      NULL,
      1,
      1.949494,
      0.696183,
      3,
      6,
      2,
      5.666987,
      5.376642,
      6,
      1,
      1.965782,
      NULL,
      NULL,
      0,
      3.902390,
      66,
      NULL,
      0,
      NULL,
      NULL,
      18.568245,
      13.749371,
      NULL,
      5.565689,
      0,
      '23322',
      NULL,
      '',
      1,
      '',
      NULL,
      '',
      1,
      '',
      NULL,
      '',
      1.225221,
      24.851910,
      203,
      11,
      3.285081,
      13.842615,
      11,
      12,
      1.835332,
      2,
      2.620476,
      NULL,
      0,
      NULL,
      NULL,
      0.646838,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.897045,
      1,
      1.572602,
      3.272578,
      1.847551,
      NULL,
      0,
      NULL,
      NULL,
      1.634454,
      NULL,
      NULL,
      3,
      1.634054,
      1,
      3,
      1,
      0,
      7.858117,
      5.656569,
      6,
      0.768076,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.309635,
      2.140355,
      1.261283,
      NULL,
      NULL,
      NULL,
      1,
      1.905813,
      NULL,
      NULL,
      1,
      1.642501,
      0.717391,
      1,
      NULL,
      0.718049,
      1.627123,
      1.233638,
      NULL,
      1.298342,
      NULL,
      NULL,
      1,
      0,
      2.054871,
      2.318732,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.427001,
      1,
      NULL,
      1.430727,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0.239754,
      1,
      NULL,
      NULL,
      2.519373,
      0.369363,
      1.560549,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      0,
      1.398567,
      3,
      1.803821,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.820670,
      NULL,
      NULL,
      1,
      0.761156,
      0.432856,
      NULL,
      0,
      0,
      0.089940,
      NULL,
      NULL,
      0.297616,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      5,
      1,
      NULL,
      NULL,
      2.900793,
      NULL,
      NULL,
      NULL,
      2.249079,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      4,
      3,
      3,
      0,
      NULL,
      NULL,
      3,
      1,
      3.195666,
      3,
      3,
      2,
      NULL,
      10.534568,
      0,
      11,
      0,
      0.994265,
      1.112544,
      3.595445,
      0,
      2.640175,
      0.437226,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.308406,
      NULL,
      NULL,
      0.967880,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.227776,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      1.990210,
      1,
      1.165671,
      0.418960,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.833527,
      NULL,
      NULL,
      NULL,
      1.146674,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.392787,
      NULL,
      NULL,
      NULL,
      2.921988,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.731519,
      NULL,
      NULL,
      NULL,
      0.232320,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.822402,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      1.573353,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      132593.077877,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.025724,
      NULL,
      NULL,
      1.162497,
      NULL,
      0.791964,
      NULL,
      49519,
      NULL,
      0,
      0.659110,
      1.764466,
      0,
      NULL,
      1,
      0,
      NULL,
      1.028417,
      1.140880,
      0,
      0.538607,
      0,
      0.073986,
      1.444233,
      NULL,
      0.678873,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.520124,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.318096,
      0.934353,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.205834,
      NULL,
      1.123700,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15,
      0.029582,
      2.979067,
      NULL,
      1.650182,
      NULL,
      0.530791,
      NULL,
      NULL,
      NULL,
      1.230989,
      NULL,
      1,
      NULL,
      0,
      0.883197,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.161081,
      0,
      1,
      6,
      3,
      1.445356,
      2,
      NULL,
      1,
      NULL,
      3,
      1.268604,
      1,
      2.161202,
      NULL,
      1,
      3,
      NULL,
      0.275005,
      3.614698,
      NULL,
      1.519213,
      NULL,
      NULL,
      0.848415,
      NULL,
      NULL,
      1.484999,
      0.554668,
      NULL,
      NULL,
      NULL,
      NULL,
      0.437650,
      1.566505,
      NULL,
      0,
      1.431332,
      NULL,
      2,
      2.760372,
      NULL,
      0,
      0,
      NULL,
      1.440908,
      1,
      1.669092,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.697819,
      NULL,
      1,
      NULL,
      9,
      12,
      7,
      1,
      0.807231,
      1,
      44,
      40,
      4.762402,
      2.458012,
      1.093617,
      '30024',
      '',
      '',
      1.161993,
      '',
      '',
      '',
      1.350953,
      '',
      NULL,
      '');
commit;
end;
/


