set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6302129';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-11-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      NULL,
      '4224221',
      2,
      0,
      1,
      0,
      NULL,
      1.729482,
      0.180326,
      NULL,
      NULL,
      NULL,
      57,
      NULL,
      0.095074,
      1,
      1.173757,
      NULL,
      48.584790,
      2,
      NULL,
      NULL,
      1.806537,
      ' 2- 4-1992',
      NULL,
      NULL,
      2,
      2.283552,
      2.540087,
      0.109612,
      1,
      0.675837,
      0.715054,
      1,
      0,
      0.702198,
      9.410743,
      11,
      4.151243,
      25.504680,
      NULL,
      7,
      18,
      2.116428,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.340742,
      2.412233,
      2,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      5,
      0,
      1,
      1,
      6,
      1.538797,
      NULL,
      0.359680,
      1.960158,
      NULL,
      NULL,
      NULL,
      2,
      5,
      0,
      NULL,
      4,
      3.833670,
      1,
      0,
      1.871293,
      2,
      1.225886,
      1,
      3.408276,
      0.509497,
      NULL,
      1.985978,
      2,
      NULL,
      3,
      0,
      0.699554,
      0.778444,
      0,
      1,
      5,
      NULL,
      1.732600,
      5.127816,
      1.852978,
      0,
      NULL,
      NULL,
      2,
      5.449025,
      0.556516,
      NULL,
      1,
      2.820534,
      1.821875,
      3.616508,
      3.467308,
      2,
      0,
      1.929522,
      0.211293,
      1.314074,
      0,
      1.394186,
      0,
      1.858051,
      0,
      0.746712,
      0.036412,
      NULL,
      NULL,
      0.225685,
      1,
      0,
      0,
      1.764756,
      NULL,
      4,
      7,
      4,
      NULL,
      3,
      5,
      0,
      6.807921,
      4.547854,
      NULL,
      7.770540,
      0.901343,
      5,
      NULL,
      5,
      0.384415,
      6,
      NULL,
      NULL,
      1,
      5.424490,
      2.676943,
      ' 7- 2-1985',
      41,
      NULL,
      16,
      1.618257,
      0,
      0.087184,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      9,
      1,
      0,
      2.213176,
      1.675572,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      68,
      0.720658,
      NULL,
      4,
      1,
      0,
      1,
      0,
      0,
      NULL,
      1.305702,
      0.800598,
      3,
      2.798007,
      NULL,
      3,
      NULL,
      8.778522,
      4.690239,
      7.538289,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14,
      3,
      0.994858,
      5.529686,
      0.017438,
      5,
      '10- 4-1985',
      NULL,
      ' 1-26-1998',
      11.860520,
      1.299508,
      3,
      NULL,
      0.918662,
      2.394663,
      NULL,
      2.929614,
      1.689645,
      1,
      0,
      2,
      58,
      2.746125,
      0.085047,
      45,
      0.306262,
      140.994655,
      0.859043,
      NULL,
      0.466587,
      NULL,
      3.695428,
      2,
      1,
      0,
      2,
      0.834449,
      2.852184,
      1.965812,
      2.264492,
      NULL,
      12,
      NULL,
      NULL,
      NULL,
      NULL,
      153,
      187.755991,
      39.783912,
      0.632883,
      1,
      0.133249,
      1.464057,
      1,
      1.239519,
      NULL,
      1.438660,
      NULL,
      NULL,
      11,
      10.355430,
      4.671044,
      8,
      0,
      NULL,
      5,
      1,
      2.331958,
      0.112738,
      2,
      2,
      32,
      0.026945,
      0.519696,
      NULL,
      31,
      NULL,
      55.375624,
      2,
      0,
      1,
      NULL,
      '',
      NULL,
      1.101792,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      2,
      28.547353,
      109,
      15.188337,
      2.564529,
      36.374269,
      2.370183,
      11,
      5,
      2.385402,
      1,
      1.259660,
      1.721225,
      NULL,
      NULL,
      0.504300,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.968847,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.752685,
      0,
      0.082422,
      NULL,
      NULL,
      NULL,
      1.108925,
      0,
      0,
      0,
      NULL,
      NULL,
      0.196148,
      NULL,
      NULL,
      1.948121,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.718838,
      0.044667,
      0,
      NULL,
      0.983948,
      2.970336,
      0,
      1,
      1.847667,
      0,
      1.415139,
      1.218585,
      0.174576,
      1,
      2.393836,
      3.711848,
      3.433375,
      NULL,
      2,
      2,
      1,
      0.005470,
      0,
      3.369750,
      1.696229,
      NULL,
      1.939951,
      1,
      NULL,
      NULL,
      1.082875,
      NULL,
      NULL,
      1.143307,
      1,
      0.705421,
      6,
      3,
      4,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      3.721917,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.145481,
      NULL,
      NULL,
      0,
      2,
      0,
      0,
      2,
      1.068118,
      1.791949,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.750095,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.562363,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.150600,
      NULL,
      NULL,
      0.652206,
      NULL,
      NULL,
      3.414374,
      2.657268,
      1,
      NULL,
      NULL,
      NULL,
      5.149215,
      3.763913,
      2.372565,
      4.240752,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.917871,
      NULL,
      0.727697,
      1,
      0.079863,
      1,
      1.680836,
      NULL,
      3.267402,
      6,
      NULL,
      2,
      2,
      2,
      0,
      0,
      NULL,
      NULL,
      1.936810,
      NULL,
      NULL,
      NULL,
      0.125997,
      3,
      4.317510,
      3.800584,
      1.003452,
      0.449411,
      4.892981,
      1.408737,
      1.742548,
      2,
      NULL,
      0.799151,
      0.155941,
      1.398267,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.440389,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.933473,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      0,
      NULL,
      1.191684,
      1.618863,
      NULL,
      1,
      1.415464,
      8.725460,
      NULL,
      NULL,
      0.178961,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.104791,
      NULL,
      NULL,
      1,
      1.806241,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.235007,
      NULL,
      NULL,
      1.386137,
      2,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.006330,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.676360,
      2.678457,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      0,
      2.894101,
      NULL,
      NULL,
      NULL,
      2.366908,
      NULL,
      NULL,
      NULL,
      5.037596,
      NULL,
      NULL,
      5.240636,
      2.617205,
      NULL,
      1.361043,
      NULL,
      NULL,
      NULL,
      0,
      67,
      NULL,
      NULL,
      175,
      16.510218,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2.360195,
      NULL,
      4.116474,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.906356,
      NULL,
      0.486670,
      1.922161,
      1,
      1,
      1.157062,
      NULL,
      1.704676,
      0,
      1,
      1.307893,
      0,
      0.608739,
      1,
      1,
      1.369614,
      0.619153,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.312856,
      2,
      0.462589,
      NULL,
      3.705414,
      0,
      0.207838,
      5.549690,
      NULL,
      3.542770,
      2.960863,
      NULL,
      1.493121,
      0.828179,
      1,
      1.427758,
      1.745164,
      1.934054,
      1,
      0.214043,
      1,
      1.332914,
      1,
      1.645696,
      0,
      NULL,
      NULL,
      1.059732,
      NULL,
      2.675472,
      3.323645,
      1,
      0,
      1.469292,
      3,
      1.504931,
      0.246207,
      1.230912,
      0.775701,
      1.696395,
      NULL,
      NULL,
      1,
      NULL,
      2,
      1,
      1.719433,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.800532,
      0,
      0.292798,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.280548,
      0.657488,
      1.237336,
      7.127916,
      2,
      11,
      2,
      0.584196,
      NULL,
      35,
      88.563948,
      1.873904,
      1.502022,
      3,
      NULL,
      '',
      '',
      0.648864,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


