set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '4801449';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-7-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '4',
      NULL,
      NULL,
      '1443124',
      0,
      NULL,
      2,
      NULL,
      '0341',
      2.520703,
      1.394749,
      NULL,
      NULL,
      ' 9-27-1976',
      66.860350,
      NULL,
      5.404395,
      0,
      1.447790,
      ' 1- 4-1983',
      41,
      2.170410,
      209,
      26,
      1.691502,
      NULL,
      NULL,
      ' 9-20-1999',
      2,
      0,
      2,
      0,
      0.089615,
      NULL,
      2,
      0,
      NULL,
      90,
      3.029855,
      5.779162,
      1.012742,
      13.004421,
      NULL,
      4,
      15,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      4,
      3,
      3,
      0.853598,
      1,
      1.889776,
      1.384963,
      4,
      0.714566,
      1.776046,
      0.724328,
      1.732153,
      NULL,
      0,
      2.904165,
      NULL,
      1.224470,
      1,
      NULL,
      0.846467,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.828531,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.310274,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.177905,
      1.744759,
      NULL,
      NULL,
      1.997515,
      0,
      NULL,
      0,
      1.631438,
      1.886396,
      0.167912,
      0.170813,
      1.489894,
      1.589521,
      NULL,
      0,
      0,
      1,
      1.707709,
      NULL,
      1.102841,
      NULL,
      1.202769,
      1.658620,
      0,
      0.279767,
      0.754364,
      NULL,
      1,
      1.289066,
      0.710995,
      1.698878,
      0,
      1.336294,
      3,
      1,
      NULL,
      NULL,
      2,
      6.907820,
      3,
      4,
      NULL,
      NULL,
      0.854782,
      1,
      0.322462,
      2,
      NULL,
      1287.455538,
      NULL,
      1569,
      3,
      1.830751,
      NULL,
      8.070561,
      0.767266,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.109568,
      1.704244,
      0.521685,
      NULL,
      0,
      0,
      0.309466,
      1.779621,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.633792,
      1.570304,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.994185,
      1,
      5,
      0,
      0,
      2,
      0,
      NULL,
      NULL,
      0.601095,
      1,
      1.531139,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.750507,
      1,
      1,
      0.194696,
      0.528023,
      0,
      0,
      1,
      NULL,
      0,
      1.268157,
      15,
      465,
      1,
      0.741956,
      1.683619,
      NULL,
      3,
      NULL,
      2,
      NULL,
      3,
      3,
      3.833095,
      2,
      NULL,
      3,
      3.154644,
      5.180439,
      NULL,
      1,
      1.082757,
      1,
      NULL,
      1.445070,
      1.879727,
      1,
      1.531036,
      1.398324,
      0,
      NULL,
      1,
      NULL,
      1.702517,
      NULL,
      1,
      8.092349,
      6.798875,
      1.834376,
      4,
      5.349672,
      NULL,
      5,
      2,
      NULL,
      0.576528,
      0.751870,
      2.503652,
      57,
      1,
      NULL,
      119.837171,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.738285,
      '20133',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      0.996890,
      '01010',
      '',
      '',
      3.142759,
      22.516757,
      648,
      18,
      3.824746,
      49,
      1.057779,
      NULL,
      3.737345,
      2.441278,
      0,
      3.185063,
      1.814539,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.374106,
      NULL,
      2,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.063376,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.876035,
      NULL,
      NULL,
      9,
      6,
      NULL,
      NULL,
      0.023435,
      NULL,
      NULL,
      NULL,
      1.170497,
      NULL,
      NULL,
      NULL,
      0.393655,
      NULL,
      NULL,
      1.451867,
      NULL,
      NULL,
      0.196100,
      NULL,
      NULL,
      1.704843,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.979100,
      NULL,
      NULL,
      1.266712,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.859872,
      NULL,
      NULL,
      0.308357,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.301930,
      NULL,
      NULL,
      0.458185,
      NULL,
      NULL,
      0.203086,
      NULL,
      NULL,
      0.518548,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.182765,
      NULL,
      NULL,
      NULL,
      0,
      1,
      6,
      3.794714,
      1.813657,
      0.360464,
      4,
      NULL,
      4.929269,
      4,
      2,
      0.075428,
      2,
      0,
      1.715466,
      2.496982,
      0.388654,
      NULL,
      NULL,
      NULL,
      4.055762,
      2,
      NULL,
      2,
      2.009269,
      1.604928,
      0.603803,
      NULL,
      NULL,
      0,
      0.737232,
      0,
      2,
      3,
      2.387010,
      NULL,
      0.661456,
      0.429877,
      NULL,
      6,
      1.490092,
      NULL,
      NULL,
      3,
      1.499979,
      0.172691,
      0,
      1.622133,
      1.569583,
      0.309602,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.124742,
      NULL,
      NULL,
      0.983821,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.379006,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.506423,
      NULL,
      1.178683,
      1.561508,
      0,
      3.550104,
      1,
      NULL,
      NULL,
      1.120324,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.018168,
      NULL,
      NULL,
      NULL,
      0.694183,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.359226,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.633240,
      111.226531,
      1.890506,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      0,
      0.139261,
      8,
      1,
      0.856745,
      1,
      1.593990,
      1.678007,
      1,
      1,
      1.230960,
      1,
      NULL,
      0.289829,
      1.323574,
      0,
      0,
      0.988305,
      1,
      0,
      0.111703,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.046413,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.460437,
      2.216434,
      NULL,
      1.976624,
      1.613275,
      1.627150,
      NULL,
      NULL,
      2.417574,
      1.935466,
      0.619476,
      1,
      NULL,
      1.621481,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.053830,
      NULL,
      1,
      NULL,
      NULL,
      0.260434,
      1.013477,
      NULL,
      1,
      3,
      NULL,
      3.937460,
      2,
      NULL,
      1.738102,
      1,
      NULL,
      3,
      3,
      NULL,
      1.949940,
      0,
      NULL,
      3,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.414608,
      NULL,
      NULL,
      0,
      NULL,
      0.263973,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.777491,
      NULL,
      0.536880,
      NULL,
      NULL,
      NULL,
      1.108599,
      NULL,
      1.537011,
      NULL,
      0.685161,
      NULL,
      50,
      0,
      NULL,
      0.163473,
      NULL,
      0.398754,
      NULL,
      1,
      NULL,
      2.130882,
      3,
      5.387801,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.460560,
      1,
      2.225861,
      '13310',
      '',
      '',
      1,
      '',
      '',
      '',
      0,
      '40420',
      '',
      '');
commit;
end;
/


