set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9800326';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-3-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1,
      0.736496,
      NULL,
      0,
      NULL,
      2.075254,
      3.499474,
      0,
      '313',
      '43100320',
      35.002400,
      50,
      '0041041',
      NULL,
      1,
      5,
      2,
      '1020',
      0,
      1.254990,
      NULL,
      NULL,
      ' 3- 0-1977',
      21.564326,
      39,
      NULL,
      3,
      3,
      ' 6-28-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-19-1992',
      1.970009,
      NULL,
      0.113872,
      1.246459,
      1,
      3.542124,
      1.775770,
      3,
      NULL,
      NULL,
      NULL,
      0.100199,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      1.219048,
      2,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.578416,
      0.427542,
      0,
      1.638818,
      2.337548,
      1,
      5.737220,
      1.203571,
      NULL,
      0,
      0,
      NULL,
      0.696153,
      5.745644,
      3.622471,
      1,
      6,
      1.287020,
      7,
      8,
      4,
      NULL,
      2,
      0,
      NULL,
      0.431657,
      0.547061,
      0,
      NULL,
      NULL,
      1.248041,
      NULL,
      NULL,
      9,
      0,
      0,
      1,
      NULL,
      1.114820,
      2,
      1,
      1.827351,
      0.209908,
      2,
      1.191434,
      3,
      1.399043,
      2,
      1,
      0.392689,
      3,
      2.961829,
      0.125245,
      3.158069,
      NULL,
      8,
      1,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      1.911561,
      NULL,
      NULL,
      0,
      1.635432,
      1,
      0.855646,
      1.121678,
      0,
      NULL,
      1,
      1,
      NULL,
      1.368940,
      NULL,
      0.079469,
      NULL,
      NULL,
      0.544252,
      0.378446,
      0,
      0.057394,
      NULL,
      1,
      1,
      0.334234,
      NULL,
      0,
      1,
      1.585621,
      1,
      NULL,
      0.455569,
      1,
      0,
      1,
      1,
      1,
      1.780627,
      1.736892,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      1,
      6,
      0.879096,
      1.062308,
      1,
      0,
      ' 1- 5-2001',
      48.639424,
      ' 5- 6-1980',
      47,
      1.203156,
      2.035677,
      0,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.836595,
      1.460713,
      1.649704,
      NULL,
      1.573197,
      0.589918,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.802966,
      NULL,
      NULL,
      NULL,
      NULL,
      5.717937,
      2,
      NULL,
      1,
      1,
      NULL,
      6.847096,
      3.128553,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      5,
      0,
      5,
      1.006961,
      NULL,
      NULL,
      NULL,
      1.300132,
      NULL,
      0.396235,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.653886,
      0.067303,
      0.698847,
      1,
      0.156333,
      0.974900,
      NULL,
      NULL,
      3.731537,
      0.787534,
      NULL,
      NULL,
      NULL,
      3.272324,
      0.439310,
      0,
      0.385164,
      3,
      1,
      0.207255,
      1.985655,
      1.912324,
      1.309425,
      2.496155,
      NULL,
      NULL,
      NULL,
      2.635343,
      3.733531,
      0,
      NULL,
      1,
      0,
      1.636681,
      0.012414,
      0.722030,
      1,
      0.948125,
      1,
      0.199968,
      1.086476,
      0,
      0,
      2.993659,
      0,
      5.922215,
      4.219256,
      0.207458,
      10.202484,
      2.653838,
      5.167945,
      NULL,
      2,
      6.436644,
      NULL,
      NULL,
      3,
      45,
      0.973803,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4.634446,
      5.812416,
      '21020',
      '21410',
      '',
      1,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      3.203133,
      18.310589,
      27,
      11,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.026466,
      0,
      2,
      0.784703,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.946766,
      1.151101,
      1.806719,
      3.823923,
      1.980857,
      0,
      0.199157,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.427133,
      0,
      1,
      0.744739,
      0.105695,
      0,
      3.581071,
      NULL,
      2.362120,
      0,
      NULL,
      NULL,
      5,
      NULL,
      4.306211,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.551210,
      0.668131,
      NULL,
      1.802000,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      1.810672,
      NULL,
      2.277867,
      0.102837,
      NULL,
      NULL,
      NULL,
      0.917520,
      1.273881,
      0,
      0,
      2.129316,
      2,
      0.136557,
      1,
      NULL,
      NULL,
      1,
      3.179340,
      0,
      0.871469,
      0.198584,
      1.513813,
      8,
      7.289762,
      1.981985,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.920738,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      2.316871,
      NULL,
      0.408986,
      NULL,
      NULL,
      1.867550,
      1.844221,
      NULL,
      NULL,
      NULL,
      NULL,
      1.085685,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.533436,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.844577,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.865391,
      NULL,
      NULL,
      1.207082,
      NULL,
      NULL,
      0.280063,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.426731,
      0,
      NULL,
      NULL,
      1,
      1,
      0.463768,
      0.543300,
      4,
      4,
      3,
      3.909276,
      3.180640,
      NULL,
      1.438094,
      0,
      0.995519,
      1,
      3,
      3.202568,
      1.744154,
      3.329664,
      0,
      4.949715,
      6.626190,
      6.452414,
      1,
      NULL,
      NULL,
      3.256279,
      NULL,
      5.917023,
      1,
      1,
      1.797441,
      0.623909,
      NULL,
      0,
      NULL,
      NULL,
      1.065258,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.316509,
      NULL,
      NULL,
      0.331127,
      NULL,
      NULL,
      0.380398,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.110164,
      0,
      NULL,
      0.608113,
      1,
      0.769614,
      1.074145,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.738551,
      NULL,
      NULL,
      NULL,
      3.248214,
      NULL,
      NULL,
      NULL,
      3.057581,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.951145,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.311971,
      NULL,
      NULL,
      NULL,
      0.710902,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      0.436976,
      NULL,
      NULL,
      NULL,
      0.755202,
      NULL,
      5,
      0.938425,
      NULL,
      NULL,
      0.786356,
      NULL,
      NULL,
      1.660753,
      NULL,
      NULL,
      1.814458,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      253.895233,
      2,
      0,
      NULL,
      1.817351,
      1,
      0.326491,
      NULL,
      0.191213,
      1.235763,
      0,
      1.686918,
      0.925357,
      1.333934,
      0,
      1,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.043275,
      1.070536,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.446969,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.187174,
      1.500603,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.733897,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.339738,
      1.428544,
      3,
      1,
      1,
      NULL,
      31.461151,
      1,
      3.211258,
      0.052504,
      0.913513,
      1.552107,
      1,
      0,
      3,
      NULL,
      7.077006,
      0.146186,
      0,
      NULL,
      NULL,
      NULL,
      1.231864,
      0.083186,
      NULL,
      3.282575,
      0.706885,
      0.675609,
      1.625440,
      1.882283,
      3.973912,
      NULL,
      1,
      1,
      0,
      NULL,
      1.383097,
      1.237605,
      NULL,
      NULL,
      0.014140,
      NULL,
      1,
      0.235474,
      NULL,
      1,
      0.309538,
      NULL,
      0,
      NULL,
      NULL,
      1.340161,
      1,
      NULL,
      1.702262,
      1.160598,
      NULL,
      0.518641,
      0,
      NULL,
      1,
      0.925926,
      NULL,
      0,
      0.885916,
      NULL,
      0.668591,
      1.263834,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.337369,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.491328,
      1,
      3,
      0,
      NULL,
      NULL,
      78,
      NULL,
      3,
      2.165597,
      0.449683,
      NULL,
      '10441',
      '',
      1,
      '',
      NULL,
      '',
      1.600953,
      '',
      NULL,
      '');
commit;
end;
/


