set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9430628';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-10-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '0',
      NULL,
      NULL,
      '2410230',
      1,
      0,
      2,
      3,
      '2022',
      NULL,
      1.144732,
      NULL,
      NULL,
      NULL,
      114,
      NULL,
      NULL,
      NULL,
      0,
      ' 2-21-2003',
      40,
      3,
      248,
      82.281663,
      NULL,
      ' 8- 6-1974',
      ' 7- 6-1981',
      ' 4-12-1992',
      3.530176,
      0,
      1.802044,
      0,
      0,
      0,
      0,
      3,
      NULL,
      NULL,
      NULL,
      3,
      3,
      5,
      14.210393,
      4,
      0,
      7,
      NULL,
      4.617787,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      7,
      4,
      1.137786,
      3.550157,
      0.714348,
      1.416304,
      1.746471,
      0,
      2,
      0,
      1.944532,
      0,
      1.982660,
      1.983791,
      1.847885,
      3,
      0.678524,
      0,
      NULL,
      NULL,
      0.271461,
      NULL,
      NULL,
      NULL,
      0.959673,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.004843,
      0.649840,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.888576,
      0,
      6,
      NULL,
      8,
      NULL,
      5,
      1,
      5,
      3,
      7,
      3.943650,
      NULL,
      NULL,
      NULL,
      0.939215,
      1,
      0.895281,
      4,
      2,
      4,
      NULL,
      6.228397,
      0.658894,
      1.362288,
      0.386175,
      5,
      4,
      0,
      1.621384,
      5.992131,
      3,
      0.281873,
      1.705460,
      1.666724,
      NULL,
      3.907170,
      0,
      5.481572,
      2,
      1,
      1.612074,
      0.383951,
      8,
      NULL,
      9,
      NULL,
      1.425269,
      '11- 9-1995',
      1785,
      ' 4-16-2000',
      11,
      2.649465,
      NULL,
      1.163560,
      1.011175,
      1.454186,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1.929312,
      1,
      2,
      2.037763,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.931477,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.797745,
      0.138811,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.995803,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.993945,
      NULL,
      1,
      1,
      NULL,
      1.469857,
      3,
      NULL,
      0.149933,
      2.613144,
      164.278017,
      1969.611953,
      1738,
      0.944209,
      1.139255,
      2,
      NULL,
      3.148545,
      2,
      0,
      2,
      3,
      2.203470,
      3,
      1,
      3.542075,
      1.379209,
      NULL,
      1,
      1,
      NULL,
      1,
      4.329388,
      1.012945,
      1,
      1.862477,
      NULL,
      1.113409,
      NULL,
      0,
      1.533230,
      0.926387,
      0,
      1,
      NULL,
      NULL,
      4.084037,
      1,
      3.419133,
      3,
      NULL,
      0.399050,
      3.246648,
      6.590072,
      1,
      0.657727,
      3.948365,
      61,
      3,
      1,
      NULL,
      31.841528,
      28.433383,
      37.095982,
      NULL,
      3.119531,
      2.259144,
      '21422',
      NULL,
      '',
      0.154240,
      '',
      NULL,
      '',
      0.651967,
      '',
      '',
      '',
      0,
      37.872815,
      312.283594,
      26.296748,
      NULL,
      29,
      4.470747,
      8.644092,
      0,
      3,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.534407,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.691439,
      3,
      0.182816,
      0.061289,
      0,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      6,
      8.497979,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.079360,
      NULL,
      NULL,
      NULL,
      0.514236,
      1.581650,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.964635,
      0,
      2,
      1.487369,
      1.240546,
      2,
      2.600547,
      NULL,
      0,
      0,
      0,
      1,
      1.389267,
      0.912944,
      NULL,
      2,
      0.394086,
      NULL,
      0,
      NULL,
      NULL,
      0.881549,
      1,
      0,
      2.662062,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.874413,
      NULL,
      NULL,
      1,
      2,
      2,
      2.649411,
      1,
      0.711920,
      0,
      NULL,
      NULL,
      2.092930,
      1.837373,
      1,
      1,
      NULL,
      NULL,
      0.207163,
      NULL,
      1,
      0.515107,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.222092,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.017412,
      0,
      NULL,
      NULL,
      NULL,
      1.439091,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.071642,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.776024,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.978327,
      3,
      0,
      3.646582,
      3,
      1,
      1,
      0.845252,
      3.611667,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.391764,
      NULL,
      NULL,
      0.334759,
      NULL,
      NULL,
      0.975698,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      0,
      0.888392,
      0.326131,
      0.519809,
      1,
      0,
      1.855795,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      160,
      42,
      0,
      NULL,
      NULL,
      0.374255,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      93.465411,
      10,
      0,
      NULL,
      NULL,
      0.052816,
      NULL,
      1.838661,
      0,
      38,
      0.705117,
      NULL,
      1.118557,
      NULL,
      0.148941,
      1,
      NULL,
      1.807512,
      0.513453,
      1,
      1,
      1.593313,
      0,
      NULL,
      1.511130,
      0.956198,
      NULL,
      0.713450,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.640023,
      1.079668,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.692562,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.875848,
      NULL,
      NULL,
      1.181249,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.641153,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      2,
      NULL,
      2,
      NULL,
      0.734992,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.243352,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.091326,
      0,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      16.655440,
      NULL,
      0.732407,
      NULL,
      0.576698,
      1.631405,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.725218,
      0.178616,
      1.671062,
      0,
      0,
      3,
      1.323051,
      3.854809,
      NULL,
      1,
      1,
      1,
      NULL,
      1.828814,
      3,
      NULL,
      2.020597,
      3.438543,
      NULL,
      3.472311,
      NULL,
      NULL,
      2.115847,
      3,
      NULL,
      0,
      3.121524,
      NULL,
      0,
      NULL,
      NULL,
      1.843477,
      3,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.427442,
      3.040729,
      1.015183,
      0.307287,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.580672,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      7,
      NULL,
      1,
      NULL,
      NULL,
      56,
      85.027014,
      3,
      NULL,
      3.895798,
      '33330',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      0,
      '',
      NULL,
      '');
commit;
end;
/


