set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9209216';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-2-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3.653061,
      3.557148,
      2,
      NULL,
      4.724220,
      0.315485,
      NULL,
      NULL,
      '102',
      NULL,
      33.381753,
      36.472020,
      '0020224',
      2.583447,
      NULL,
      2,
      NULL,
      '4414',
      0.592306,
      0.340581,
      NULL,
      NULL,
      NULL,
      135.737569,
      40,
      NULL,
      0.822275,
      1,
      ' 3- 7-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 2-29-1983',
      ' 2-17-1992',
      ' 2- 4-1976',
      3,
      2.302398,
      2.308681,
      2.005134,
      NULL,
      0,
      NULL,
      0.673720,
      0,
      7,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      1.658264,
      2.640979,
      0.203929,
      0,
      NULL,
      0.811345,
      NULL,
      1.115643,
      0,
      0,
      NULL,
      3.100391,
      5,
      NULL,
      0,
      NULL,
      0,
      0.462835,
      0.574269,
      1.731217,
      1.997510,
      4.177073,
      6.902778,
      4.482732,
      0,
      5.496676,
      3,
      7,
      5.733833,
      NULL,
      NULL,
      2,
      1.886152,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.633128,
      1.456105,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.416612,
      1,
      1.534685,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.936886,
      1.935100,
      2.827701,
      0,
      5,
      5,
      NULL,
      NULL,
      1.122007,
      1.333646,
      0,
      NULL,
      1.362708,
      NULL,
      NULL,
      1,
      NULL,
      0.030944,
      1,
      NULL,
      0,
      6,
      1,
      NULL,
      0,
      1.742619,
      5,
      4.195280,
      6,
      2.268557,
      0.552552,
      0.059120,
      2.309784,
      5,
      NULL,
      3.508347,
      2,
      10,
      NULL,
      2,
      6,
      NULL,
      4,
      6.159422,
      NULL,
      0,
      5.470212,
      0,
      ' 5-20-1989',
      42.757807,
      ' 5-26-1992',
      26,
      0.316547,
      0.037722,
      NULL,
      4.781693,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.298991,
      0,
      2,
      0.619045,
      NULL,
      NULL,
      0.262017,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.616789,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.441501,
      NULL,
      0.452797,
      0.852014,
      1.376758,
      0,
      0,
      5,
      NULL,
      0.216850,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.516074,
      1.451479,
      1.598662,
      0,
      NULL,
      1,
      1.850893,
      20,
      0,
      1,
      NULL,
      NULL,
      NULL,
      3.584354,
      0.907645,
      0.544948,
      2,
      3.952308,
      1,
      2.548117,
      1.869341,
      NULL,
      2.463084,
      3.329787,
      3,
      1,
      1,
      3,
      NULL,
      1,
      1.016667,
      0.012830,
      2.150893,
      0.695119,
      NULL,
      0.049361,
      1.740917,
      1,
      1.258631,
      0.491676,
      1.645680,
      NULL,
      NULL,
      3,
      1.252016,
      8,
      9,
      3.350689,
      5.466559,
      2,
      1.604004,
      0,
      3,
      1.865461,
      1,
      2.491766,
      0,
      55,
      3.165740,
      1.147561,
      41.676394,
      NULL,
      NULL,
      41,
      1.367560,
      4,
      2,
      '40331',
      '43204',
      '',
      NULL,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      32,
      113.016771,
      13.530344,
      1.545411,
      2,
      NULL,
      2,
      NULL,
      3,
      1,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.486345,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.951275,
      0.522564,
      1.210177,
      1.406710,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      1,
      0.511333,
      NULL,
      NULL,
      NULL,
      NULL,
      0.449975,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.201389,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.531217,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.997496,
      NULL,
      NULL,
      0.345168,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.480391,
      1.938542,
      1.799310,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2,
      1.036189,
      0,
      NULL,
      NULL,
      NULL,
      4.014412,
      0.707086,
      1.515719,
      0.765264,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.525019,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.927353,
      3.204786,
      NULL,
      2.286940,
      2.795588,
      3.720712,
      NULL,
      0,
      3.642720,
      3,
      4,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.888294,
      NULL,
      1.980003,
      2,
      1.023824,
      2.160487,
      1.972859,
      2.712909,
      8.991604,
      NULL,
      NULL,
      0.669799,
      0.198277,
      1.690763,
      3,
      NULL,
      NULL,
      3,
      1,
      0.550175,
      NULL,
      2,
      9,
      9,
      7.864275,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      1.589020,
      1.314043,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.938088,
      2.021814,
      NULL,
      NULL,
      0.464365,
      1,
      0,
      NULL,
      3.800960,
      NULL,
      NULL,
      NULL,
      33.929391,
      NULL,
      NULL,
      NULL,
      3.125783,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.272265,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.779125,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.325268,
      NULL,
      NULL,
      NULL,
      1.106215,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.630283,
      NULL,
      NULL,
      NULL,
      2.170370,
      NULL,
      NULL,
      NULL,
      0.773467,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.495719,
      NULL,
      NULL,
      NULL,
      2.912337,
      1,
      1.602198,
      0.679059,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.291712,
      NULL,
      NULL,
      0.949016,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      141.606314,
      5,
      0.552135,
      NULL,
      0,
      1.205768,
      1.612292,
      0,
      NULL,
      1,
      0.916884,
      1,
      0.144857,
      0.573567,
      0,
      1.929724,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.846611,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.865066,
      0,
      NULL,
      NULL,
      NULL,
      622,
      NULL,
      1.642775,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.879155,
      NULL,
      0,
      0.522443,
      NULL,
      1.213447,
      NULL,
      NULL,
      NULL,
      460,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.649108,
      NULL,
      NULL,
      1.224840,
      1.601470,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.987165,
      NULL,
      NULL,
      NULL,
      NULL,
      2.083376,
      NULL,
      NULL,
      NULL,
      2,
      0.026963,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      55.302141,
      NULL,
      2.798814,
      NULL,
      1.859769,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.483109,
      NULL,
      NULL,
      NULL,
      3.563523,
      NULL,
      0.193533,
      12,
      5.599804,
      NULL,
      1,
      3.356228,
      11,
      0.207870,
      3,
      0.284481,
      0.173752,
      1,
      NULL,
      0,
      0,
      NULL,
      0.613122,
      0.544352,
      NULL,
      0,
      1,
      NULL,
      NULL,
      2.874733,
      NULL,
      1.936704,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.607764,
      NULL,
      NULL,
      1,
      NULL,
      0.106098,
      3.378510,
      NULL,
      0.684791,
      1,
      NULL,
      1,
      0.192878,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      NULL,
      0,
      NULL,
      1.511094,
      NULL,
      0,
      NULL,
      0.817882,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.733276,
      NULL,
      1,
      NULL,
      0.450846,
      NULL,
      1,
      NULL,
      6.473166,
      0.893770,
      NULL,
      1,
      NULL,
      3.726572,
      NULL,
      1.010381,
      NULL,
      2,
      0.370580,
      8,
      0,
      NULL,
      NULL,
      1.359313,
      88.915830,
      2,
      5.332784,
      3.987068,
      '20114',
      NULL,
      '10140',
      1,
      '42032',
      NULL,
      '',
      0.108686,
      '',
      NULL,
      '');
commit;
end;
/


