set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9217062';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-7-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '1',
      NULL,
      NULL,
      '4002443',
      NULL,
      0.110842,
      5,
      1,
      '3004',
      3,
      1.877855,
      NULL,
      NULL,
      ' 1-15-1995',
      NULL,
      NULL,
      2,
      0,
      5,
      ' 3-19-1988',
      NULL,
      5,
      22,
      84,
      1.035908,
      ' 9-12-1986',
      ' 8-17-1990',
      ' 4-15-2002',
      3,
      1,
      1.375725,
      1,
      NULL,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.529482,
      1,
      25.922601,
      4,
      15,
      2,
      1,
      1.301140,
      1.264225,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      2,
      0.003861,
      NULL,
      1,
      1.990507,
      0,
      0.798863,
      0.656496,
      NULL,
      1.301623,
      1,
      1.250424,
      1.275103,
      0,
      8.721606,
      NULL,
      NULL,
      3,
      0,
      1.847894,
      NULL,
      NULL,
      0.350248,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.824806,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.332752,
      0.165481,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.182887,
      4,
      6.199733,
      0.943036,
      5.984072,
      5,
      6.154857,
      0,
      1.720977,
      5.641524,
      NULL,
      1,
      0.632890,
      2,
      0.099246,
      1.171148,
      1.324720,
      0,
      NULL,
      NULL,
      1,
      5.782254,
      6,
      1.664467,
      NULL,
      0.813199,
      4.919310,
      0.338199,
      1.323363,
      0,
      1,
      1,
      1.860091,
      0,
      NULL,
      0.149653,
      0.021982,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      4.487619,
      1.014110,
      1.086771,
      4,
      0.828869,
      ' 2- 0-1979',
      13.735313,
      NULL,
      3,
      0,
      1.653695,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.555576,
      1.624685,
      0.724052,
      NULL,
      1.883352,
      1.897964,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      105.374877,
      1.034401,
      NULL,
      3.449446,
      1,
      0,
      NULL,
      2,
      1.769900,
      NULL,
      NULL,
      2.609383,
      3.781173,
      1.122735,
      1,
      NULL,
      NULL,
      5,
      1.776321,
      1.201563,
      4.467618,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.184930,
      0.518322,
      1.020786,
      2.331135,
      NULL,
      1.574743,
      1.028308,
      2.589478,
      17,
      3.877629,
      0.148793,
      NULL,
      NULL,
      NULL,
      3.980722,
      1,
      2,
      2,
      3.252216,
      NULL,
      2,
      0,
      2.780309,
      NULL,
      2.876390,
      NULL,
      NULL,
      2,
      3.098785,
      3,
      2.386484,
      1,
      1,
      9.750104,
      0.819270,
      1,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      2.177892,
      0,
      NULL,
      0,
      NULL,
      6.290043,
      6.124693,
      0.456720,
      2.901846,
      0.584587,
      3.299615,
      3,
      3.966068,
      1.256897,
      55.979988,
      0.133222,
      1.438606,
      NULL,
      32.578859,
      NULL,
      126,
      0.053827,
      0.442545,
      1,
      '24122',
      '',
      '',
      0.266840,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      NULL,
      2,
      51.780416,
      0.529146,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.581950,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.054682,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.432662,
      NULL,
      NULL,
      1.194502,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.940952,
      NULL,
      NULL,
      1.766380,
      NULL,
      NULL,
      0.562794,
      NULL,
      NULL,
      1.252433,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.691281,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.852098,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.370481,
      NULL,
      NULL,
      1.363704,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.763448,
      NULL,
      NULL,
      0.085052,
      NULL,
      NULL,
      1.357561,
      NULL,
      NULL,
      0.620126,
      NULL,
      NULL,
      0.575915,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.172944,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.963292,
      3,
      3.646625,
      0,
      NULL,
      NULL,
      0,
      2,
      0,
      3,
      2,
      3,
      4,
      2,
      2.737655,
      1.630205,
      1,
      NULL,
      NULL,
      1.340202,
      0.179031,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.463315,
      NULL,
      0,
      1.575200,
      1.167445,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.157921,
      1.022988,
      1,
      0,
      4.681304,
      NULL,
      1.050242,
      NULL,
      NULL,
      3.269509,
      5,
      2.313950,
      0.422150,
      NULL,
      NULL,
      1.938107,
      NULL,
      NULL,
      0.639675,
      NULL,
      NULL,
      503,
      NULL,
      NULL,
      1.682507,
      0.371998,
      NULL,
      0,
      NULL,
      1,
      1.645611,
      0.065837,
      0.679162,
      1.237840,
      1,
      1,
      1,
      0,
      1.273325,
      NULL,
      1.194535,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      7,
      0,
      2,
      NULL,
      0.813468,
      5.234224,
      0.855705,
      1,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.931455,
      3,
      NULL,
      1,
      1.948056,
      NULL,
      1.540141,
      NULL,
      NULL,
      1.949967,
      NULL,
      NULL,
      1.679566,
      0.280877,
      NULL,
      0,
      0.463953,
      NULL,
      0.873886,
      1.293364,
      NULL,
      1,
      1.966971,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.272373,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      2.455946,
      NULL,
      NULL,
      NULL,
      0.511778,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.455414,
      NULL,
      1.035596,
      NULL,
      0.083857,
      NULL,
      0,
      NULL,
      2.637634,
      NULL,
      43,
      0.538414,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.461609,
      5,
      0.203931,
      NULL,
      NULL,
      72.734238,
      38,
      3,
      1.595175,
      3,
      '13322',
      '',
      '',
      1.852194,
      '',
      '',
      '',
      0.592243,
      '',
      '',
      '');
commit;
end;
/


