set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7915727';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-8-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '0',
      NULL,
      NULL,
      '4144341',
      3.292242,
      NULL,
      0,
      1,
      '0323',
      NULL,
      NULL,
      NULL,
      NULL,
      '11-25-2000',
      2.643911,
      NULL,
      1,
      1.903829,
      NULL,
      NULL,
      30,
      2.030167,
      200.747253,
      84.828379,
      0.573704,
      ' 5-20-2001',
      NULL,
      ' 6- 7-1991',
      2.356284,
      1.692996,
      NULL,
      1.713776,
      NULL,
      0,
      5.401729,
      0.637016,
      1.307375,
      35.852402,
      3.143045,
      7.535946,
      NULL,
      168.714266,
      170.572322,
      17.164691,
      13,
      4.220260,
      6,
      8,
      1,
      1.924265,
      0.325701,
      0,
      0,
      1.362898,
      1.618679,
      0.288855,
      0,
      0,
      137,
      10.957010,
      NULL,
      NULL,
      NULL,
      2,
      3.848841,
      NULL,
      1.952385,
      0.548288,
      0,
      2.065756,
      0,
      1,
      1,
      1,
      1,
      2.559865,
      0,
      1,
      1,
      0,
      1.244635,
      NULL,
      NULL,
      0.465317,
      NULL,
      NULL,
      0.296066,
      0.281682,
      1,
      0.024875,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.028873,
      0.141489,
      0.365148,
      1.650688,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.439190,
      NULL,
      1,
      5.072257,
      3.179390,
      NULL,
      NULL,
      1.383712,
      0.752670,
      1,
      NULL,
      NULL,
      4,
      1.062612,
      NULL,
      0,
      1,
      1.160757,
      NULL,
      0.373025,
      3.987751,
      NULL,
      1,
      1.098520,
      0,
      7,
      0,
      0,
      1,
      1,
      0.481220,
      3,
      2,
      5,
      0.367759,
      4,
      0.234065,
      2.700255,
      NULL,
      1.238489,
      4.196316,
      9,
      NULL,
      NULL,
      NULL,
      2,
      2,
      ' 8-22-1985',
      1461.619743,
      NULL,
      29,
      0.215638,
      0.302564,
      1.065502,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.550656,
      1.933948,
      NULL,
      0.987951,
      0,
      1.467123,
      1.030417,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.202708,
      NULL,
      0.161940,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      2.087656,
      9,
      1.538804,
      NULL,
      NULL,
      NULL,
      0.094465,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      0,
      0.545625,
      0.040707,
      2,
      NULL,
      0.969886,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.670021,
      NULL,
      3,
      1.018041,
      7,
      NULL,
      7.252498,
      NULL,
      NULL,
      3.085734,
      2.141552,
      0,
      2,
      17.162252,
      1,
      2,
      NULL,
      0,
      7.428118,
      54,
      NULL,
      0.518403,
      2.545399,
      '43234',
      '',
      '',
      0,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      NULL,
      13.753985,
      86.292534,
      NULL,
      1,
      20.167717,
      NULL,
      9.063554,
      11,
      0,
      NULL,
      1.608116,
      0,
      3.956909,
      2,
      1.181458,
      NULL,
      NULL,
      0.980349,
      NULL,
      NULL,
      0.784031,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      9.720303,
      3,
      NULL,
      0.574151,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.988105,
      NULL,
      NULL,
      1.918086,
      NULL,
      NULL,
      1.408711,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.743752,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.893765,
      NULL,
      NULL,
      0.350756,
      0.444197,
      0,
      1.162159,
      2,
      3.826438,
      1,
      NULL,
      NULL,
      1.082031,
      8,
      3,
      2,
      NULL,
      3,
      1,
      NULL,
      NULL,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0.321848,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.636808,
      NULL,
      NULL,
      1.170969,
      3.239956,
      NULL,
      4.273957,
      3,
      1,
      5.470692,
      2,
      0.867271,
      0,
      NULL,
      NULL,
      NULL,
      1.915275,
      0.206613,
      NULL,
      1,
      1.433177,
      1.457346,
      NULL,
      NULL,
      4.681711,
      0.167946,
      0,
      3.789109,
      16.920280,
      0.495569,
      2,
      1.840269,
      13,
      2.764163,
      0.593609,
      2.870554,
      2,
      3,
      0.829310,
      2.417776,
      8,
      5,
      0.372228,
      2,
      1.319412,
      0.076183,
      3.555389,
      5.387375,
      1.280662,
      1,
      NULL,
      1.478000,
      1.485209,
      2,
      NULL,
      NULL,
      0.358094,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.342327,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.390836,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.355862,
      NULL,
      1.009734,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.434996,
      NULL,
      NULL,
      NULL,
      1.655855,
      NULL,
      NULL,
      NULL,
      3.509802,
      NULL,
      NULL,
      NULL,
      0.783596,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.757410,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      4,
      NULL,
      3,
      157.577504,
      NULL,
      0,
      24.053266,
      396.493804,
      0,
      NULL,
      NULL,
      1.189910,
      1278,
      611.936960,
      1.150452,
      181.275504,
      208,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.175778,
      1788.680318,
      NULL,
      1,
      0.931597,
      NULL,
      1.914965,
      1,
      1.648747,
      1,
      1,
      0,
      NULL,
      1,
      0.976398,
      NULL,
      1,
      1.583640,
      0.386221,
      1.982985,
      1.378215,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.657180,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.687203,
      0.546817,
      4.219141,
      15.695822,
      2.252145,
      NULL,
      1.679346,
      19.375789,
      12,
      NULL,
      17,
      0,
      NULL,
      NULL,
      2,
      NULL,
      11,
      16.435168,
      NULL,
      15,
      NULL,
      NULL,
      15.758884,
      5,
      NULL,
      0.061411,
      6.594793,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      9,
      NULL,
      12,
      7.796472,
      NULL,
      3,
      NULL,
      NULL,
      1.732658,
      1.524875,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      6.253978,
      NULL,
      1,
      3,
      0,
      1,
      25,
      19.934291,
      2.975909,
      0,
      2,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      1.393266,
      '',
      '',
      NULL);
commit;
end;
/


