set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9225698';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-10-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '0',
      NULL,
      NULL,
      NULL,
      0.237668,
      1.478225,
      1,
      NULL,
      NULL,
      2.267806,
      0,
      NULL,
      NULL,
      NULL,
      44,
      NULL,
      NULL,
      2,
      1.150573,
      ' 0-27-1997',
      NULL,
      2,
      265.692460,
      13,
      2,
      ' 0-23-1996',
      ' 9- 7-1986',
      NULL,
      3.524739,
      3.987538,
      0,
      2.321834,
      1,
      3.702650,
      1.576975,
      1,
      NULL,
      NULL,
      NULL,
      4.543941,
      3,
      6,
      12,
      1.551611,
      18.455396,
      0.927246,
      0.318810,
      0,
      0,
      1.183904,
      NULL,
      0.728990,
      NULL,
      1,
      0.455983,
      1,
      0.261478,
      0,
      1,
      2.252551,
      3,
      8.058846,
      0,
      3,
      4.018193,
      2,
      NULL,
      0.688905,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      3,
      1.578917,
      1.735557,
      0,
      NULL,
      1.328749,
      0.814482,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.111577,
      NULL,
      NULL,
      2,
      0.885146,
      1,
      2.891485,
      0,
      1.862859,
      1,
      0,
      1.764370,
      NULL,
      2,
      0.951659,
      1,
      NULL,
      1,
      0,
      1,
      NULL,
      4,
      4.405509,
      NULL,
      5.127309,
      NULL,
      1,
      NULL,
      NULL,
      0.666095,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.729662,
      0.908728,
      0.957084,
      0.990866,
      NULL,
      0.677147,
      1.148056,
      1,
      0,
      1,
      1,
      1,
      NULL,
      1.466559,
      0.882301,
      0.321156,
      NULL,
      NULL,
      0,
      NULL,
      0.488612,
      0.341068,
      0.482901,
      0.380043,
      4.736613,
      1,
      1.423115,
      1.212407,
      NULL,
      NULL,
      2,
      0.728767,
      2,
      2,
      2.267252,
      6.738509,
      0.563840,
      8,
      NULL,
      9.198979,
      5,
      1,
      3.498635,
      2,
      1.636389,
      ' 5- 0-1998',
      16,
      '11-22-1998',
      40.784883,
      0.187021,
      NULL,
      1.304325,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.036118,
      1.357959,
      1.996465,
      1,
      0,
      NULL,
      1.436559,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      0,
      0,
      2,
      NULL,
      0,
      NULL,
      1,
      0.025340,
      0,
      0.613762,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.512814,
      3.439326,
      2,
      6.330495,
      NULL,
      1.165951,
      NULL,
      NULL,
      NULL,
      NULL,
      3.413004,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.921455,
      NULL,
      NULL,
      0.552346,
      0,
      NULL,
      0,
      1,
      10,
      1,
      0.304933,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.515982,
      0,
      NULL,
      1,
      0,
      1,
      1,
      2.993217,
      2,
      2.411795,
      3,
      NULL,
      2.312721,
      2,
      0,
      1.379673,
      0,
      1,
      NULL,
      0.286624,
      1,
      NULL,
      NULL,
      1.042722,
      0,
      0.902142,
      0,
      3,
      1.933555,
      0,
      7,
      6.609384,
      9.866289,
      8.442200,
      NULL,
      3.438350,
      0,
      5.577588,
      2.228841,
      1.992635,
      1.055040,
      NULL,
      3.726144,
      0.319751,
      NULL,
      NULL,
      43.747766,
      NULL,
      2.756439,
      1,
      NULL,
      '12241',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      3,
      11,
      11,
      34.923854,
      NULL,
      NULL,
      NULL,
      2.486602,
      3,
      3.464214,
      2,
      3,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.588677,
      1,
      1,
      NULL,
      NULL,
      2.055799,
      2,
      NULL,
      1.763246,
      NULL,
      NULL,
      NULL,
      2,
      2.791494,
      0.406062,
      3,
      1.612938,
      NULL,
      2.328107,
      5,
      0,
      0.449712,
      NULL,
      NULL,
      NULL,
      1.863622,
      NULL,
      NULL,
      NULL,
      3,
      0.938569,
      3,
      NULL,
      3,
      2,
      0,
      NULL,
      NULL,
      2,
      0,
      1,
      NULL,
      3,
      NULL,
      2.224003,
      3,
      1.755585,
      NULL,
      2.315288,
      0,
      2,
      2,
      0,
      NULL,
      NULL,
      3,
      NULL,
      3,
      1.932591,
      1,
      0,
      3,
      0.346200,
      NULL,
      5,
      NULL,
      NULL,
      0.649503,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.769206,
      NULL,
      NULL,
      1.897834,
      NULL,
      NULL,
      1.258562,
      NULL,
      NULL,
      1.556451,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.558825,
      0,
      NULL,
      NULL,
      4,
      1,
      NULL,
      7.502749,
      6.793019,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0,
      1,
      1,
      NULL,
      NULL,
      0,
      1.876163,
      3,
      0.927027,
      NULL,
      4.225555,
      1,
      0.249337,
      NULL,
      0.607954,
      1.341970,
      NULL,
      3,
      2.909989,
      1,
      2,
      NULL,
      0,
      5.513676,
      7,
      NULL,
      0.535617,
      1,
      2,
      NULL,
      1.225662,
      NULL,
      1.774332,
      1.505000,
      0.784314,
      NULL,
      NULL,
      1.180191,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.561088,
      NULL,
      NULL,
      1.805710,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.964988,
      NULL,
      NULL,
      1.275647,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.604893,
      NULL,
      2.638686,
      0.524392,
      NULL,
      0.203328,
      2.803199,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.751828,
      1.161366,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.880211,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.486538,
      NULL,
      NULL,
      NULL,
      1.319487,
      NULL,
      NULL,
      NULL,
      1.985160,
      NULL,
      NULL,
      NULL,
      0,
      1.639021,
      NULL,
      NULL,
      1,
      0.691547,
      NULL,
      NULL,
      NULL,
      3.767472,
      NULL,
      NULL,
      1,
      1.733095,
      NULL,
      NULL,
      1.520960,
      1.103805,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.029354,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3.324739,
      2,
      1.386286,
      3,
      0.310707,
      0.620800,
      0,
      2.524486,
      1.704883,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.133089,
      3.166310,
      2.317282,
      0,
      NULL,
      0,
      3,
      0,
      1,
      1.096321,
      0.071945,
      1.279240,
      1,
      NULL,
      1,
      0.427002,
      0,
      1,
      1,
      1.483686,
      0,
      1,
      NULL,
      NULL,
      1.152568,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.294680,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.283310,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.036517,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.992014,
      NULL,
      1.589061,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.927807,
      NULL,
      0.533991,
      NULL,
      1.664918,
      0.958859,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.917929,
      0,
      4,
      1.101800,
      2,
      0,
      2.830479,
      5.767625,
      0,
      2,
      NULL,
      1.440598,
      0.106861,
      NULL,
      0,
      0.080191,
      NULL,
      NULL,
      NULL,
      NULL,
      0.202825,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.462030,
      0.281804,
      NULL,
      1.898884,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      0.618698,
      NULL,
      1.614077,
      1,
      NULL,
      1.698183,
      1.969697,
      NULL,
      3,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.912050,
      NULL,
      0,
      NULL,
      5.211706,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      96,
      1.986567,
      0,
      0.569167,
      '21010',
      '',
      NULL,
      1.213826,
      '',
      NULL,
      '',
      1,
      NULL,
      '',
      NULL);
commit;
end;
/


