set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9691800';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-3-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '02',
      NULL,
      3,
      40,
      NULL,
      3,
      1,
      1,
      NULL,
      '4410',
      0,
      0,
      NULL,
      NULL,
      NULL,
      82,
      1.986305,
      NULL,
      0.080222,
      NULL,
      '11-25-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      ' 5-27-1995',
      NULL,
      3,
      3,
      1.732750,
      2.950951,
      2.370170,
      3.036646,
      2,
      1,
      1.881170,
      23.891032,
      6,
      3,
      0.427239,
      NULL,
      NULL,
      NULL,
      NULL,
      1.523177,
      1,
      NULL,
      0.071261,
      1,
      1,
      1.709334,
      NULL,
      0.528311,
      0,
      0,
      0.180886,
      1,
      NULL,
      NULL,
      3,
      7.830180,
      NULL,
      1.101163,
      NULL,
      0,
      1.704719,
      0.732384,
      0.352476,
      3.400459,
      NULL,
      1,
      0,
      NULL,
      1.309321,
      3.170748,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      3.120035,
      0,
      2.804350,
      0.138244,
      NULL,
      0.159499,
      1.758846,
      1,
      0.922734,
      NULL,
      0.512607,
      0.959934,
      0,
      1.186475,
      1,
      3,
      NULL,
      3,
      0,
      0.425879,
      1,
      3,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.851776,
      5,
      0.257134,
      0.629513,
      5,
      0,
      0,
      1.380427,
      1,
      1.400500,
      1,
      1,
      1.031861,
      1.767157,
      1,
      0.367733,
      NULL,
      NULL,
      1,
      NULL,
      0.358633,
      1.865478,
      3,
      1,
      0.370423,
      1,
      3.332603,
      1.558571,
      0.999679,
      1,
      1,
      0,
      1,
      1,
      1.824648,
      5.465665,
      5.805484,
      2.985396,
      3.020492,
      0.350282,
      7.796811,
      2,
      4.225686,
      4.440987,
      0,
      1.928456,
      1.667230,
      2,
      ' 1-15-1996',
      826.206173,
      ' 2-14-1994',
      NULL,
      1.334430,
      0.870051,
      0,
      1.304149,
      1.123097,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.420439,
      1.059036,
      0.968905,
      1,
      1,
      0.458613,
      1.843813,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.301381,
      0,
      NULL,
      2.464308,
      0,
      NULL,
      NULL,
      NULL,
      0.847022,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.337706,
      2,
      0.736168,
      0,
      1,
      0.896468,
      1.730099,
      NULL,
      7,
      1,
      1.745332,
      NULL,
      NULL,
      NULL,
      3.073929,
      0.902734,
      0.997137,
      3,
      4,
      2,
      5,
      3,
      3,
      5.760207,
      1.517404,
      3,
      3,
      2.757039,
      3.632173,
      NULL,
      3.925533,
      1.240905,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.048438,
      0.084421,
      NULL,
      1.644652,
      1,
      0,
      3,
      0,
      1.626312,
      5,
      11.929726,
      NULL,
      8,
      9.877037,
      NULL,
      NULL,
      3.862564,
      2,
      1.069974,
      0,
      3.225473,
      NULL,
      2.243310,
      0,
      NULL,
      NULL,
      22.749531,
      35.152248,
      NULL,
      0,
      0,
      '40200',
      '',
      NULL,
      1.941166,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      0,
      13.240803,
      246.488617,
      43.474779,
      1,
      NULL,
      2,
      0,
      NULL,
      1.872960,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.763105,
      NULL,
      NULL,
      0.973454,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.989974,
      NULL,
      NULL,
      1.667581,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.683805,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.012131,
      NULL,
      NULL,
      1.604815,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.824064,
      0.502409,
      1,
      NULL,
      NULL,
      NULL,
      3.052294,
      NULL,
      0.035836,
      1,
      0.596586,
      3,
      3,
      0.068286,
      NULL,
      3,
      NULL,
      0,
      3,
      1.882512,
      NULL,
      1,
      0.825628,
      NULL,
      1.161078,
      NULL,
      NULL,
      1.446236,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      9.827234,
      4,
      NULL,
      0.787225,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.243645,
      NULL,
      NULL,
      0.490577,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.071880,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.357633,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.469201,
      NULL,
      NULL,
      2.782932,
      0,
      NULL,
      NULL,
      0,
      1.607891,
      0,
      0,
      1,
      2,
      0,
      0.774303,
      1.027611,
      1,
      NULL,
      3.156575,
      1,
      0,
      1,
      NULL,
      NULL,
      2.578626,
      0.671873,
      NULL,
      0,
      1.490500,
      0,
      1.275927,
      NULL,
      NULL,
      0.688747,
      0,
      7.650376,
      NULL,
      1.672103,
      1,
      0.423100,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.900609,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.593351,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.900207,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      1.840204,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4.994470,
      NULL,
      NULL,
      NULL,
      0.733471,
      NULL,
      NULL,
      NULL,
      2.317143,
      NULL,
      NULL,
      NULL,
      1.870506,
      0.498681,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.311679,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.146698,
      NULL,
      NULL,
      NULL,
      1.399054,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.053114,
      NULL,
      NULL,
      1,
      1.097231,
      NULL,
      NULL,
      NULL,
      1.215790,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      0.080240,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.324185,
      NULL,
      NULL,
      4,
      0.481708,
      NULL,
      NULL,
      0.817454,
      1,
      0,
      1,
      3.771162,
      NULL,
      8.561692,
      3.820456,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.475187,
      NULL,
      NULL,
      1.033483,
      NULL,
      NULL,
      0.955614,
      NULL,
      NULL,
      1,
      NULL,
      1.976599,
      65,
      17,
      1,
      1.569163,
      1,
      0.890419,
      1.901391,
      0,
      1.331041,
      1,
      1.875992,
      1.870718,
      NULL,
      1.413754,
      0,
      0.760941,
      1,
      1.110146,
      0,
      0.979129,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.991495,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.117778,
      0.463941,
      0.927343,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.740146,
      0.462725,
      1.114880,
      0.064702,
      0,
      NULL,
      NULL,
      1.512584,
      1,
      NULL,
      NULL,
      1,
      0.640557,
      0.263600,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.521206,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.914736,
      NULL,
      1,
      NULL,
      1.643299,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.922084,
      0.598323,
      0.747792,
      0,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      1,
      0,
      1,
      NULL,
      1.546942,
      1,
      1,
      1.365701,
      1.382295,
      1,
      1,
      NULL,
      NULL,
      1.777124,
      1,
      1,
      0.212532,
      NULL,
      0,
      NULL,
      0.652261,
      NULL,
      1.419211,
      1.369464,
      NULL,
      1,
      0,
      NULL,
      1,
      1,
      0.528510,
      NULL,
      2,
      1.065155,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.937553,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.325479,
      0,
      0.689378,
      NULL,
      1,
      0,
      NULL,
      5.611664,
      6.391541,
      0,
      NULL,
      NULL,
      NULL,
      2.580177,
      3.891643,
      5.457364,
      0.770285,
      NULL,
      '',
      NULL,
      NULL,
      '',
      NULL,
      '',
      1.358745,
      '',
      '',
      '');
commit;
end;
/


