set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8912976';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-6-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '1',
      NULL,
      NULL,
      '1301003',
      0.085286,
      0.506906,
      NULL,
      2,
      '2400',
      1,
      1,
      NULL,
      NULL,
      ' 7-29-2000',
      30,
      NULL,
      0,
      1.452453,
      0,
      ' 7-11-2002',
      38.056435,
      3.002140,
      NULL,
      2.258867,
      0,
      NULL,
      NULL,
      ' 0- 2-2003',
      0,
      1,
      3.866831,
      2.445611,
      1,
      2,
      1,
      NULL,
      0,
      165.979106,
      8,
      17.231434,
      5.791027,
      84.492298,
      5,
      6.692673,
      10.397491,
      NULL,
      NULL,
      3.242037,
      1.461211,
      0,
      0.816590,
      1,
      0,
      1.061169,
      NULL,
      0.847089,
      1,
      0,
      NULL,
      4,
      3.257770,
      7.802901,
      2,
      1,
      1,
      5.819078,
      1.891889,
      0,
      0,
      4.181345,
      6.261487,
      0,
      1,
      NULL,
      0.951826,
      NULL,
      NULL,
      2.099388,
      1,
      3.886199,
      1.549375,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.116420,
      4,
      2,
      2.492514,
      1.340480,
      NULL,
      NULL,
      2,
      3,
      1.528278,
      NULL,
      2.396791,
      0,
      2.239700,
      0.689714,
      3.133651,
      NULL,
      3.493773,
      0.763874,
      NULL,
      3.291985,
      4,
      1,
      0,
      NULL,
      0.843852,
      0.808228,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.342378,
      1.102584,
      NULL,
      1.217161,
      0,
      5.211301,
      6.081672,
      1.247415,
      3.036310,
      4,
      NULL,
      0.671390,
      3.121371,
      7.132947,
      NULL,
      0,
      0.810753,
      0.956592,
      1.223134,
      0.174799,
      3,
      4.250039,
      5,
      NULL,
      0,
      1,
      NULL,
      7,
      5.319440,
      0.521682,
      7,
      NULL,
      3,
      6,
      5.773425,
      1,
      NULL,
      2.439329,
      NULL,
      NULL,
      NULL,
      5,
      6,
      4.639004,
      2.148709,
      4.788052,
      11,
      NULL,
      ' 9-20-1983',
      NULL,
      ' 6-28-1989',
      865.208107,
      NULL,
      1,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.345366,
      NULL,
      NULL,
      1,
      NULL,
      0.863832,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.130381,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.063175,
      NULL,
      5,
      3,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.621847,
      0.278871,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.475779,
      0,
      2,
      0,
      1.796004,
      1,
      96.679460,
      1.262916,
      3.769333,
      30,
      NULL,
      27,
      3,
      NULL,
      1,
      1.625409,
      3,
      2,
      0.933552,
      NULL,
      2.931083,
      0.476738,
      0.575002,
      0,
      0.168568,
      0,
      2,
      9,
      0.521948,
      1.450655,
      0.936301,
      0,
      2,
      0,
      NULL,
      0.162483,
      1.237138,
      0,
      1.713490,
      NULL,
      0,
      1,
      5,
      NULL,
      NULL,
      7,
      1,
      0.907248,
      5,
      4,
      2,
      3,
      1,
      0,
      2.232892,
      1.571631,
      NULL,
      NULL,
      3.839664,
      NULL,
      NULL,
      25,
      30,
      1,
      1,
      6,
      '03444',
      '03231',
      '04031',
      1,
      '',
      '',
      '',
      5.867427,
      '04440',
      '1334',
      '',
      0.675615,
      NULL,
      215,
      5.809236,
      0.333283,
      28.739143,
      NULL,
      148,
      0,
      0,
      2.352793,
      0,
      1.182855,
      NULL,
      NULL,
      3.549693,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0.395091,
      NULL,
      NULL,
      0.777776,
      1.324043,
      2.934558,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.746511,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.876640,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      5,
      2.483329,
      0.726602,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.420547,
      0.151975,
      3,
      3.718093,
      1.466510,
      1.311303,
      3.825293,
      NULL,
      3.937173,
      NULL,
      NULL,
      1,
      3.871520,
      0.461186,
      3.696451,
      3.129632,
      0,
      NULL,
      NULL,
      0,
      1.134609,
      NULL,
      2,
      2,
      2.535441,
      3.855892,
      1.057973,
      3.179363,
      1.356284,
      NULL,
      NULL,
      3.275555,
      0.512208,
      NULL,
      5,
      NULL,
      8,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      3,
      1.557573,
      3.649883,
      0,
      NULL,
      1,
      NULL,
      NULL,
      5,
      7,
      0.824507,
      2,
      3.697393,
      2,
      NULL,
      NULL,
      NULL,
      2,
      5,
      2,
      NULL,
      NULL,
      NULL,
      1.342593,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.063840,
      NULL,
      NULL,
      0.766778,
      NULL,
      0.398920,
      3.896315,
      NULL,
      NULL,
      NULL,
      1.696442,
      2,
      0,
      1.729699,
      3,
      NULL,
      4.127113,
      2,
      5,
      NULL,
      0.333983,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.745112,
      3,
      NULL,
      2,
      3.001578,
      3,
      1.039736,
      8.757840,
      1,
      2,
      2.326698,
      NULL,
      1,
      0.953690,
      3.902590,
      1,
      NULL,
      0.031553,
      2,
      0,
      0,
      11.746842,
      10.492869,
      1,
      NULL,
      4.120840,
      5.724663,
      NULL,
      4.284423,
      NULL,
      NULL,
      0.078176,
      1.088182,
      0,
      1,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.605073,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.239657,
      NULL,
      NULL,
      1.726543,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.072480,
      NULL,
      NULL,
      0.703794,
      NULL,
      NULL,
      0.471173,
      1,
      0.878815,
      0,
      0.114163,
      NULL,
      1.590016,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.488552,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.639231,
      NULL,
      NULL,
      NULL,
      0.622040,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.892642,
      NULL,
      NULL,
      NULL,
      1.075362,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      6,
      5.198958,
      3.694955,
      NULL,
      94.300145,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      4.334769,
      3.042147,
      110.214102,
      NULL,
      0,
      0,
      2,
      NULL,
      NULL,
      0.676689,
      236,
      7.162810,
      0.327283,
      0,
      0.886857,
      NULL,
      NULL,
      NULL,
      1.045298,
      NULL,
      0.085626,
      2,
      0,
      1,
      1,
      0.148632,
      0,
      NULL,
      0,
      0.632909,
      NULL,
      1,
      NULL,
      2,
      NULL,
      0.366710,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      87.507057,
      NULL,
      3.474995,
      NULL,
      19,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.006730,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.611845,
      NULL,
      0.782514,
      NULL,
      1.736399,
      NULL,
      1.600349,
      NULL,
      1,
      NULL,
      0.780675,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.228121,
      1,
      1,
      NULL,
      NULL,
      0.950612,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.016470,
      NULL,
      1,
      NULL,
      0.294677,
      NULL,
      1.709048,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.112795,
      1.331017,
      NULL,
      1.472411,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.260124,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      1.680678,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.491070,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.463974,
      NULL,
      NULL,
      0,
      NULL,
      1.783206,
      NULL,
      NULL,
      NULL,
      1.760410,
      1,
      2.635369,
      NULL,
      0,
      NULL,
      3.930675,
      NULL,
      NULL,
      NULL,
      3.315200,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      15,
      28.425707,
      1.073375,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.640908,
      1.934688,
      1,
      3,
      1.762823,
      NULL,
      NULL,
      0,
      0.998701,
      0,
      0,
      NULL,
      NULL,
      1.420159,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.885248,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.702856,
      1,
      NULL,
      1,
      0.344644,
      NULL,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      0.328163,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.515910,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.190115,
      NULL,
      0.918291,
      2.579787,
      4,
      1,
      1,
      3,
      65.373682,
      89.248904,
      3.761227,
      0.803455,
      7,
      '41244',
      '42113',
      '23234',
      1.349960,
      NULL,
      NULL,
      '',
      NULL,
      '12130',
      '4000',
      NULL);
commit;
end;
/


