set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9656604';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-4-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '13',
      '12',
      NULL,
      NULL,
      '4040320',
      1,
      1,
      6,
      0,
      NULL,
      4.241900,
      0.051283,
      NULL,
      NULL,
      ' 2-15-1979',
      26,
      10.078774,
      NULL,
      2.501353,
      0,
      '10- 6-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 0-1981',
      ' 4-22-1992',
      NULL,
      0,
      0,
      1.271018,
      1,
      NULL,
      NULL,
      1,
      0.607217,
      1.819184,
      4,
      4,
      15,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      0,
      0,
      1,
      2,
      1,
      1.124741,
      7,
      0,
      1,
      2.852465,
      NULL,
      NULL,
      1.807680,
      3.449764,
      0.587240,
      7.935995,
      0,
      2,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.898685,
      1.369314,
      3.417435,
      0.707974,
      0.264698,
      0,
      2,
      NULL,
      2.444348,
      3,
      1.702941,
      1.824544,
      1.356508,
      0,
      1.858469,
      1,
      0,
      0,
      NULL,
      0.494957,
      1.591724,
      1,
      2.131705,
      1.774619,
      5,
      1,
      0.848936,
      NULL,
      NULL,
      0.412631,
      NULL,
      NULL,
      NULL,
      0,
      4.689002,
      NULL,
      7.177697,
      1.147691,
      2,
      1.706729,
      0,
      0,
      0.140200,
      0,
      0.038166,
      2.597746,
      0.079678,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.140729,
      5.338436,
      NULL,
      1.209364,
      0,
      1,
      NULL,
      5.959197,
      NULL,
      NULL,
      0,
      6,
      0,
      6,
      NULL,
      NULL,
      4,
      1,
      4.898255,
      NULL,
      3.223377,
      9,
      NULL,
      3.244830,
      NULL,
      3.294181,
      3.232464,
      3,
      ' 7-24-1974',
      257,
      ' 4-27-2003',
      80,
      2.192828,
      0,
      1,
      7.303649,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.246437,
      NULL,
      1.605901,
      1.613848,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      2,
      3.071924,
      3.992353,
      1.330670,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.011270,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.763475,
      NULL,
      0,
      NULL,
      NULL,
      5,
      2.161479,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1.129693,
      NULL,
      0,
      NULL,
      2.299341,
      40.559354,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.694814,
      1.818536,
      3.153375,
      3.472963,
      3,
      NULL,
      0,
      0.653800,
      2,
      2.545371,
      2.103876,
      NULL,
      2,
      0.608893,
      1,
      0.667810,
      0.487203,
      0.056768,
      1,
      0,
      0.133230,
      1.548723,
      NULL,
      1.032331,
      0.531774,
      0,
      1.015978,
      1,
      4,
      7,
      7,
      9.981068,
      10.461226,
      3,
      5.373802,
      3,
      5,
      3.300669,
      1,
      NULL,
      14.844062,
      1.183731,
      2,
      41.225068,
      NULL,
      5.928294,
      NULL,
      4.587092,
      NULL,
      4,
      '32423',
      NULL,
      '',
      1,
      '',
      '',
      NULL,
      1.998473,
      '',
      '',
      NULL,
      3,
      29,
      66,
      NULL,
      0,
      35.556235,
      0.384508,
      NULL,
      3,
      3.721853,
      NULL,
      2.924526,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.949701,
      0,
      0.023595,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.557531,
      NULL,
      1.389200,
      NULL,
      NULL,
      0.428381,
      1.214239,
      3.762578,
      1.641603,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.720548,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.128763,
      1.174617,
      2.899366,
      0,
      NULL,
      NULL,
      1.309955,
      NULL,
      NULL,
      3,
      1.890655,
      0,
      2,
      3.908137,
      1,
      1,
      3.642991,
      0,
      0,
      NULL,
      1.015043,
      NULL,
      0.828026,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.353027,
      NULL,
      NULL,
      4,
      3,
      6.694648,
      1.957694,
      1.512678,
      NULL,
      NULL,
      NULL,
      1.832880,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.172324,
      2.413476,
      NULL,
      1,
      NULL,
      NULL,
      2.282220,
      NULL,
      3,
      0.684705,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.389482,
      NULL,
      NULL,
      0.522602,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.386739,
      0.058680,
      0.507719,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      7,
      4.488928,
      6.863669,
      0,
      NULL,
      NULL,
      1.332660,
      NULL,
      NULL,
      2,
      NULL,
      0.458127,
      1.922070,
      NULL,
      NULL,
      NULL,
      NULL,
      6.157155,
      0.494235,
      NULL,
      1,
      0.295760,
      1,
      1,
      0,
      2,
      0.887717,
      2.880991,
      1.624543,
      3,
      5.409433,
      7.778524,
      1,
      3.663171,
      0,
      0,
      2.155026,
      NULL,
      6.952769,
      0.662005,
      0,
      NULL,
      0.905593,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.318064,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.873822,
      NULL,
      NULL,
      1.392142,
      NULL,
      NULL,
      NULL,
      1.642893,
      0.511102,
      1,
      NULL,
      0.816503,
      0.224534,
      NULL,
      NULL,
      0.849885,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.881714,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.549277,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.506330,
      NULL,
      NULL,
      NULL,
      1.242897,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      7.167105,
      NULL,
      NULL,
      NULL,
      3.979698,
      1.089959,
      NULL,
      NULL,
      0.620029,
      3.271992,
      437,
      0,
      NULL,
      NULL,
      1.039959,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.921834,
      129.541008,
      1.123076,
      0,
      0,
      2,
      0.234818,
      NULL,
      1,
      3.346497,
      0.619646,
      1.571941,
      0.150807,
      0.966920,
      0,
      0,
      1.052411,
      1.033218,
      0,
      0.013989,
      NULL,
      0.596531,
      NULL,
      1,
      NULL,
      1.196088,
      NULL,
      1.195121,
      NULL,
      0.489057,
      NULL,
      115,
      NULL,
      1.862636,
      NULL,
      2.977622,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.767414,
      NULL,
      0.780718,
      NULL,
      1,
      NULL,
      0.111492,
      NULL,
      1,
      NULL,
      1.452138,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.389922,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.904184,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.745565,
      0.930586,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.295944,
      NULL,
      0,
      NULL,
      0.600453,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.310489,
      6,
      0,
      1,
      NULL,
      NULL,
      0.644230,
      4.572683,
      5.215563,
      3.504307,
      2.944624,
      1,
      0,
      0,
      NULL,
      1,
      1,
      NULL,
      0.213060,
      1,
      NULL,
      NULL,
      0.630884,
      NULL,
      1,
      1.790132,
      NULL,
      3,
      2,
      NULL,
      2,
      3.336083,
      NULL,
      2.111325,
      NULL,
      NULL,
      1,
      2,
      NULL,
      3,
      1.789180,
      NULL,
      NULL,
      1.970143,
      NULL,
      2,
      1.171427,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.242513,
      NULL,
      2,
      NULL,
      1,
      NULL,
      1,
      NULL,
      3.925691,
      NULL,
      2.792820,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.543750,
      NULL,
      20,
      3.306665,
      NULL,
      0,
      NULL,
      1.817649,
      NULL,
      NULL,
      NULL,
      2,
      9,
      2,
      0.764732,
      1,
      0,
      1.262959,
      70.103765,
      NULL,
      1,
      NULL,
      '43232',
      '30121',
      '',
      0,
      '',
      NULL,
      '',
      1.194477,
      '',
      '',
      '');
commit;
end;
/


